/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.portal.instances.internal.resource.v1_0;

import com.liferay.headless.portal.instances.dto.v1_0.Admin;
import com.liferay.headless.portal.instances.dto.v1_0.PortalInstance;
import com.liferay.headless.portal.instances.internal.resource.v1_0.BasePortalInstanceResourceImpl;
import com.liferay.headless.portal.instances.resource.v1_0.PortalInstanceResource;
import com.liferay.petra.lang.SafeCloseable;
import com.liferay.portal.instances.service.PortalInstancesLocalService;
import com.liferay.portal.kernel.exception.UserEmailAddressException;
import com.liferay.portal.kernel.exception.UserScreenNameException;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.auth.EmailAddressValidator;
import com.liferay.portal.kernel.security.auth.ScreenNameGenerator;
import com.liferay.portal.kernel.service.CompanyService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.auth.EmailAddressValidatorFactory;
import com.liferay.portal.security.auth.ScreenNameGeneratorFactory;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.vulcan.pagination.Page;
import java.util.ArrayList;
import java.util.Optional;
import javax.servlet.ServletContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/portal-instance.properties"}, scope=ServiceScope.PROTOTYPE, service={PortalInstanceResource.class})
public class PortalInstanceResourceImpl
extends BasePortalInstanceResourceImpl {
    @Reference
    private CompanyService _companyService;
    @Reference
    private PortalInstancesLocalService _portalInstancesLocalService;
    @Reference(target="(&(original.bean=true)(bean.id=javax.servlet.ServletContext))")
    private ServletContext _servletContext;
    @Reference
    private UserLocalService _userLocalService;

    @Override
    public void deletePortalInstance(String portalInstanceId) throws Exception {
        Company company = this._companyService.getCompanyByWebId(portalInstanceId);
        this._companyService.deleteCompany(company.getCompanyId());
        this._portalInstancesLocalService.synchronizePortalInstances();
    }

    @Override
    public PortalInstance getPortalInstance(String portalInstanceId) throws Exception {
        return this._toPortalInstance(this._companyService.getCompanyByWebId(portalInstanceId));
    }

    @Override
    public Page<PortalInstance> getPortalInstancesPage(Boolean skipDefault) throws Exception {
        boolean finalSkipDefault = GetterUtil.getBoolean((Object)skipDefault);
        ArrayList portalInstances = new ArrayList();
        this._companyService.forEachCompany(company -> {
            if (!finalSkipDefault || this._portalInstancesLocalService.getDefaultCompanyId() != company.getCompanyId()) {
                portalInstances.add(this._toPortalInstance((Company)company));
            }
        });
        return Page.of(portalInstances);
    }

    @Override
    public PortalInstance patchPortalInstance(String portalInstanceId, PortalInstance portalInstance) throws Exception {
        Company company = this._companyService.getCompanyByWebId(portalInstanceId);
        String virtualHostname = GetterUtil.getString((String)portalInstance.getVirtualHost(), (String)company.getVirtualHostname());
        String domain = GetterUtil.getString((String)portalInstance.getDomain(), (String)company.getMx());
        return this._toPortalInstance(this._companyService.updateCompany(company.getCompanyId(), virtualHostname, domain, company.getMaxUsers(), company.isActive()));
    }

    @Override
    public PortalInstance postPortalInstance(PortalInstance portalInstance) throws Exception {
        long companyId = Optional.ofNullable(portalInstance.getCompanyId()).orElse(0L);
        Company company = this._companyService.addCompany(companyId, portalInstance.getPortalInstanceId(), portalInstance.getVirtualHost(), portalInstance.getDomain(), 0, true);
        Admin admin = portalInstance.getAdmin();
        if (admin != null) {
            this._validateAdmin(admin, company.getCompanyId());
            User defaultAdminUser = this._userLocalService.getUserByEmailAddress(company.getCompanyId(), PropsValues.DEFAULT_ADMIN_EMAIL_ADDRESS_PREFIX + "@" + company.getMx());
            defaultAdminUser.setEmailAddress(admin.getEmailAddress());
            defaultAdminUser.setFirstName(admin.getGivenName());
            defaultAdminUser.setLastName(admin.getFamilyName());
            ScreenNameGenerator screenNameGenerator = ScreenNameGeneratorFactory.getInstance();
            defaultAdminUser.setScreenName(screenNameGenerator.generate(company.getCompanyId(), defaultAdminUser.getUserId(), admin.getEmailAddress()));
            this._userLocalService.updateUser(defaultAdminUser);
        }
        try (SafeCloseable safeCloseable = CompanyThreadLocal.setWithSafeCloseable((Long)company.getCompanyId());){
            this._portalInstancesLocalService.initializePortalInstance(company.getCompanyId(), portalInstance.getSiteInitializerKey(), this._servletContext);
        }
        this._portalInstancesLocalService.synchronizePortalInstances();
        return this._toPortalInstance(company);
    }

    @Override
    public void putPortalInstanceActivate(String portalInstanceId) throws Exception {
        Company company = this._companyService.getCompanyByWebId(portalInstanceId);
        this._companyService.updateCompany(company.getCompanyId(), company.getVirtualHostname(), company.getMx(), company.getMaxUsers(), true);
    }

    @Override
    public void putPortalInstanceDeactivate(String portalInstanceId) throws Exception {
        Company company = this._companyService.getCompanyByWebId(portalInstanceId);
        this._companyService.updateCompany(company.getCompanyId(), company.getVirtualHostname(), company.getMx(), company.getMaxUsers(), false);
    }

    private PortalInstance _toPortalInstance(final Company company) {
        return new PortalInstance(){
            {
                this.active = company.isActive();
                this.companyId = company.getCompanyId();
                this.domain = company.getMx();
                this.portalInstanceId = company.getWebId();
                this.virtualHost = company.getVirtualHostname();
            }
        };
    }

    private void _validateAdmin(Admin admin, long companyId) throws Exception {
        if (Validator.isNull((String)admin.getEmailAddress()) || Validator.isNull((String)admin.getFamilyName()) || Validator.isNull((String)admin.getGivenName())) {
            throw new UserScreenNameException.MustNotBeNull();
        }
        EmailAddressValidator emailAddressValidator = EmailAddressValidatorFactory.getInstance();
        if (!emailAddressValidator.validate(companyId, admin.getEmailAddress())) {
            throw new UserEmailAddressException.MustValidate(admin.getEmailAddress(), emailAddressValidator);
        }
    }
}

