/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.portal.instances.internal.resource.v1_0;

import com.liferay.headless.portal.instances.dto.v1_0.PortalInstance;
import com.liferay.headless.portal.instances.internal.resource.v1_0.BasePortalInstanceResourceImpl;
import com.liferay.headless.portal.instances.resource.v1_0.PortalInstanceResource;
import com.liferay.portal.instances.initializer.PortalInstanceInitializer;
import com.liferay.portal.instances.initializer.PortalInstanceInitializerRegistry;
import com.liferay.portal.instances.service.PortalInstancesLocalService;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.servlet.ServletContextPool;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.pagination.Page;
import java.util.ArrayList;
import javax.validation.ValidationException;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/portal-instance.properties"}, scope=ServiceScope.PROTOTYPE, service={PortalInstanceResource.class})
public class PortalInstanceResourceImpl
extends BasePortalInstanceResourceImpl {
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private PortalInstanceInitializerRegistry _portalInstanceInitializerRegistry;
    @Reference
    private PortalInstancesLocalService _portalInstancesLocalService;

    @Override
    public void deletePortalInstance(String portalInstanceId) throws Exception {
        Company company = this._companyLocalService.getCompanyByWebId(portalInstanceId);
        this._companyLocalService.deleteCompany(company.getCompanyId());
    }

    @Override
    public PortalInstance getPortalInstance(String portalInstanceId) throws Exception {
        return this._toPortalInstance(this._companyLocalService.getCompanyByWebId(portalInstanceId));
    }

    @Override
    public Page<PortalInstance> getPortalInstancesPage(Boolean skipDefault) throws Exception {
        skipDefault = GetterUtil.getBoolean((Object)skipDefault);
        ArrayList<PortalInstance> portalInstances = new ArrayList<PortalInstance>();
        for (Company company : this._companyLocalService.getCompanies(false)) {
            if (skipDefault.booleanValue() && this._portalInstancesLocalService.getDefaultCompanyId() == company.getCompanyId()) continue;
            portalInstances.add(this._toPortalInstance(company));
        }
        return Page.of(portalInstances);
    }

    @Override
    public PortalInstance patchPortalInstance(String portalInstanceId, PortalInstance portalInstance) throws Exception {
        Company company = this._companyLocalService.getCompanyByWebId(portalInstanceId);
        String virtualHostname = GetterUtil.getString((String)portalInstance.getVirtualHost(), (String)company.getVirtualHostname());
        String domain = GetterUtil.getString((String)portalInstance.getDomain(), (String)company.getMx());
        return this._toPortalInstance(this._companyLocalService.updateCompany(company.getCompanyId(), virtualHostname, domain, company.getMaxUsers(), company.isActive()));
    }

    @Override
    public PortalInstance postPortalInstance(String initializerKey, PortalInstance portalInstance) throws Exception {
        PortalInstanceInitializer portalInstanceInitializer = null;
        if (Validator.isNotNull((String)initializerKey) && (portalInstanceInitializer = this._portalInstanceInitializerRegistry.getPortalInstanceInitializer(initializerKey)) == null) {
            throw new ValidationException("Invalid initializer key");
        }
        Company company = this._companyLocalService.addCompany(portalInstance.getCompanyId(), portalInstance.getPortalInstanceId(), portalInstance.getVirtualHost(), portalInstance.getDomain(), false, 0, true);
        this._portalInstancesLocalService.initializePortalInstance(ServletContextPool.get((String)""), company.getWebId());
        this._portalInstancesLocalService.synchronizePortalInstances();
        if (portalInstanceInitializer != null) {
            portalInstanceInitializer.initialize(company.getWebId(), company.getVirtualHostname(), company.getMx());
        }
        return this._toPortalInstance(company);
    }

    @Override
    public void putPortalInstanceActivate(String portalInstanceId) throws Exception {
        Company company = this._companyLocalService.getCompanyByWebId(portalInstanceId);
        this._companyLocalService.updateCompany(company.getCompanyId(), company.getVirtualHostname(), company.getMx(), company.getMaxUsers(), true);
    }

    @Override
    public void putPortalInstanceDeactivate(String portalInstanceId) throws Exception {
        Company company = this._companyLocalService.getCompanyByWebId(portalInstanceId);
        this._companyLocalService.updateCompany(company.getCompanyId(), company.getVirtualHostname(), company.getMx(), company.getMaxUsers(), false);
    }

    private PortalInstance _toPortalInstance(final Company company) {
        return new PortalInstance(){
            {
                this.active = company.isActive();
                this.companyId = company.getCompanyId();
                this.domain = company.getMx();
                this.portalInstanceId = company.getWebId();
                this.virtualHost = company.getVirtualHostname();
            }
        };
    }
}

