/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.form.internal.resource.v1_0;

import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.document.library.util.DLURLHelper;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormInstance;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceRecord;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceRecordVersion;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.model.UnlocalizedValue;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.service.DDMFormInstanceRecordService;
import com.liferay.dynamic.data.mapping.service.DDMFormInstanceRecordVersionService;
import com.liferay.dynamic.data.mapping.service.DDMFormInstanceService;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.headless.form.dto.v1_0.FormRecord;
import com.liferay.headless.form.dto.v1_0.util.FormRecordUtil;
import com.liferay.headless.form.internal.dto.v1_0.util.DDMFormValuesUtil;
import com.liferay.headless.form.internal.resource.v1_0.BaseFormRecordResourceImpl;
import com.liferay.headless.form.resource.v1_0.FormRecordResource;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.io.Serializable;
import java.util.Locale;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.BadRequestException;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Deprecated
@Component(properties={"OSGI-INF/liferay/rest/v1_0/form-record.properties"}, scope=ServiceScope.PROTOTYPE, service={FormRecordResource.class})
public class FormRecordResourceImpl
extends BaseFormRecordResourceImpl {
    private static final Log _log = LogFactoryUtil.getLog(FormRecordResourceImpl.class);
    @Reference
    private DDMFormInstanceRecordService _ddmFormInstanceRecordService;
    @Reference
    private DDMFormInstanceRecordVersionService _ddmFormInstanceRecordVersionService;
    @Reference
    private DDMFormInstanceService _ddmFormInstanceService;
    @Reference
    private DLAppService _dlAppService;
    @Reference
    private DLURLHelper _dlurlHelper;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private Portal _portal;
    @Reference
    private UserLocalService _userLocalService;

    @Override
    public FormRecord getFormFormRecordByLatestDraft(Long formId) throws Exception {
        DDMFormInstance ddmFormInstance = this._ddmFormInstanceService.getFormInstance(formId.longValue());
        DDMFormInstanceRecordVersion ddmFormInstanceRecordVersion = this._ddmFormInstanceRecordVersionService.fetchLatestFormInstanceRecordVersion(this.contextUser.getUserId(), ddmFormInstance.getFormInstanceId(), ddmFormInstance.getVersion(), 2);
        return FormRecordUtil.toFormRecord((DDMFormInstanceRecord)ddmFormInstanceRecordVersion.getFormInstanceRecord(), (DLAppService)this._dlAppService, (DLURLHelper)this._dlurlHelper, (Locale)this.contextAcceptLanguage.getPreferredLocale(), (Portal)this._portal, (UserLocalService)this._userLocalService);
    }

    @Override
    public Page<FormRecord> getFormFormRecordsPage(Long formId, Pagination pagination) throws Exception {
        return Page.of(this.transform(this._ddmFormInstanceRecordService.getFormInstanceRecords(formId.longValue(), -1, pagination.getStartPosition(), pagination.getEndPosition(), null), formRecord -> FormRecordUtil.toFormRecord((DDMFormInstanceRecord)formRecord, (DLAppService)this._dlAppService, (DLURLHelper)this._dlurlHelper, (Locale)this.contextAcceptLanguage.getPreferredLocale(), (Portal)this._portal, (UserLocalService)this._userLocalService)), (Pagination)pagination, (long)this._ddmFormInstanceRecordService.getFormInstanceRecordsCount(formId.longValue()));
    }

    @Override
    public FormRecord getFormRecord(Long formRecordId) throws Exception {
        return FormRecordUtil.toFormRecord((DDMFormInstanceRecord)this._ddmFormInstanceRecordService.getFormInstanceRecord(formRecordId.longValue()), (DLAppService)this._dlAppService, (DLURLHelper)this._dlurlHelper, (Locale)this.contextAcceptLanguage.getPreferredLocale(), (Portal)this._portal, (UserLocalService)this._userLocalService);
    }

    @Override
    public FormRecord postFormFormRecord(Long formId, FormRecord formRecord) throws Exception {
        DDMFormInstance ddmFormInstance = this._ddmFormInstanceService.getFormInstance(formId.longValue());
        DDMFormValues ddmFormValues = DDMFormValuesUtil.createDDMFormValues(ddmFormInstance, formRecord.getFormFieldValues(), this.contextAcceptLanguage.getPreferredLocale());
        this._linkFileEntries(ddmFormInstance.getDDMForm(), ddmFormValues);
        return FormRecordUtil.toFormRecord((DDMFormInstanceRecord)this._ddmFormInstanceRecordService.addFormInstanceRecord(ddmFormInstance.getGroupId(), ddmFormInstance.getFormInstanceId(), ddmFormValues, this._createServiceContext(formRecord.getDraft())), (DLAppService)this._dlAppService, (DLURLHelper)this._dlurlHelper, (Locale)this.contextAcceptLanguage.getPreferredLocale(), (Portal)this._portal, (UserLocalService)this._userLocalService);
    }

    @Override
    public FormRecord putFormRecord(Long formRecordId, FormRecord formRecord) throws Exception {
        DDMFormInstanceRecord ddmFormInstanceRecord = this._ddmFormInstanceRecordService.getFormInstanceRecord(formRecordId.longValue());
        DDMFormInstance ddmFormInstance = ddmFormInstanceRecord.getFormInstance();
        DDMFormValues ddmFormValues = DDMFormValuesUtil.createDDMFormValues(ddmFormInstance, formRecord.getFormFieldValues(), this.contextAcceptLanguage.getPreferredLocale());
        this._linkFileEntries(ddmFormInstance.getDDMForm(), ddmFormValues);
        return FormRecordUtil.toFormRecord((DDMFormInstanceRecord)this._ddmFormInstanceRecordService.updateFormInstanceRecord(formRecordId.longValue(), false, ddmFormValues, this._createServiceContext(formRecord.getDraft())), (DLAppService)this._dlAppService, (DLURLHelper)this._dlurlHelper, (Locale)this.contextAcceptLanguage.getPreferredLocale(), (Portal)this._portal, (UserLocalService)this._userLocalService);
    }

    private ServiceContext _createServiceContext(boolean draft) throws Exception {
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)DDMFormInstanceRecord.class.getName(), (HttpServletRequest)this.contextHttpServletRequest);
        if (draft) {
            serviceContext.setAttribute("status", (Serializable)Integer.valueOf(2));
            serviceContext.setAttribute("validateDDMFormValues", (Serializable)Boolean.FALSE);
            serviceContext.setWorkflowAction(2);
        } else {
            serviceContext.setWorkflowAction(1);
        }
        return serviceContext;
    }

    private void _linkFileEntries(DDMForm ddmForm, DDMFormValues ddmFormValues) {
        for (DDMFormField ddmFormField : ddmForm.getDDMFormFields()) {
            if (!Objects.equals(ddmFormField.getType(), "document_library")) continue;
            try {
                for (DDMFormFieldValue ddmFormFieldValue : ddmFormValues.getDDMFormFieldValues()) {
                    if (!Objects.equals(ddmFormField.getName(), ddmFormFieldValue.getName())) continue;
                    this._setValue(ddmFormFieldValue);
                }
            }
            catch (Exception exception) {
                _log.error((Throwable)exception);
                throw new BadRequestException((Throwable)exception);
            }
        }
    }

    private void _setValue(DDMFormFieldValue ddmFormFieldValue) throws Exception {
        Value value = ddmFormFieldValue.getValue();
        JSONObject jsonObject = this._jsonFactory.createJSONObject(value.getString(this.contextAcceptLanguage.getPreferredLocale()));
        long fileEntryId = jsonObject.getLong("fileEntryId");
        if (fileEntryId == 0L) {
            return;
        }
        FileEntry fileEntry = this._dlAppService.getFileEntry(fileEntryId);
        String json = JSONUtil.put((String)"fileEntryId", (Object)fileEntry.getFileEntryId()).put("groupId", fileEntry.getGroupId()).put("title", fileEntry.getTitle()).put("type", fileEntry.getMimeType()).put("uuid", fileEntry.getUuid()).put("version", fileEntry.getVersion()).toString();
        value = new UnlocalizedValue(json);
        DDMFormField ddmFormField = ddmFormFieldValue.getDDMFormField();
        if (ddmFormField.isLocalizable()) {
            value = new LocalizedValue();
            value.addString(value.getDefaultLocale(), json);
        }
        ddmFormFieldValue.setValue(value);
    }
}

