/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.form.internal.dto.v1_0.util;

import com.liferay.dynamic.data.mapping.form.renderer.DDMFormRenderingContext;
import com.liferay.dynamic.data.mapping.form.renderer.DDMFormTemplateContextFactory;
import com.liferay.dynamic.data.mapping.model.DDMFormInstance;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.headless.form.dto.v1_0.FormContext;
import com.liferay.headless.form.dto.v1_0.FormFieldContext;
import com.liferay.headless.form.dto.v1_0.FormFieldValue;
import com.liferay.headless.form.dto.v1_0.FormPageContext;
import com.liferay.headless.form.internal.dto.v1_0.util.DDMFormValuesUtil;
import com.liferay.petra.function.transform.TransformUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class FormContextUtil {
    public static FormContext evaluateContext(DDMFormInstance ddmFormInstance, DDMFormRenderingContext ddmFormRenderingContext, DDMFormTemplateContextFactory ddmFormTemplateContextFactory, FormFieldValue[] formFieldValues, Locale locale) throws Exception {
        ddmFormRenderingContext.setDDMFormValues(DDMFormValuesUtil.createDDMFormValues(ddmFormInstance, formFieldValues, locale));
        ddmFormRenderingContext.setLocale(locale);
        DDMStructure ddmStructure = ddmFormInstance.getStructure();
        final Map ddmFormTemplateContext = ddmFormTemplateContextFactory.create(ddmStructure.getDDMForm(), ddmStructure.getDDMFormLayout(), ddmFormRenderingContext);
        return new FormContext(){
            {
                this.setFormPageContexts(() -> (FormPageContext[])TransformUtil.transformToArray((Collection)FormContextUtil._getMaps(ddmFormTemplateContext, "pages"), x$0 -> FormContextUtil._toFormPageContext(x$0), FormPageContext.class));
                this.setReadOnly(() -> FormContextUtil._getBoolean(ddmFormTemplateContext, "readOnly"));
                this.setShowRequiredFieldsWarning(() -> FormContextUtil._getBoolean(ddmFormTemplateContext, "showRequiredFieldsWarning"));
                this.setShowSubmitButton(() -> FormContextUtil._getBoolean(ddmFormTemplateContext, "showSubmitButton"));
            }
        };
    }

    private static Boolean _getBoolean(Map<String, Object> map, String key) {
        return (Boolean)map.getOrDefault(key, false);
    }

    private static List<Map<String, Object>> _getMaps(Map<String, Object> map, String key) {
        return map.getOrDefault(key, new ArrayList());
    }

    private static String _getString(Map<String, Object> map, String key) {
        return String.valueOf(map.getOrDefault(key, ""));
    }

    private static FormFieldContext _toFormFieldContext(final Map<String, Object> fieldContext) {
        return new FormFieldContext(){
            {
                this.setEvaluable(() -> FormContextUtil._getBoolean(fieldContext, "evaluable"));
                this.setName(() -> FormContextUtil._getString(fieldContext, "fieldName"));
                this.setReadOnly(() -> FormContextUtil._getBoolean(fieldContext, "readOnly"));
                this.setRequired(() -> FormContextUtil._getBoolean(fieldContext, "required"));
                this.setValid(() -> FormContextUtil._getBoolean(fieldContext, "valid"));
                this.setValue(() -> FormContextUtil._getString(fieldContext, "value"));
                this.setValueChanged(() -> FormContextUtil._getBoolean(fieldContext, "valueChanged"));
                this.setVisible(() -> FormContextUtil._getBoolean(fieldContext, "visible"));
            }
        };
    }

    private static FormPageContext _toFormPageContext(final Map<String, Object> formPageContext) {
        return new FormPageContext(){
            {
                this.setEnabled(() -> FormContextUtil._getBoolean(formPageContext, "enabled"));
                this.setFormFieldContexts(() -> {
                    ArrayList<FormFieldContext> formFieldContextsList = new ArrayList<FormFieldContext>();
                    for (Map rowsMap : FormContextUtil._getMaps(formPageContext, "rows")) {
                        for (Map columnsMap : FormContextUtil._getMaps(rowsMap, "columns")) {
                            for (Map fieldsMap : FormContextUtil._getMaps(columnsMap, "fields")) {
                                formFieldContextsList.add(FormContextUtil._toFormFieldContext(fieldsMap));
                            }
                        }
                    }
                    return formFieldContextsList.toArray(new FormFieldContext[0]);
                });
                this.setShowRequiredFieldsWarning(() -> FormContextUtil._getBoolean(formPageContext, "showRequiredFieldsWarning"));
            }
        };
    }
}

