/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.form.internal.graphql.query.v1_0;

import com.liferay.headless.form.dto.v1_0.Form;
import com.liferay.headless.form.dto.v1_0.FormDocument;
import com.liferay.headless.form.dto.v1_0.FormRecord;
import com.liferay.headless.form.dto.v1_0.FormStructure;
import com.liferay.headless.form.resource.v1_0.FormDocumentResource;
import com.liferay.headless.form.resource.v1_0.FormRecordResource;
import com.liferay.headless.form.resource.v1_0.FormResource;
import com.liferay.headless.form.resource.v1_0.FormStructureResource;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLTypeExtension;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.Collection;
import java.util.Map;
import java.util.function.BiFunction;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotEmpty;
import javax.ws.rs.core.UriInfo;
import org.osgi.service.component.ComponentServiceObjects;

public class Query {
    private static ComponentServiceObjects<FormResource> _formResourceComponentServiceObjects;
    private static ComponentServiceObjects<FormDocumentResource> _formDocumentResourceComponentServiceObjects;
    private static ComponentServiceObjects<FormRecordResource> _formRecordResourceComponentServiceObjects;
    private static ComponentServiceObjects<FormStructureResource> _formStructureResourceComponentServiceObjects;
    private AcceptLanguage _acceptLanguage;
    private Company _company;
    private BiFunction<Object, String, Filter> _filterBiFunction;
    private GroupLocalService _groupLocalService;
    private HttpServletRequest _httpServletRequest;
    private HttpServletResponse _httpServletResponse;
    private RoleLocalService _roleLocalService;
    private BiFunction<Object, String, Sort[]> _sortsBiFunction;
    private UriInfo _uriInfo;
    private User _user;

    public static void setFormResourceComponentServiceObjects(ComponentServiceObjects<FormResource> formResourceComponentServiceObjects) {
        _formResourceComponentServiceObjects = formResourceComponentServiceObjects;
    }

    public static void setFormDocumentResourceComponentServiceObjects(ComponentServiceObjects<FormDocumentResource> formDocumentResourceComponentServiceObjects) {
        _formDocumentResourceComponentServiceObjects = formDocumentResourceComponentServiceObjects;
    }

    public static void setFormRecordResourceComponentServiceObjects(ComponentServiceObjects<FormRecordResource> formRecordResourceComponentServiceObjects) {
        _formRecordResourceComponentServiceObjects = formRecordResourceComponentServiceObjects;
    }

    public static void setFormStructureResourceComponentServiceObjects(ComponentServiceObjects<FormStructureResource> formStructureResourceComponentServiceObjects) {
        _formStructureResourceComponentServiceObjects = formStructureResourceComponentServiceObjects;
    }

    @GraphQLField
    public Form form(@GraphQLName(value="formId") Long formId) throws Exception {
        return (Form)this._applyComponentServiceObjects(_formResourceComponentServiceObjects, this::_populateResourceContext, formResource -> formResource.getForm(formId));
    }

    @GraphQLField
    public FormPage forms(@GraphQLName(value="siteKey") @NotEmpty String siteKey, @GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page) throws Exception {
        return (FormPage)this._applyComponentServiceObjects(_formResourceComponentServiceObjects, this::_populateResourceContext, formResource -> new FormPage(formResource.getSiteFormsPage(Long.valueOf(siteKey), Pagination.of((int)page, (int)pageSize))));
    }

    @GraphQLField
    public FormDocument formDocument(@GraphQLName(value="formDocumentId") Long formDocumentId) throws Exception {
        return (FormDocument)this._applyComponentServiceObjects(_formDocumentResourceComponentServiceObjects, this::_populateResourceContext, formDocumentResource -> formDocumentResource.getFormDocument(formDocumentId));
    }

    @GraphQLField
    public FormRecord formRecord(@GraphQLName(value="formRecordId") Long formRecordId) throws Exception {
        return (FormRecord)this._applyComponentServiceObjects(_formRecordResourceComponentServiceObjects, this::_populateResourceContext, formRecordResource -> formRecordResource.getFormRecord(formRecordId));
    }

    @GraphQLField
    public FormRecordPage formFormRecords(@GraphQLName(value="formId") Long formId, @GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page) throws Exception {
        return (FormRecordPage)this._applyComponentServiceObjects(_formRecordResourceComponentServiceObjects, this::_populateResourceContext, formRecordResource -> new FormRecordPage(formRecordResource.getFormFormRecordsPage(formId, Pagination.of((int)page, (int)pageSize))));
    }

    @GraphQLField
    public FormRecord formFormRecordByLatestDraft(@GraphQLName(value="formId") Long formId) throws Exception {
        return (FormRecord)this._applyComponentServiceObjects(_formRecordResourceComponentServiceObjects, this::_populateResourceContext, formRecordResource -> formRecordResource.getFormFormRecordByLatestDraft(formId));
    }

    @GraphQLField
    public FormStructure formStructure(@GraphQLName(value="formStructureId") Long formStructureId) throws Exception {
        return (FormStructure)this._applyComponentServiceObjects(_formStructureResourceComponentServiceObjects, this::_populateResourceContext, formStructureResource -> formStructureResource.getFormStructure(formStructureId));
    }

    @GraphQLField
    public FormStructurePage formStructures(@GraphQLName(value="siteKey") @NotEmpty String siteKey, @GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page) throws Exception {
        return (FormStructurePage)this._applyComponentServiceObjects(_formStructureResourceComponentServiceObjects, this::_populateResourceContext, formStructureResource -> new FormStructurePage(formStructureResource.getSiteFormStructuresPage(Long.valueOf(siteKey), Pagination.of((int)page, (int)pageSize))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T, R, E1 extends Throwable, E2 extends Throwable> R _applyComponentServiceObjects(ComponentServiceObjects<T> componentServiceObjects, UnsafeConsumer<T, E1> unsafeConsumer, UnsafeFunction<T, R, E2> unsafeFunction) throws E1, E2 {
        Object resource = componentServiceObjects.getService();
        try {
            unsafeConsumer.accept(resource);
            Object object = unsafeFunction.apply(resource);
            return (R)object;
        }
        finally {
            componentServiceObjects.ungetService(resource);
        }
    }

    private void _populateResourceContext(FormResource formResource) throws Exception {
        formResource.setContextAcceptLanguage(this._acceptLanguage);
        formResource.setContextCompany(this._company);
        formResource.setContextHttpServletRequest(this._httpServletRequest);
        formResource.setContextHttpServletResponse(this._httpServletResponse);
        formResource.setContextUriInfo(this._uriInfo);
        formResource.setContextUser(this._user);
        formResource.setGroupLocalService(this._groupLocalService);
        formResource.setRoleLocalService(this._roleLocalService);
    }

    private void _populateResourceContext(FormDocumentResource formDocumentResource) throws Exception {
        formDocumentResource.setContextAcceptLanguage(this._acceptLanguage);
        formDocumentResource.setContextCompany(this._company);
        formDocumentResource.setContextHttpServletRequest(this._httpServletRequest);
        formDocumentResource.setContextHttpServletResponse(this._httpServletResponse);
        formDocumentResource.setContextUriInfo(this._uriInfo);
        formDocumentResource.setContextUser(this._user);
        formDocumentResource.setGroupLocalService(this._groupLocalService);
        formDocumentResource.setRoleLocalService(this._roleLocalService);
    }

    private void _populateResourceContext(FormRecordResource formRecordResource) throws Exception {
        formRecordResource.setContextAcceptLanguage(this._acceptLanguage);
        formRecordResource.setContextCompany(this._company);
        formRecordResource.setContextHttpServletRequest(this._httpServletRequest);
        formRecordResource.setContextHttpServletResponse(this._httpServletResponse);
        formRecordResource.setContextUriInfo(this._uriInfo);
        formRecordResource.setContextUser(this._user);
        formRecordResource.setGroupLocalService(this._groupLocalService);
        formRecordResource.setRoleLocalService(this._roleLocalService);
    }

    private void _populateResourceContext(FormStructureResource formStructureResource) throws Exception {
        formStructureResource.setContextAcceptLanguage(this._acceptLanguage);
        formStructureResource.setContextCompany(this._company);
        formStructureResource.setContextHttpServletRequest(this._httpServletRequest);
        formStructureResource.setContextHttpServletResponse(this._httpServletResponse);
        formStructureResource.setContextUriInfo(this._uriInfo);
        formStructureResource.setContextUser(this._user);
        formStructureResource.setGroupLocalService(this._groupLocalService);
        formStructureResource.setRoleLocalService(this._roleLocalService);
    }

    @GraphQLName(value="FormStructurePage")
    public class FormStructurePage {
        @GraphQLField
        protected Map<String, Map> actions;
        @GraphQLField
        protected Collection<FormStructure> items;
        @GraphQLField
        protected long lastPage;
        @GraphQLField
        protected long page;
        @GraphQLField
        protected long pageSize;
        @GraphQLField
        protected long totalCount;

        public FormStructurePage(Page formStructurePage) {
            this.actions = formStructurePage.getActions();
            this.items = formStructurePage.getItems();
            this.lastPage = formStructurePage.getLastPage();
            this.page = formStructurePage.getPage();
            this.pageSize = formStructurePage.getPageSize();
            this.totalCount = formStructurePage.getTotalCount();
        }
    }

    @GraphQLName(value="FormRecordPage")
    public class FormRecordPage {
        @GraphQLField
        protected Map<String, Map> actions;
        @GraphQLField
        protected Collection<FormRecord> items;
        @GraphQLField
        protected long lastPage;
        @GraphQLField
        protected long page;
        @GraphQLField
        protected long pageSize;
        @GraphQLField
        protected long totalCount;

        public FormRecordPage(Page formRecordPage) {
            this.actions = formRecordPage.getActions();
            this.items = formRecordPage.getItems();
            this.lastPage = formRecordPage.getLastPage();
            this.page = formRecordPage.getPage();
            this.pageSize = formRecordPage.getPageSize();
            this.totalCount = formRecordPage.getTotalCount();
        }
    }

    @GraphQLName(value="FormDocumentPage")
    public class FormDocumentPage {
        @GraphQLField
        protected Map<String, Map> actions;
        @GraphQLField
        protected Collection<FormDocument> items;
        @GraphQLField
        protected long lastPage;
        @GraphQLField
        protected long page;
        @GraphQLField
        protected long pageSize;
        @GraphQLField
        protected long totalCount;

        public FormDocumentPage(Page formDocumentPage) {
            this.actions = formDocumentPage.getActions();
            this.items = formDocumentPage.getItems();
            this.lastPage = formDocumentPage.getLastPage();
            this.page = formDocumentPage.getPage();
            this.pageSize = formDocumentPage.getPageSize();
            this.totalCount = formDocumentPage.getTotalCount();
        }
    }

    @GraphQLName(value="FormPage")
    public class FormPage {
        @GraphQLField
        protected Map<String, Map> actions;
        @GraphQLField
        protected Collection<Form> items;
        @GraphQLField
        protected long lastPage;
        @GraphQLField
        protected long page;
        @GraphQLField
        protected long pageSize;
        @GraphQLField
        protected long totalCount;

        public FormPage(Page formPage) {
            this.actions = formPage.getActions();
            this.items = formPage.getItems();
            this.lastPage = formPage.getLastPage();
            this.page = formPage.getPage();
            this.pageSize = formPage.getPageSize();
            this.totalCount = formPage.getTotalCount();
        }
    }

    @GraphQLTypeExtension(value=FormRecord.class)
    public class GetFormTypeExtension {
        private FormRecord _formRecord;

        public GetFormTypeExtension(FormRecord formRecord) {
            this._formRecord = formRecord;
        }

        @GraphQLField
        public Form form() throws Exception {
            return (Form)Query.this._applyComponentServiceObjects(_formResourceComponentServiceObjects, x$0 -> Query.this._populateResourceContext(x$0), formResource -> formResource.getForm(this._formRecord.getFormId()));
        }
    }

    @GraphQLTypeExtension(value=Form.class)
    public class GetFormFormRecordByLatestDraftTypeExtension {
        private Form _form;

        public GetFormFormRecordByLatestDraftTypeExtension(Form form) {
            this._form = form;
        }

        @GraphQLField
        public FormRecord formRecordByLatestDraft() throws Exception {
            return (FormRecord)Query.this._applyComponentServiceObjects(_formRecordResourceComponentServiceObjects, x$0 -> Query.this._populateResourceContext(x$0), formRecordResource -> formRecordResource.getFormFormRecordByLatestDraft(this._form.getId()));
        }
    }
}

