/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.form.internal.dto.v1_0.util;

import com.liferay.dynamic.data.mapping.form.renderer.DDMFormRenderingContext;
import com.liferay.dynamic.data.mapping.form.renderer.DDMFormTemplateContextFactory;
import com.liferay.dynamic.data.mapping.model.DDMFormInstance;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.headless.form.dto.v1_0.FormContext;
import com.liferay.headless.form.dto.v1_0.FormFieldContext;
import com.liferay.headless.form.dto.v1_0.FormFieldValue;
import com.liferay.headless.form.dto.v1_0.FormPageContext;
import com.liferay.headless.form.internal.dto.v1_0.util.DDMFormValuesUtil;
import com.liferay.portal.vulcan.util.TransformUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FormContextUtil {
    public static FormContext evaluateContext(DDMFormInstance ddmFormInstance, DDMFormRenderingContext ddmFormRenderingContext, DDMFormTemplateContextFactory ddmFormTemplateContextFactory, FormFieldValue[] formFieldValues, Locale locale) throws Exception {
        ddmFormRenderingContext.setDDMFormValues(DDMFormValuesUtil.createDDMFormValues(ddmFormInstance, formFieldValues, locale));
        ddmFormRenderingContext.setLocale(locale);
        DDMStructure ddmStructure = ddmFormInstance.getStructure();
        final Map formContext = ddmFormTemplateContextFactory.create(ddmStructure.getDDMForm(), ddmStructure.getDDMFormLayout(), ddmFormRenderingContext);
        return new FormContext(){
            {
                this.formPageContexts = (FormPageContext[])TransformUtil.transformToArray((Collection)FormContextUtil._getMaps(formContext, "pages"), x$0 -> FormContextUtil._toFormPageContext(x$0), FormPageContext.class);
                this.readOnly = FormContextUtil._getBoolean(formContext, "readOnly");
                this.showRequiredFieldsWarning = FormContextUtil._getBoolean(formContext, "showRequiredFieldsWarning");
                this.showSubmitButton = FormContextUtil._getBoolean(formContext, "showSubmitButton");
            }
        };
    }

    private static Boolean _getBoolean(Map<String, Object> map, String key) {
        return (Boolean)map.getOrDefault(key, false);
    }

    private static List<Map<String, Object>> _getMaps(Map<String, Object> map, String key) {
        return map.getOrDefault(key, new ArrayList());
    }

    private static String _getString(Map<String, Object> map, String key) {
        return String.valueOf(map.getOrDefault(key, ""));
    }

    private static FormFieldContext _toFormFieldContext(final Map<String, Object> fieldContext) {
        return new FormFieldContext(){
            {
                this.evaluable = FormContextUtil._getBoolean(fieldContext, "evaluable");
                this.name = FormContextUtil._getString(fieldContext, "fieldName");
                this.readOnly = FormContextUtil._getBoolean(fieldContext, "readOnly");
                this.required = FormContextUtil._getBoolean(fieldContext, "required");
                this.valid = FormContextUtil._getBoolean(fieldContext, "valid");
                this.value = FormContextUtil._getString(fieldContext, "value");
                this.valueChanged = FormContextUtil._getBoolean(fieldContext, "valueChanged");
                this.visible = FormContextUtil._getBoolean(fieldContext, "visible");
            }
        };
    }

    private static FormPageContext _toFormPageContext(final Map<String, Object> formPageContext) {
        return new FormPageContext(){
            {
                this.enabled = FormContextUtil._getBoolean(formPageContext, "enabled");
                List maps = FormContextUtil._getMaps(formPageContext, "rows");
                Stream stream = maps.stream();
                this.formFieldContexts = (FormFieldContext[])TransformUtil.transformToArray((Collection)stream.map(row -> FormContextUtil._getMaps(row, "columns")).flatMap(Collection::stream).map(column -> FormContextUtil._getMaps(column, "fields")).flatMap(Collection::stream).collect(Collectors.toList()), x$0 -> FormContextUtil._toFormFieldContext(x$0), FormFieldContext.class);
                this.showRequiredFieldsWarning = FormContextUtil._getBoolean(formPageContext, "showRequiredFieldsWarning");
            }
        };
    }
}

