/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.form.internal.graphql.query.v1_0;

import com.liferay.headless.form.dto.v1_0.Form;
import com.liferay.headless.form.dto.v1_0.FormDocument;
import com.liferay.headless.form.dto.v1_0.FormRecord;
import com.liferay.headless.form.dto.v1_0.FormStructure;
import com.liferay.headless.form.resource.v1_0.FormDocumentResource;
import com.liferay.headless.form.resource.v1_0.FormRecordResource;
import com.liferay.headless.form.resource.v1_0.FormResource;
import com.liferay.headless.form.resource.v1_0.FormStructureResource;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.CompanyLocalServiceUtil;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLInvokeDetached;
import graphql.annotations.annotationTypes.GraphQLName;
import java.util.Collection;
import org.osgi.service.component.ComponentServiceObjects;

public class Query {
    private static ComponentServiceObjects<FormResource> _formResourceComponentServiceObjects;
    private static ComponentServiceObjects<FormDocumentResource> _formDocumentResourceComponentServiceObjects;
    private static ComponentServiceObjects<FormRecordResource> _formRecordResourceComponentServiceObjects;
    private static ComponentServiceObjects<FormStructureResource> _formStructureResourceComponentServiceObjects;

    public static void setFormResourceComponentServiceObjects(ComponentServiceObjects<FormResource> formResourceComponentServiceObjects) {
        _formResourceComponentServiceObjects = formResourceComponentServiceObjects;
    }

    public static void setFormDocumentResourceComponentServiceObjects(ComponentServiceObjects<FormDocumentResource> formDocumentResourceComponentServiceObjects) {
        _formDocumentResourceComponentServiceObjects = formDocumentResourceComponentServiceObjects;
    }

    public static void setFormRecordResourceComponentServiceObjects(ComponentServiceObjects<FormRecordResource> formRecordResourceComponentServiceObjects) {
        _formRecordResourceComponentServiceObjects = formRecordResourceComponentServiceObjects;
    }

    public static void setFormStructureResourceComponentServiceObjects(ComponentServiceObjects<FormStructureResource> formStructureResourceComponentServiceObjects) {
        _formStructureResourceComponentServiceObjects = formStructureResourceComponentServiceObjects;
    }

    @GraphQLField
    @GraphQLInvokeDetached
    public Form getForm(@GraphQLName(value="formId") Long formId) throws Exception {
        return (Form)this._applyComponentServiceObjects(_formResourceComponentServiceObjects, this::_populateResourceContext, formResource -> formResource.getForm(formId));
    }

    @GraphQLField
    @GraphQLInvokeDetached
    public Collection<Form> getSiteFormsPage(@GraphQLName(value="siteId") Long siteId, @GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page) throws Exception {
        return (Collection)this._applyComponentServiceObjects(_formResourceComponentServiceObjects, this::_populateResourceContext, formResource -> {
            Page paginationPage = formResource.getSiteFormsPage(siteId, Pagination.of((int)pageSize, (int)page));
            return paginationPage.getItems();
        });
    }

    @GraphQLField
    @GraphQLInvokeDetached
    public FormDocument getFormDocument(@GraphQLName(value="formDocumentId") Long formDocumentId) throws Exception {
        return (FormDocument)this._applyComponentServiceObjects(_formDocumentResourceComponentServiceObjects, this::_populateResourceContext, formDocumentResource -> formDocumentResource.getFormDocument(formDocumentId));
    }

    @GraphQLField
    @GraphQLInvokeDetached
    public FormRecord getFormRecord(@GraphQLName(value="formRecordId") Long formRecordId) throws Exception {
        return (FormRecord)this._applyComponentServiceObjects(_formRecordResourceComponentServiceObjects, this::_populateResourceContext, formRecordResource -> formRecordResource.getFormRecord(formRecordId));
    }

    @GraphQLField
    @GraphQLInvokeDetached
    public Collection<FormRecord> getFormFormRecordsPage(@GraphQLName(value="formId") Long formId, @GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page) throws Exception {
        return (Collection)this._applyComponentServiceObjects(_formRecordResourceComponentServiceObjects, this::_populateResourceContext, formRecordResource -> {
            Page paginationPage = formRecordResource.getFormFormRecordsPage(formId, Pagination.of((int)pageSize, (int)page));
            return paginationPage.getItems();
        });
    }

    @GraphQLField
    @GraphQLInvokeDetached
    public FormRecord getFormFormRecordByLatestDraft(@GraphQLName(value="formId") Long formId) throws Exception {
        return (FormRecord)this._applyComponentServiceObjects(_formRecordResourceComponentServiceObjects, this::_populateResourceContext, formRecordResource -> formRecordResource.getFormFormRecordByLatestDraft(formId));
    }

    @GraphQLField
    @GraphQLInvokeDetached
    public FormStructure getFormStructure(@GraphQLName(value="formStructureId") Long formStructureId) throws Exception {
        return (FormStructure)this._applyComponentServiceObjects(_formStructureResourceComponentServiceObjects, this::_populateResourceContext, formStructureResource -> formStructureResource.getFormStructure(formStructureId));
    }

    @GraphQLField
    @GraphQLInvokeDetached
    public Collection<FormStructure> getSiteFormStructuresPage(@GraphQLName(value="siteId") Long siteId, @GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page) throws Exception {
        return (Collection)this._applyComponentServiceObjects(_formStructureResourceComponentServiceObjects, this::_populateResourceContext, formStructureResource -> {
            Page paginationPage = formStructureResource.getSiteFormStructuresPage(siteId, Pagination.of((int)pageSize, (int)page));
            return paginationPage.getItems();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T, R, E1 extends Throwable, E2 extends Throwable> R _applyComponentServiceObjects(ComponentServiceObjects<T> componentServiceObjects, UnsafeConsumer<T, E1> unsafeConsumer, UnsafeFunction<T, R, E2> unsafeFunction) throws E1, E2 {
        Object resource = componentServiceObjects.getService();
        try {
            unsafeConsumer.accept(resource);
            Object object = unsafeFunction.apply(resource);
            return (R)object;
        }
        finally {
            componentServiceObjects.ungetService(resource);
        }
    }

    private void _populateResourceContext(FormResource formResource) throws Exception {
        formResource.setContextCompany(CompanyLocalServiceUtil.getCompany((long)CompanyThreadLocal.getCompanyId()));
    }

    private void _populateResourceContext(FormDocumentResource formDocumentResource) throws Exception {
        formDocumentResource.setContextCompany(CompanyLocalServiceUtil.getCompany((long)CompanyThreadLocal.getCompanyId()));
    }

    private void _populateResourceContext(FormRecordResource formRecordResource) throws Exception {
        formRecordResource.setContextCompany(CompanyLocalServiceUtil.getCompany((long)CompanyThreadLocal.getCompanyId()));
    }

    private void _populateResourceContext(FormStructureResource formStructureResource) throws Exception {
        formStructureResource.setContextCompany(CompanyLocalServiceUtil.getCompany((long)CompanyThreadLocal.getCompanyId()));
    }
}

