/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.form.internal.dto.v1_0.util;

import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldOptions;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldValidation;
import com.liferay.dynamic.data.mapping.model.DDMFormLayout;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutColumn;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutPage;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutRow;
import com.liferay.dynamic.data.mapping.model.DDMFormRule;
import com.liferay.dynamic.data.mapping.model.DDMFormSuccessPageSettings;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.headless.form.dto.v1_0.FormField;
import com.liferay.headless.form.dto.v1_0.FormFieldOption;
import com.liferay.headless.form.dto.v1_0.FormPage;
import com.liferay.headless.form.dto.v1_0.FormStructure;
import com.liferay.headless.form.dto.v1_0.FormSuccessPage;
import com.liferay.headless.form.dto.v1_0.Grid;
import com.liferay.headless.form.dto.v1_0.Validation;
import com.liferay.headless.form.internal.dto.v1_0.util.CreatorUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.vulcan.util.TransformUtil;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class StructureUtil {
    public static FormStructure toFormStructure(final DDMStructure ddmStructure, final Locale locale, final Portal portal, final UserLocalService userLocalService) throws PortalException {
        final DDMFormLayout ddmFormLayout = ddmStructure.getDDMFormLayout();
        DDMForm ddmForm = ddmStructure.getDDMForm();
        final DDMFormSuccessPageSettings ddmFormSuccessPageSettings = ddmForm.getDDMFormSuccessPageSettings();
        return new FormStructure(){
            {
                this.availableLanguages = LocaleUtil.toW3cLanguageIds((String[])ddmStructure.getAvailableLanguageIds());
                this.creator = CreatorUtil.toCreator(portal, userLocalService.getUserById(ddmStructure.getUserId()));
                this.dateCreated = ddmStructure.getCreateDate();
                this.dateModified = ddmStructure.getModifiedDate();
                this.description = ddmStructure.getDescription(locale);
                this.formPages = (FormPage[])TransformUtil.transformToArray((Collection)ddmFormLayout.getDDMFormLayoutPages(), ddmFormLayoutPage -> StructureUtil._toFormPage(ddmFormLayoutPage, ddmStructure, locale), FormPage.class);
                this.id = ddmStructure.getStructureId();
                this.name = ddmStructure.getName(locale);
                this.siteId = ddmStructure.getGroupId();
                this.setFormSuccessPage(() -> {
                    if (!ddmFormSuccessPageSettings.isEnabled()) {
                        return null;
                    }
                    return new FormSuccessPage(){
                        {
                            this.description = StructureUtil._toString(locale, ddmFormSuccessPageSettings.getBody());
                            this.headline = StructureUtil._toString(locale, ddmFormSuccessPageSettings.getTitle());
                        }
                    };
                });
            }
        };
    }

    private static List<String> _getNestedDDMFormFieldNames(List<String> ddmFormFieldNames, DDMStructure ddmStructure) {
        List ddmFormFields = ddmStructure.getDDMFormFields(true);
        Stream stream = ddmFormFields.stream();
        return stream.filter(ddmFormField -> ddmFormFieldNames.contains(ddmFormField.getName())).map(ddmFormField -> TransformUtil.transform((Collection)ddmFormField.getNestedDDMFormFields(), DDMFormField::getName)).map(nestedDDMFormFieldNames -> StructureUtil._getNestedDDMFormFieldNames(nestedDDMFormFieldNames, ddmStructure)).peek(nestedDDMFormFieldNames -> nestedDDMFormFieldNames.addAll(ddmFormFieldNames)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private static FormField _toFormField(final DDMFormField ddmFormField, final Locale locale) {
        final String type = ddmFormField.getType();
        return new FormField(){
            {
                this.displayStyle = GetterUtil.getString((Object)ddmFormField.getProperty("displayStyle"));
                this.immutable = ddmFormField.isTransient();
                this.inputControl = type;
                this.label = StructureUtil._toString(locale, ddmFormField.getLabel());
                this.localizable = ddmFormField.isLocalizable();
                this.multiple = ddmFormField.isMultiple();
                this.name = ddmFormField.getName();
                this.formFieldOptions = (FormFieldOption[])Optional.ofNullable(ddmFormField.getDDMFormFieldOptions()).map(DDMFormFieldOptions::getOptions).map(Map::entrySet).map(Collection::stream).orElseGet(Stream::empty).map(entry -> new FormFieldOption((Map.Entry)entry){
                    final /* synthetic */ Map.Entry val$entry;
                    {
                        this.val$entry = entry;
                        this.label = StructureUtil._toString(locale, (LocalizedValue)this.val$entry.getValue());
                        this.value = (String)this.val$entry.getKey();
                    }
                }).toArray(FormFieldOption[]::new);
                this.predefinedValue = StructureUtil._toString(locale, ddmFormField.getPredefinedValue());
                this.repeatable = ddmFormField.isRepeatable();
                this.required = ddmFormField.isRequired();
                this.showLabel = ddmFormField.isShowLabel();
                this.setDataType(() -> {
                    if (Objects.equals("date", type)) {
                        return type;
                    }
                    if (Objects.equals("document_library", type)) {
                        return "document";
                    }
                    if (Objects.equals("paragraph", type)) {
                        return "string";
                    }
                    return ddmFormField.getDataType();
                });
                this.setGrid(() -> {
                    if (!Objects.equals("grid", type)) {
                        return null;
                    }
                    return new Grid(){
                        {
                            this.columns = (FormFieldOption[])TransformUtil.transform((Object[])StructureUtil._toMapEntry(ddmFormField, "columns"), entry -> new FormFieldOption((Map.Entry)entry){
                                final /* synthetic */ Map.Entry val$entry;
                                {
                                    this.val$entry = entry;
                                    this.label = StructureUtil._toString(locale, (LocalizedValue)this.val$entry.getValue());
                                    this.value = (String)this.val$entry.getKey();
                                }
                            }, FormFieldOption.class);
                            this.rows = (FormFieldOption[])TransformUtil.transform((Object[])StructureUtil._toMapEntry(ddmFormField, "rows"), entry -> new FormFieldOption((Map.Entry)entry){
                                final /* synthetic */ Map.Entry val$entry;
                                {
                                    this.val$entry = entry;
                                    this.label = StructureUtil._toString(locale, (LocalizedValue)this.val$entry.getValue());
                                    this.value = (String)this.val$entry.getKey();
                                }
                            }, FormFieldOption.class);
                        }
                    };
                });
                this.setHasFormRules(() -> {
                    DDMForm ddmForm = ddmFormField.getDDMForm();
                    List ddmFormRules = ddmForm.getDDMFormRules();
                    Stream stream = ddmFormRules.stream();
                    return stream.map(DDMFormRule::getCondition).anyMatch(condition -> condition.contains(ddmFormField.getName()));
                });
                this.setShowAsSwitcher(() -> {
                    if (!"checkbox".equals(type) && !"checkbox_multiple".equals(type)) {
                        return null;
                    }
                    return GetterUtil.getBoolean((Object)ddmFormField.getProperty("showAsSwitcher"));
                });
                this.setText(() -> {
                    Object object = ddmFormField.getProperty("text");
                    if (!(object instanceof LocalizedValue)) {
                        return null;
                    }
                    return StructureUtil._toString(locale, (LocalizedValue)object);
                });
                this.setValidation(() -> {
                    Object object = ddmFormField.getProperty("validation");
                    if (!(object instanceof DDMFormFieldValidation)) {
                        return null;
                    }
                    final DDMFormFieldValidation ddmFormFieldValidation = (DDMFormFieldValidation)object;
                    return new Validation(){
                        {
                            this.errorMessage = ddmFormFieldValidation.getErrorMessage();
                            this.expression = ddmFormFieldValidation.getExpression();
                        }
                    };
                });
            }
        };
    }

    private static FormPage _toFormPage(final DDMFormLayoutPage ddmFormLayoutPage, DDMStructure ddmStructure, final Locale locale) {
        List ddmFormFieldNames = Stream.of(ddmFormLayoutPage.getDDMFormLayoutRows()).flatMap(Collection::stream).map(DDMFormLayoutRow::getDDMFormLayoutColumns).flatMap(Collection::stream).map(DDMFormLayoutColumn::getDDMFormFieldNames).map(nestedDDMFormFieldNames -> StructureUtil._getNestedDDMFormFieldNames(nestedDDMFormFieldNames, ddmStructure)).flatMap(Collection::stream).collect(Collectors.toList());
        final DDMFormField[] ddmFormFields = (DDMFormField[])ddmStructure.getDDMFormFields(true).stream().filter(ddmFormField -> ddmFormFieldNames.contains(ddmFormField.getName())).toArray(DDMFormField[]::new);
        return new FormPage(){
            {
                this.headline = StructureUtil._toString(locale, ddmFormLayoutPage.getTitle());
                this.formFields = (FormField[])TransformUtil.transform((Object[])ddmFormFields, ddmFormField -> StructureUtil._toFormField(ddmFormField, locale), FormField.class);
                this.text = StructureUtil._toString(locale, ddmFormLayoutPage.getDescription());
            }
        };
    }

    private static Map.Entry<String, LocalizedValue>[] _toMapEntry(DDMFormField ddmFormField, String name) {
        Object value = ddmFormField.getProperty(name);
        if (value == null) {
            return new Map.Entry[0];
        }
        DDMFormFieldOptions ddmFormFieldOptions = (DDMFormFieldOptions)value;
        Map options = ddmFormFieldOptions.getOptions();
        Set set = options.entrySet();
        return set.toArray(new Map.Entry[0]);
    }

    private static String _toString(Locale locale, LocalizedValue localizedValue) {
        if (localizedValue == null) {
            return null;
        }
        return localizedValue.getString(locale);
    }
}

