/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.form.dto.v1_0.util;

import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldOptions;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldValidation;
import com.liferay.dynamic.data.mapping.model.DDMFormLayout;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutColumn;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutPage;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutRow;
import com.liferay.dynamic.data.mapping.model.DDMFormRule;
import com.liferay.dynamic.data.mapping.model.DDMFormSuccessPageSettings;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.headless.form.dto.v1_0.Creator;
import com.liferay.headless.form.dto.v1_0.FormField;
import com.liferay.headless.form.dto.v1_0.FormFieldOption;
import com.liferay.headless.form.dto.v1_0.FormPage;
import com.liferay.headless.form.dto.v1_0.FormStructure;
import com.liferay.headless.form.dto.v1_0.FormSuccessPage;
import com.liferay.headless.form.dto.v1_0.Grid;
import com.liferay.headless.form.dto.v1_0.Validation;
import com.liferay.headless.form.dto.v1_0.util.CreatorUtil;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class StructureUtil {
    public static FormStructure toFormStructure(final boolean acceptAllLanguages, final DDMStructure ddmStructure, final Locale locale, final Portal portal, final UserLocalService userLocalService) throws PortalException {
        return new FormStructure(){
            {
                this.setAvailableLanguages((UnsafeSupplier<String[], Exception>)((UnsafeSupplier)() -> LocaleUtil.toW3cLanguageIds((String[])ddmStructure.getAvailableLanguageIds())));
                this.setCreator((UnsafeSupplier<Creator, Exception>)((UnsafeSupplier)() -> CreatorUtil.toCreator(portal, userLocalService.fetchUser(ddmStructure.getUserId()))));
                this.setDateCreated((UnsafeSupplier<Date, Exception>)((UnsafeSupplier)() -> ((DDMStructure)ddmStructure).getCreateDate()));
                this.setDateModified((UnsafeSupplier<Date, Exception>)((UnsafeSupplier)() -> ((DDMStructure)ddmStructure).getModifiedDate()));
                this.setDescription((UnsafeSupplier<String, Exception>)((UnsafeSupplier)() -> ddmStructure.getDescription(locale)));
                this.setDescription_i18n((UnsafeSupplier<Map<String, String>, Exception>)((UnsafeSupplier)() -> LocalizedMapUtil.getI18nMap((boolean)acceptAllLanguages, (Map)ddmStructure.getDescriptionMap())));
                this.setFormPages((UnsafeSupplier<FormPage[], Exception>)((UnsafeSupplier)() -> {
                    DDMFormLayout ddmFormLayout = ddmStructure.getDDMFormLayout();
                    return (FormPage[])TransformUtil.transformToArray((Collection)ddmFormLayout.getDDMFormLayoutPages(), ddmFormLayoutPage -> StructureUtil._toFormPage(acceptAllLanguages, ddmFormLayoutPage, ddmStructure, locale), FormPage.class);
                }));
                this.setFormSuccessPage((UnsafeSupplier<FormSuccessPage, Exception>)((UnsafeSupplier)() -> {
                    DDMForm ddmForm = ddmStructure.getDDMForm();
                    DDMFormSuccessPageSettings ddmFormSuccessPageSettings = ddmForm.getDDMFormSuccessPageSettings();
                    if (!ddmFormSuccessPageSettings.isEnabled()) {
                        return null;
                    }
                    final LocalizedValue bodyLocalizedValue = ddmFormSuccessPageSettings.getBody();
                    final LocalizedValue titleLocalizedValue = ddmFormSuccessPageSettings.getTitle();
                    return new FormSuccessPage(){
                        {
                            this.setDescription((UnsafeSupplier<String, Exception>)((UnsafeSupplier)() -> StructureUtil._toString(locale, bodyLocalizedValue)));
                            this.setDescription_i18n((UnsafeSupplier<Map<String, String>, Exception>)((UnsafeSupplier)() -> LocalizedMapUtil.getI18nMap((boolean)acceptAllLanguages, (Map)bodyLocalizedValue.getValues())));
                            this.setHeadline((UnsafeSupplier<String, Exception>)((UnsafeSupplier)() -> StructureUtil._toString(locale, titleLocalizedValue)));
                            this.setHeadline_i18n((UnsafeSupplier<Map<String, String>, Exception>)((UnsafeSupplier)() -> LocalizedMapUtil.getI18nMap((boolean)acceptAllLanguages, (Map)titleLocalizedValue.getValues())));
                        }
                    };
                }));
                this.setId((UnsafeSupplier<Long, Exception>)((UnsafeSupplier)() -> ((DDMStructure)ddmStructure).getStructureId()));
                this.setName((UnsafeSupplier<String, Exception>)((UnsafeSupplier)() -> ddmStructure.getName(locale)));
                this.setName_i18n((UnsafeSupplier<Map<String, String>, Exception>)((UnsafeSupplier)() -> LocalizedMapUtil.getI18nMap((boolean)acceptAllLanguages, (Map)ddmStructure.getNameMap())));
                this.setSiteId((UnsafeSupplier<Long, Exception>)((UnsafeSupplier)() -> ((DDMStructure)ddmStructure).getGroupId()));
            }
        };
    }

    private static List<String> _getNestedDDMFormFieldNames(List<String> ddmFormFieldNames, DDMStructure ddmStructure) {
        ArrayList<String> nestedDDMFormFieldNames = new ArrayList<String>();
        for (DDMFormField ddmFormField : ddmStructure.getDDMFormFields(true)) {
            if (!ddmFormFieldNames.contains(ddmFormField.getName())) continue;
            nestedDDMFormFieldNames.addAll(StructureUtil._getNestedDDMFormFieldNames(TransformUtil.transform((Collection)ddmFormField.getNestedDDMFormFields(), DDMFormField::getName), ddmStructure));
        }
        nestedDDMFormFieldNames.addAll(ddmFormFieldNames);
        return nestedDDMFormFieldNames;
    }

    private static FormField _toFormField(final boolean acceptAllLanguages, final DDMFormField ddmFormField, final Locale locale) {
        final LocalizedValue labelLocalizedValue = ddmFormField.getLabel();
        final LocalizedValue predefinedLocalizedValue = ddmFormField.getPredefinedValue();
        final String type = ddmFormField.getType();
        return new FormField(){
            {
                this.setDataType((UnsafeSupplier<String, Exception>)((UnsafeSupplier)() -> {
                    if (Objects.equals(type, "date")) {
                        return type;
                    }
                    if (Objects.equals(type, "document_library")) {
                        return "document";
                    }
                    if (Objects.equals(type, "paragraph")) {
                        return "string";
                    }
                    return ddmFormField.getDataType();
                }));
                this.setDisplayStyle((UnsafeSupplier<String, Exception>)((UnsafeSupplier)() -> GetterUtil.getString((Object)ddmFormField.getProperty("displayStyle"))));
                this.setFormFieldOptions((UnsafeSupplier<FormFieldOption[], Exception>)((UnsafeSupplier)() -> {
                    DDMFormFieldOptions ddmFormFieldOptions = ddmFormField.getDDMFormFieldOptions();
                    if (ddmFormFieldOptions == null) {
                        return new FormFieldOption[0];
                    }
                    Map ddmFormFieldOptionsMap = ddmFormFieldOptions.getOptions();
                    return (FormFieldOption[])TransformUtil.transformToArray(ddmFormFieldOptionsMap.entrySet(), entry -> StructureUtil._toFormFieldOption(acceptAllLanguages, entry, locale), FormFieldOption.class);
                }));
                this.setGrid((UnsafeSupplier<Grid, Exception>)((UnsafeSupplier)() -> {
                    if (!Objects.equals(type, "grid")) {
                        return null;
                    }
                    return new Grid(){
                        {
                            this.setColumns((UnsafeSupplier<FormFieldOption[], Exception>)((UnsafeSupplier)() -> (FormFieldOption[])TransformUtil.transform((Object[])StructureUtil._toMapEntry(ddmFormField, "columns"), entry -> StructureUtil._toFormFieldOption(acceptAllLanguages, entry, locale), FormFieldOption.class)));
                            this.setRows((UnsafeSupplier<FormFieldOption[], Exception>)((UnsafeSupplier)() -> (FormFieldOption[])TransformUtil.transform((Object[])StructureUtil._toMapEntry(ddmFormField, "rows"), entry -> StructureUtil._toFormFieldOption(acceptAllLanguages, entry, locale), FormFieldOption.class)));
                        }
                    };
                }));
                this.setHasFormRules((UnsafeSupplier<Boolean, Exception>)((UnsafeSupplier)() -> {
                    DDMForm ddmForm = ddmFormField.getDDMForm();
                    for (DDMFormRule ddmFormRule : ddmForm.getDDMFormRules()) {
                        String condition = ddmFormRule.getCondition();
                        if (!condition.contains(ddmFormField.getName())) continue;
                        return true;
                    }
                    return false;
                }));
                this.setImmutable((UnsafeSupplier<Boolean, Exception>)((UnsafeSupplier)() -> ((DDMFormField)ddmFormField).isTransient()));
                this.setInputControl((UnsafeSupplier<String, Exception>)((UnsafeSupplier)() -> type));
                this.setLabel((UnsafeSupplier<String, Exception>)((UnsafeSupplier)() -> StructureUtil._toString(locale, labelLocalizedValue)));
                this.setLabel_i18n((UnsafeSupplier<Map<String, String>, Exception>)((UnsafeSupplier)() -> LocalizedMapUtil.getI18nMap((boolean)acceptAllLanguages, (Map)labelLocalizedValue.getValues())));
                this.setLocalizable((UnsafeSupplier<Boolean, Exception>)((UnsafeSupplier)() -> ((DDMFormField)ddmFormField).isLocalizable()));
                this.setMultiple((UnsafeSupplier<Boolean, Exception>)((UnsafeSupplier)() -> ((DDMFormField)ddmFormField).isMultiple()));
                this.setName((UnsafeSupplier<String, Exception>)((UnsafeSupplier)() -> ((DDMFormField)ddmFormField).getName()));
                this.setPlaceholder((UnsafeSupplier<String, Exception>)((UnsafeSupplier)() -> StructureUtil._toString(locale, (LocalizedValue)ddmFormField.getProperty("placeholder"))));
                this.setPredefinedValue((UnsafeSupplier<String, Exception>)((UnsafeSupplier)() -> StructureUtil._toString(locale, predefinedLocalizedValue)));
                this.setPredefinedValue_i18n((UnsafeSupplier<Map<String, String>, Exception>)((UnsafeSupplier)() -> LocalizedMapUtil.getI18nMap((boolean)acceptAllLanguages, (Map)predefinedLocalizedValue.getValues())));
                this.setRepeatable((UnsafeSupplier<Boolean, Exception>)((UnsafeSupplier)() -> ((DDMFormField)ddmFormField).isRepeatable()));
                this.setRequired((UnsafeSupplier<Boolean, Exception>)((UnsafeSupplier)() -> ((DDMFormField)ddmFormField).isRequired()));
                this.setShowAsSwitcher((UnsafeSupplier<Boolean, Exception>)((UnsafeSupplier)() -> {
                    if (!"checkbox".equals(type) && !"checkbox_multiple".equals(type)) {
                        return null;
                    }
                    return GetterUtil.getBoolean((Object)ddmFormField.getProperty("showAsSwitcher"));
                }));
                this.setShowLabel((UnsafeSupplier<Boolean, Exception>)((UnsafeSupplier)() -> ((DDMFormField)ddmFormField).isShowLabel()));
                this.setText((UnsafeSupplier<String, Exception>)((UnsafeSupplier)() -> {
                    Object object = ddmFormField.getProperty("text");
                    if (!(object instanceof LocalizedValue)) {
                        return null;
                    }
                    return StructureUtil._toString(locale, (LocalizedValue)object);
                }));
                this.setText_i18n((UnsafeSupplier<Map<String, String>, Exception>)((UnsafeSupplier)() -> {
                    Object object = ddmFormField.getProperty("text");
                    if (!(object instanceof LocalizedValue)) {
                        return null;
                    }
                    LocalizedValue localizedValue = (LocalizedValue)object;
                    return LocalizedMapUtil.getI18nMap((boolean)acceptAllLanguages, (Map)localizedValue.getValues());
                }));
                this.setTooltip((UnsafeSupplier<String, Exception>)((UnsafeSupplier)() -> StructureUtil._toString(locale, (LocalizedValue)ddmFormField.getProperty("tip"))));
                this.setValidation((UnsafeSupplier<Validation, Exception>)((UnsafeSupplier)() -> {
                    Object object = ddmFormField.getProperty("validation");
                    if (!(object instanceof DDMFormFieldValidation)) {
                        return null;
                    }
                    final DDMFormFieldValidation ddmFormFieldValidation = (DDMFormFieldValidation)object;
                    final LocalizedValue errorMessageLocalizedValue = ddmFormFieldValidation.getErrorMessageLocalizedValue();
                    return new Validation(){
                        {
                            this.setErrorMessage((UnsafeSupplier<String, Exception>)((UnsafeSupplier)() -> errorMessageLocalizedValue.getString(locale)));
                            this.setErrorMessage_i18n((UnsafeSupplier<Map<String, String>, Exception>)((UnsafeSupplier)() -> LocalizedMapUtil.getI18nMap((boolean)acceptAllLanguages, (Map)errorMessageLocalizedValue.getValues())));
                            this.setExpression((UnsafeSupplier<String, Exception>)((UnsafeSupplier)() -> ddmFormFieldValidation.getExpression()));
                        }
                    };
                }));
            }
        };
    }

    private static FormFieldOption _toFormFieldOption(final boolean acceptAllLanguages, final Map.Entry<String, LocalizedValue> entry, final Locale locale) {
        final LocalizedValue localizedValue = entry.getValue();
        return new FormFieldOption(){
            {
                this.setLabel((UnsafeSupplier<String, Exception>)((UnsafeSupplier)() -> StructureUtil._toString(locale, localizedValue)));
                this.setLabel_i18n((UnsafeSupplier<Map<String, String>, Exception>)((UnsafeSupplier)() -> LocalizedMapUtil.getI18nMap((boolean)acceptAllLanguages, (Map)localizedValue.getValues())));
                this.setValue((UnsafeSupplier<String, Exception>)((UnsafeSupplier)entry::getKey));
            }
        };
    }

    private static FormPage _toFormPage(final boolean acceptAllLanguages, final DDMFormLayoutPage ddmFormLayoutPage, final DDMStructure ddmStructure, final Locale locale) {
        final ArrayList<String> ddmFormFieldNames = new ArrayList<String>();
        for (DDMFormLayoutRow ddmFormLayoutRow : ddmFormLayoutPage.getDDMFormLayoutRows()) {
            for (DDMFormLayoutColumn ddmFormLayoutColumn : ddmFormLayoutRow.getDDMFormLayoutColumns()) {
                ddmFormFieldNames.addAll(StructureUtil._getNestedDDMFormFieldNames(ddmFormLayoutColumn.getDDMFormFieldNames(), ddmStructure));
            }
        }
        final LocalizedValue titleLocalizedValue = ddmFormLayoutPage.getTitle();
        final LocalizedValue descriptionLocalizedValue = ddmFormLayoutPage.getDescription();
        return new FormPage(){
            {
                this.setFormFields((UnsafeSupplier<FormField[], Exception>)((UnsafeSupplier)() -> (FormField[])TransformUtil.transform((Object[])TransformUtil.transformToArray((Collection)ddmStructure.getDDMFormFields(true), ddmFormField -> {
                    if (!ddmFormFieldNames.contains(ddmFormField.getName())) {
                        return null;
                    }
                    return ddmFormField;
                }, DDMFormField.class), ddmFormField -> StructureUtil._toFormField(acceptAllLanguages, ddmFormField, locale), FormField.class)));
                this.setHeadline((UnsafeSupplier<String, Exception>)((UnsafeSupplier)() -> StructureUtil._toString(locale, titleLocalizedValue)));
                this.setHeadline_i18n((UnsafeSupplier<Map<String, String>, Exception>)((UnsafeSupplier)() -> LocalizedMapUtil.getI18nMap((boolean)acceptAllLanguages, (Map)titleLocalizedValue.getValues())));
                this.setText((UnsafeSupplier<String, Exception>)((UnsafeSupplier)() -> StructureUtil._toString(locale, ddmFormLayoutPage.getDescription())));
                this.setText_i18n((UnsafeSupplier<Map<String, String>, Exception>)((UnsafeSupplier)() -> LocalizedMapUtil.getI18nMap((boolean)acceptAllLanguages, (Map)descriptionLocalizedValue.getValues())));
            }
        };
    }

    private static Map.Entry<String, LocalizedValue>[] _toMapEntry(DDMFormField ddmFormField, String name) {
        Object value = ddmFormField.getProperty(name);
        if (value == null) {
            return new Map.Entry[0];
        }
        DDMFormFieldOptions ddmFormFieldOptions = (DDMFormFieldOptions)value;
        Map options = ddmFormFieldOptions.getOptions();
        Set set = options.entrySet();
        return set.toArray(new Map.Entry[0]);
    }

    private static String _toString(Locale locale, LocalizedValue localizedValue) {
        if (localizedValue == null) {
            return null;
        }
        return localizedValue.getString(locale);
    }
}

