/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.form.dto.v1_0.util;

import com.liferay.headless.form.dto.v1_0.Creator;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.Portal;

public class CreatorUtil {
    public static Creator toCreator(final Portal portal, final User user) {
        if (user == null || user.isGuestUser()) {
            return null;
        }
        return new Creator(){
            {
                this.setAdditionalName((UnsafeSupplier<String, Exception>)((UnsafeSupplier)() -> ((User)user).getMiddleName()));
                this.setContentType((UnsafeSupplier<String, Exception>)((UnsafeSupplier)() -> "UserAccount"));
                this.setFamilyName((UnsafeSupplier<String, Exception>)((UnsafeSupplier)() -> ((User)user).getLastName()));
                this.setGivenName((UnsafeSupplier<String, Exception>)((UnsafeSupplier)() -> ((User)user).getFirstName()));
                this.setId((UnsafeSupplier<Long, Exception>)((UnsafeSupplier)() -> ((User)user).getUserId()));
                this.setImage((UnsafeSupplier<String, Exception>)((UnsafeSupplier)() -> {
                    if (user.getPortraitId() == 0L) {
                        return null;
                    }
                    ThemeDisplay themeDisplay = new ThemeDisplay(){
                        {
                            this.setPathImage(portal.getPathImage());
                        }
                    };
                    return user.getPortraitURL(themeDisplay);
                }));
                this.setName((UnsafeSupplier<String, Exception>)((UnsafeSupplier)() -> ((User)user).getFullName()));
                this.setProfileURL((UnsafeSupplier<String, Exception>)((UnsafeSupplier)() -> {
                    final Group group = user.getGroup();
                    ThemeDisplay themeDisplay = new ThemeDisplay(){
                        {
                            this.setPortalURL("");
                            this.setSiteGroupId(group.getGroupId());
                        }
                    };
                    return group.getDisplayURL(themeDisplay);
                }));
            }
        };
    }
}

