/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.form.dto.v1_0.util;

import com.liferay.dynamic.data.mapping.model.DDMFormInstance;
import com.liferay.headless.form.dto.v1_0.Form;
import com.liferay.headless.form.dto.v1_0.util.CreatorUtil;
import com.liferay.headless.form.dto.v1_0.util.StructureUtil;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import java.util.Locale;
import java.util.Map;

public class FormUtil {
    public static Form toForm(final Boolean acceptAllLanguages, final DDMFormInstance ddmFormInstance, final Portal portal, final Locale preferredLocale, final UserLocalService userLocalService) throws Exception {
        if (ddmFormInstance == null) {
            return null;
        }
        return new Form(){
            {
                this.availableLanguages = LocaleUtil.toW3cLanguageIds((String[])ddmFormInstance.getAvailableLanguageIds());
                this.creator = CreatorUtil.toCreator(portal, userLocalService.fetchUser(ddmFormInstance.getUserId()));
                this.dateCreated = ddmFormInstance.getCreateDate();
                this.dateModified = ddmFormInstance.getModifiedDate();
                this.datePublished = ddmFormInstance.getLastPublishDate();
                this.defaultLanguage = ddmFormInstance.getDefaultLanguageId();
                this.description = ddmFormInstance.getDescription(preferredLocale);
                this.description_i18n = LocalizedMapUtil.getI18nMap((boolean)acceptAllLanguages, (Map)ddmFormInstance.getDescriptionMap());
                this.id = ddmFormInstance.getFormInstanceId();
                this.name = ddmFormInstance.getName(preferredLocale);
                this.name_i18n = LocalizedMapUtil.getI18nMap((boolean)acceptAllLanguages, (Map)ddmFormInstance.getNameMap());
                this.structure = StructureUtil.toFormStructure(acceptAllLanguages, ddmFormInstance.getStructure(), preferredLocale, portal, userLocalService);
            }
        };
    }
}

