/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.form.dto.v1_0.util;

import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.document.library.util.DLURLHelper;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceRecord;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.headless.form.dto.v1_0.FormDocument;
import com.liferay.headless.form.dto.v1_0.FormFieldValue;
import com.liferay.headless.form.dto.v1_0.FormRecord;
import com.liferay.headless.form.dto.v1_0.util.CreatorUtil;
import com.liferay.headless.form.dto.v1_0.util.FormDocumentUtil;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.Portal;
import java.util.Collection;
import java.util.Locale;

public class FormRecordUtil {
    private static final Log _log = LogFactoryUtil.getLog(FormRecordUtil.class);

    public static FormRecord toFormRecord(final DDMFormInstanceRecord ddmFormInstanceRecord, final DLAppService dlAppService, final DLURLHelper dlurlHelper, final Locale locale, final Portal portal, final UserLocalService userLocalService) throws Exception {
        final DDMFormValues ddmFormValues = ddmFormInstanceRecord.getDDMFormValues();
        return new FormRecord(){
            {
                this.creator = CreatorUtil.toCreator(portal, userLocalService.fetchUser(ddmFormInstanceRecord.getUserId()));
                this.dateCreated = ddmFormInstanceRecord.getCreateDate();
                this.dateModified = ddmFormInstanceRecord.getModifiedDate();
                this.datePublished = ddmFormInstanceRecord.getLastPublishDate();
                this.draft = ddmFormInstanceRecord.getStatus() == 2;
                this.formFieldValues = (FormFieldValue[])TransformUtil.transformToArray((Collection)ddmFormValues.getDDMFormFieldValues(), ddmFormFieldValue -> {
                    final Value localizedValue = ddmFormFieldValue.getValue();
                    if (localizedValue == null) {
                        return null;
                    }
                    return new FormFieldValue((DDMFormFieldValue)ddmFormFieldValue){
                        final /* synthetic */ DDMFormFieldValue val$ddmFormFieldValue;
                        {
                            this.val$ddmFormFieldValue = dDMFormFieldValue;
                            this.formDocument = FormRecordUtil._toFormDocument(dlAppService, dlurlHelper, locale, localizedValue);
                            this.name = this.val$ddmFormFieldValue.getName();
                            this.value = localizedValue.getString(locale);
                        }
                    };
                }, FormFieldValue.class);
                this.id = ddmFormInstanceRecord.getFormInstanceRecordId();
            }
        };
    }

    private static FormDocument _toFormDocument(DLAppService dlAppService, DLURLHelper dlurlHelper, Locale locale, Value localizedValue) throws Exception {
        FileEntry fileEntry;
        block4: {
            fileEntry = null;
            try {
                JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)localizedValue.getString(locale));
                long fileEntryId = jsonObject.getLong("fileEntryId", 0L);
                if (fileEntryId > 0L) {
                    fileEntry = dlAppService.getFileEntry(fileEntryId);
                }
            }
            catch (JSONException jsonException) {
                if (!_log.isWarnEnabled()) break block4;
                _log.warn((Throwable)jsonException);
            }
        }
        if (fileEntry == null) {
            return null;
        }
        return FormDocumentUtil.toFormDocument(dlurlHelper, fileEntry);
    }
}

