/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.discovery.internal.jaxrs.application;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.liferay.headless.discovery.internal.configuration.HeadlessDiscoveryConfiguration;
import com.liferay.headless.discovery.internal.dto.Hint;
import com.liferay.headless.discovery.internal.dto.Resource;
import com.liferay.headless.discovery.internal.dto.Resources;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.security.auth.AuthTokenUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.jaxrs.runtime.JaxrsServiceRuntime;
import org.osgi.service.jaxrs.runtime.dto.ApplicationDTO;
import org.osgi.service.jaxrs.runtime.dto.ResourceDTO;
import org.osgi.service.jaxrs.runtime.dto.ResourceMethodInfoDTO;
import org.osgi.service.jaxrs.runtime.dto.RuntimeDTO;

@Component(configurationPid={"com.liferay.headless.discovery.internal.configuration.HeadlessDiscoveryConfiguration"}, property={"osgi.jaxrs.application.base=/api", "osgi.jaxrs.extension.select=(osgi.jaxrs.name=Liferay.Vulcan)", "osgi.jaxrs.name=Liferay.Headless.Discovery.API", "auth.verifier.auth.verifier.PortalSessionAuthVerifier.check.csrf.token=false"}, service={Application.class})
public class HeadlessDiscoveryAPIApplication
extends Application {
    private volatile BundleContext _bundleContext;
    private volatile HeadlessDiscoveryConfiguration _headlessDiscoveryConfiguration;
    @Reference
    private JaxrsServiceRuntime _jaxrsServiceRuntime;
    @Reference
    private Portal _portal;
    @Context
    private UriInfo _uriInfo;

    @GET
    @Produces(value={"application/json", "application/xml", "text/html"})
    public Response discovery(@HeaderParam(value="Accept") String accept, @Context HttpServletRequest httpServletRequest, @Context HttpServletResponse httpServletResponse) throws Exception {
        if (accept != null && accept.contains("text/html") && this._headlessDiscoveryConfiguration.enableAPIExplorer()) {
            URL url = this._getURL("index.html");
            if (url == null) {
                return Response.serverError().build();
            }
            InputStream urlInputStream = url.openStream();
            Scanner scanner = new Scanner(urlInputStream, "UTF-8");
            scanner.useDelimiter("\\A");
            String html = StringUtil.replace((String)scanner.next(), (String)"%CSRF-TOKEN%", (String)AuthTokenUtil.getToken((HttpServletRequest)httpServletRequest));
            html = StringUtil.replace((String)html, (String)"href=\"main.css\"", (String)("href=\"" + this._portal.getPathContext() + "/o/api/main.css\""));
            String finalHtml = html = StringUtil.replace((String)html, (String)"src=\"headless-discovery-web-min.js\"", (String)("src=\"" + this._portal.getPathContext() + "/o/api/headless-discovery-web-min.js\""));
            return Response.ok(streamingOutput -> {
                ByteArrayInputStream htmlInputStream = new ByteArrayInputStream(finalHtml.getBytes());
                byte[] buffer = new byte[1024];
                int read = 0;
                while ((read = htmlInputStream.read(buffer)) != -1) {
                    streamingOutput.write(buffer, 0, read);
                }
            }).build();
        }
        Map<String, List<ResourceMethodInfoDTO>> resourceMethodInfoDTOsMap = this._getResourceMethodInfoDTOsMap();
        TreeMap<String, Resource> resourcesMap = new TreeMap<String, Resource>();
        for (Map.Entry<String, List<ResourceMethodInfoDTO>> entry : resourceMethodInfoDTOsMap.entrySet()) {
            resourcesMap.put(entry.getKey(), this._getResource(entry.getValue()));
        }
        Resources resources = new Resources(resourcesMap);
        if (accept != null && accept.contains("application/xhtml+xml")) {
            ObjectMapper objectMapper = new ObjectMapper();
            return Response.ok((Object)objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)resources), (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
        }
        return Response.ok((Object)resources).build();
    }

    @GET
    @Path(value="/{parameter}")
    @Produces(value={"text/css", "text/javascript"})
    public Response discoveryParameter(@HeaderParam(value="Accept") String accept, @Context HttpServletRequest httpServletRequest, @Context HttpServletResponse httpServletResponse, @PathParam(value="parameter") String parameter) throws Exception {
        if (parameter.contains("..")) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        URL url = this._getURL(parameter);
        if (url == null) {
            return Response.serverError().build();
        }
        InputStream urlInputStream = url.openStream();
        Response.ResponseBuilder responseBuilder = Response.ok(streamingOutput -> {
            byte[] buffer = new byte[1024];
            int read = 0;
            while ((read = urlInputStream.read(buffer)) != -1) {
                streamingOutput.write(buffer, 0, read);
            }
        });
        if (parameter.contains("main.css")) {
            responseBuilder.type("text/css");
        } else {
            responseBuilder.type("text/javascript");
        }
        return responseBuilder.build();
    }

    public Set<Object> getSingletons() {
        return Collections.singleton(this);
    }

    @Activate
    @Modified
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) {
        this._bundleContext = bundleContext;
        this._headlessDiscoveryConfiguration = (HeadlessDiscoveryConfiguration)ConfigurableUtil.createConfigurable(HeadlessDiscoveryConfiguration.class, properties);
    }

    private Resource _getResource(List<ResourceMethodInfoDTO> resourceMethodInfoDTOS) {
        Resource resource = new Resource();
        Stream stream = resourceMethodInfoDTOS.stream();
        String[] verbs = (String[])stream.map(dto -> dto.method).toArray(String[]::new);
        ResourceMethodInfoDTO resourceMethodInfoDTO = resourceMethodInfoDTOS.get(0);
        resource.setHint(new Hint(verbs, resourceMethodInfoDTO.producingMimeType));
        String resourcePath = resourceMethodInfoDTO.path;
        if (resourcePath.contains("{")) {
            resource.setHrefTemplate(resourcePath);
        } else {
            resource.setHref(resourcePath);
        }
        return resource;
    }

    private Map<String, List<ResourceMethodInfoDTO>> _getResourceMethodInfoDTOsMap() {
        TreeMap<String, List<ResourceMethodInfoDTO>> resourcesMap = new TreeMap<String, List<ResourceMethodInfoDTO>>();
        String absolutePath = String.valueOf(this._uriInfo.getAbsolutePath());
        String serverURL = StringUtil.removeSubstring((String)absolutePath, (String)"/api/");
        RuntimeDTO runtimeDTO = this._jaxrsServiceRuntime.getRuntimeDTO();
        for (ApplicationDTO applicationDTO : runtimeDTO.applicationDTOs) {
            for (ResourceDTO resourceDTO : applicationDTO.resourceDTOs) {
                for (ResourceMethodInfoDTO resourceMethodInfoDTO : resourceDTO.resourceMethods) {
                    resourceMethodInfoDTO.path = applicationDTO.base + resourceMethodInfoDTO.path;
                    String path = serverURL + resourceMethodInfoDTO.path;
                    ArrayList<ResourceMethodInfoDTO> resourceMethodInfoDTOS = (ArrayList<ResourceMethodInfoDTO>)resourcesMap.get(path);
                    if (resourceMethodInfoDTOS == null) {
                        resourceMethodInfoDTOS = new ArrayList<ResourceMethodInfoDTO>();
                    }
                    resourceMethodInfoDTOS.add(resourceMethodInfoDTO);
                    resourcesMap.put(path, resourceMethodInfoDTOS);
                }
            }
        }
        return resourcesMap;
    }

    private URL _getURL(String parameter) {
        for (Bundle bundle : this._bundleContext.getBundles()) {
            if (!StringUtil.equals((String)bundle.getSymbolicName(), (String)"com.liferay.headless.discovery.web")) continue;
            return bundle.getEntry("META-INF/resources/" + parameter);
        }
        return null;
    }
}

