/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.resource.v1_0;

import com.liferay.headless.common.spi.service.context.ServiceContextRequestUtil;
import com.liferay.headless.delivery.dto.v1_0.CustomField;
import com.liferay.headless.delivery.dto.v1_0.KnowledgeBaseFolder;
import com.liferay.headless.delivery.dto.v1_0.util.CreatorUtil;
import com.liferay.headless.delivery.dto.v1_0.util.CustomFieldsUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.ParentKnowledgeBaseFolderUtil;
import com.liferay.headless.delivery.internal.resource.v1_0.BaseKnowledgeBaseFolderResourceImpl;
import com.liferay.headless.delivery.resource.v1_0.KnowledgeBaseFolderResource;
import com.liferay.knowledge.base.model.KBFolder;
import com.liferay.knowledge.base.service.KBArticleService;
import com.liferay.knowledge.base.service.KBFolderLocalService;
import com.liferay.knowledge.base.service.KBFolderService;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.io.Serializable;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/knowledge-base-folder.properties"}, scope=ServiceScope.PROTOTYPE, service={KnowledgeBaseFolderResource.class})
public class KnowledgeBaseFolderResourceImpl
extends BaseKnowledgeBaseFolderResourceImpl {
    @Reference
    private KBArticleService _kbArticleService;
    @Reference
    private KBFolderLocalService _kbFolderLocalService;
    @Reference
    private KBFolderService _kbFolderService;
    @Reference
    private Portal _portal;
    @Reference
    private UserLocalService _userLocalService;

    @Override
    public void deleteKnowledgeBaseFolder(Long knowledgeBaseFolderId) throws Exception {
        this._kbFolderService.deleteKBFolder(knowledgeBaseFolderId.longValue());
    }

    @Override
    public void deleteSiteKnowledgeBaseFolderByExternalReferenceCode(Long siteId, String externalReferenceCode) throws Exception {
        KBFolder kbFolder = this._kbFolderLocalService.getKBFolderByExternalReferenceCode(externalReferenceCode, siteId.longValue());
        this._kbFolderService.deleteKBFolder(kbFolder.getKbFolderId());
    }

    @Override
    public KnowledgeBaseFolder getKnowledgeBaseFolder(Long knowledgeBaseFolderId) throws Exception {
        return this._toKnowledgeBaseFolder(this._kbFolderService.getKBFolder(knowledgeBaseFolderId.longValue()));
    }

    @Override
    public Page<KnowledgeBaseFolder> getKnowledgeBaseFolderKnowledgeBaseFoldersPage(Long parentKnowledgeBaseFolderId, Pagination pagination) throws Exception {
        KBFolder kbFolder = this._kbFolderService.getKBFolder(parentKnowledgeBaseFolderId.longValue());
        return Page.of((Map)HashMapBuilder.put((Object)"create", this.addAction("ADD_KB_FOLDER", "postKnowledgeBaseFolderKnowledgeBaseFolder", "com.liferay.knowledge.base.admin", kbFolder.getGroupId())).put((Object)"get", this.addAction("VIEW", "getKnowledgeBaseFolderKnowledgeBaseFoldersPage", "com.liferay.knowledge.base.admin", kbFolder.getGroupId())).build(), this.transform(this._kbFolderService.getKBFolders(kbFolder.getGroupId(), parentKnowledgeBaseFolderId.longValue(), pagination.getStartPosition(), pagination.getEndPosition()), this::_toKnowledgeBaseFolder), (Pagination)pagination, (long)this._kbFolderService.getKBFoldersCount(kbFolder.getGroupId(), parentKnowledgeBaseFolderId.longValue()));
    }

    @Override
    public KnowledgeBaseFolder getSiteKnowledgeBaseFolderByExternalReferenceCode(Long siteId, String externalReferenceCode) throws Exception {
        return this._toKnowledgeBaseFolder(this._kbFolderService.getKBFolderByExternalReferenceCode(siteId.longValue(), externalReferenceCode));
    }

    @Override
    public Page<KnowledgeBaseFolder> getSiteKnowledgeBaseFoldersPage(Long siteId, Pagination pagination) throws Exception {
        return Page.of((Map)HashMapBuilder.put((Object)"create", this.addAction("ADD_KB_FOLDER", "postSiteKnowledgeBaseFolder", "com.liferay.knowledge.base.admin", siteId)).put((Object)"createBatch", this.addAction("ADD_KB_FOLDER", "postSiteKnowledgeBaseFolderBatch", "com.liferay.knowledge.base.admin", siteId)).put((Object)"deleteBatch", this.addAction("DELETE", "deleteKnowledgeBaseFolderBatch", "com.liferay.knowledge.base.admin", null)).put((Object)"get", this.addAction("VIEW", "getSiteKnowledgeBaseFoldersPage", "com.liferay.knowledge.base.admin", siteId)).put((Object)"updateBatch", this.addAction("UPDATE", "putKnowledgeBaseFolderBatch", "com.liferay.knowledge.base.admin", null)).build(), this.transform(this._kbFolderService.getKBFolders(siteId.longValue(), 0L, pagination.getStartPosition(), pagination.getEndPosition()), this::_toKnowledgeBaseFolder), (Pagination)pagination, (long)this._kbFolderService.getKBFoldersCount(siteId.longValue(), 0L));
    }

    @Override
    public KnowledgeBaseFolder postKnowledgeBaseFolderKnowledgeBaseFolder(Long parentKnowledgeBaseFolderId, KnowledgeBaseFolder knowledgeBaseFolder) throws Exception {
        KBFolder parentKBFolder = this._kbFolderService.getKBFolder(parentKnowledgeBaseFolderId.longValue());
        return this._addKnowledgeBaseFolder(knowledgeBaseFolder.getExternalReferenceCode(), parentKBFolder.getGroupId(), parentKnowledgeBaseFolderId, knowledgeBaseFolder);
    }

    @Override
    public KnowledgeBaseFolder postSiteKnowledgeBaseFolder(Long siteId, KnowledgeBaseFolder knowledgeBaseFolder) throws Exception {
        return this._addKnowledgeBaseFolder(knowledgeBaseFolder.getExternalReferenceCode(), siteId, null, knowledgeBaseFolder);
    }

    @Override
    public KnowledgeBaseFolder putKnowledgeBaseFolder(Long knowledgeBaseFolderId, KnowledgeBaseFolder knowledgeBaseFolder) throws Exception {
        return this._updateKnowledgeBaseFolder(this._kbFolderLocalService.getKBFolder(knowledgeBaseFolderId.longValue()), knowledgeBaseFolder);
    }

    @Override
    public KnowledgeBaseFolder putSiteKnowledgeBaseFolderByExternalReferenceCode(Long siteId, String externalReferenceCode, KnowledgeBaseFolder knowledgeBaseFolder) throws Exception {
        KBFolder kbFolder = this._kbFolderLocalService.fetchKBFolderByExternalReferenceCode(externalReferenceCode, siteId.longValue());
        if (kbFolder != null) {
            return this._updateKnowledgeBaseFolder(kbFolder, knowledgeBaseFolder);
        }
        return this._addKnowledgeBaseFolder(externalReferenceCode, siteId, knowledgeBaseFolder.getParentKnowledgeBaseFolderId(), knowledgeBaseFolder);
    }

    @Override
    protected Long getPermissionCheckerGroupId(Object id) throws Exception {
        KBFolder kbFolder = this._kbFolderService.getKBFolder(((Long)id).longValue());
        return kbFolder.getGroupId();
    }

    @Override
    protected String getPermissionCheckerPortletName(Object id) {
        return "com.liferay.knowledge.base.admin";
    }

    @Override
    protected String getPermissionCheckerResourceName(Object id) {
        return KBFolder.class.getName();
    }

    private KnowledgeBaseFolder _addKnowledgeBaseFolder(String externalReferenceCode, long groupId, Long parentResourcePrimKey, KnowledgeBaseFolder knowledgeBaseFolder) throws Exception {
        if (parentResourcePrimKey == null) {
            parentResourcePrimKey = 0L;
        }
        return this._toKnowledgeBaseFolder(this._kbFolderService.addKBFolder(externalReferenceCode, groupId, this._getClassNameId(), parentResourcePrimKey.longValue(), knowledgeBaseFolder.getName(), knowledgeBaseFolder.getDescription(), ServiceContextRequestUtil.createServiceContext(this._getExpandoBridgeAttributes(knowledgeBaseFolder), (long)groupId, (HttpServletRequest)this.contextHttpServletRequest, (String)knowledgeBaseFolder.getViewableByAsString())));
    }

    private long _getClassNameId() {
        return this._portal.getClassNameId(KBFolder.class.getName());
    }

    private Map<String, Serializable> _getExpandoBridgeAttributes(KnowledgeBaseFolder knowledgeBaseFolder) {
        return CustomFieldsUtil.toMap((String)KBFolder.class.getName(), (long)this.contextCompany.getCompanyId(), (CustomField[])knowledgeBaseFolder.getCustomFields(), (Locale)this.contextAcceptLanguage.getPreferredLocale());
    }

    private KnowledgeBaseFolder _toKnowledgeBaseFolder(final KBFolder kbFolder) throws Exception {
        if (kbFolder == null) {
            return null;
        }
        return new KnowledgeBaseFolder(){
            {
                this.actions = HashMapBuilder.put((Object)"delete", KnowledgeBaseFolderResourceImpl.this.addAction("DELETE", (GroupedModel)kbFolder, "deleteKnowledgeBaseFolder")).put((Object)"get", KnowledgeBaseFolderResourceImpl.this.addAction("VIEW", (GroupedModel)kbFolder, "getKnowledgeBaseFolder")).put((Object)"replace", KnowledgeBaseFolderResourceImpl.this.addAction("UPDATE", (GroupedModel)kbFolder, "putKnowledgeBaseFolder")).build();
                this.creator = CreatorUtil.toCreator((Portal)KnowledgeBaseFolderResourceImpl.this._portal, Optional.ofNullable(KnowledgeBaseFolderResourceImpl.this.contextUriInfo), (User)KnowledgeBaseFolderResourceImpl.this._userLocalService.fetchUser(kbFolder.getUserId()));
                this.customFields = CustomFieldsUtil.toCustomFields((boolean)KnowledgeBaseFolderResourceImpl.this.contextAcceptLanguage.isAcceptAllLanguages(), (String)KBFolder.class.getName(), (long)kbFolder.getKbFolderId(), (long)kbFolder.getCompanyId(), (Locale)KnowledgeBaseFolderResourceImpl.this.contextAcceptLanguage.getPreferredLocale());
                this.dateCreated = kbFolder.getCreateDate();
                this.dateModified = kbFolder.getModifiedDate();
                this.description = kbFolder.getDescription();
                this.externalReferenceCode = kbFolder.getExternalReferenceCode();
                this.id = kbFolder.getKbFolderId();
                this.name = kbFolder.getName();
                this.numberOfKnowledgeBaseArticles = KnowledgeBaseFolderResourceImpl.this._kbArticleService.getKBArticlesCount(kbFolder.getGroupId(), kbFolder.getKbFolderId(), 0);
                this.numberOfKnowledgeBaseFolders = KnowledgeBaseFolderResourceImpl.this._kbFolderService.getKBFoldersCount(kbFolder.getGroupId(), kbFolder.getKbFolderId());
                this.parentKnowledgeBaseFolder = ParentKnowledgeBaseFolderUtil.toParentKnowledgeBaseFolder(kbFolder.getParentKBFolder());
                this.siteId = kbFolder.getGroupId();
            }
        };
    }

    private KnowledgeBaseFolder _updateKnowledgeBaseFolder(KBFolder kbFolder, KnowledgeBaseFolder knowledgeBaseFolder) throws Exception {
        return this._toKnowledgeBaseFolder(this._kbFolderService.updateKBFolder(this._getClassNameId(), kbFolder.getParentKBFolderId(), kbFolder.getKbFolderId(), knowledgeBaseFolder.getName(), knowledgeBaseFolder.getDescription(), ServiceContextRequestUtil.createServiceContext(this._getExpandoBridgeAttributes(knowledgeBaseFolder), (long)0L, (HttpServletRequest)this.contextHttpServletRequest, null)));
    }
}

