/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.dto.v1_0.util;

import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.document.library.util.DLURLHelper;
import com.liferay.dynamic.data.mapping.kernel.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.kernel.DDMFormValues;
import com.liferay.dynamic.data.mapping.kernel.StorageEngineManager;
import com.liferay.dynamic.data.mapping.kernel.Value;
import com.liferay.headless.delivery.dto.v1_0.CustomMetaTag;
import com.liferay.headless.delivery.dto.v1_0.PageSettings;
import com.liferay.headless.delivery.internal.dto.v1_0.util.OpenGraphSettingsUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.SEOSettingsUtil;
import com.liferay.layout.seo.model.LayoutSEOEntry;
import com.liferay.layout.seo.service.LayoutSEOEntryLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class PageSettingsUtil {
    public static PageSettings getPageSettings(final DLAppService dlAppService, final DLURLHelper dlURLHelper, final DTOConverterContext dtoConverterContext, final LayoutSEOEntryLocalService layoutSEOEntryLocalService, final Layout layout, final StorageEngineManager storageEngineManager) {
        return new PageSettings(){
            {
                this.hiddenFromNavigation = layout.isHidden();
                this.openGraphSettings = OpenGraphSettingsUtil.getOpenGraphSettings(dlAppService, dlURLHelper, dtoConverterContext, layoutSEOEntryLocalService, layout);
                this.seoSettings = SEOSettingsUtil.getSeoSettings(dtoConverterContext, layoutSEOEntryLocalService, layout);
                this.setCustomMetaTags(() -> PageSettingsUtil._getCustomMetaTags(dtoConverterContext, layout, layoutSEOEntryLocalService, dtoConverterContext.getLocale(), storageEngineManager));
            }
        };
    }

    private static CustomMetaTag[] _getCustomMetaTags(final DTOConverterContext dtoConverterContext, Layout layout, LayoutSEOEntryLocalService layoutSEOEntryLocalService, Locale locale, StorageEngineManager storageEngineManager) throws PortalException {
        LayoutSEOEntry layoutSEOEntry = layoutSEOEntryLocalService.fetchLayoutSEOEntry(layout.getGroupId(), layout.isPrivateLayout(), layout.getLayoutId());
        if (layoutSEOEntry == null || layoutSEOEntry.getDDMStorageId() == 0L) {
            return null;
        }
        ArrayList<2> customMetaTags = new ArrayList<2>();
        DDMFormValues ddmFormValues = storageEngineManager.getDDMFormValues(layoutSEOEntry.getDDMStorageId());
        List ddmFormFieldValues = ddmFormValues.getDDMFormFieldValues();
        for (DDMFormFieldValue ddmFormFieldValue : ddmFormFieldValues) {
            Value value = ddmFormFieldValue.getValue();
            final String valueString = value.getString(LocaleUtil.ROOT);
            List nestedDDMFormFieldValues = ddmFormFieldValue.getNestedDDMFormFieldValues();
            DDMFormFieldValue nestedDDMFormFieldValue = (DDMFormFieldValue)nestedDDMFormFieldValues.get(0);
            value = nestedDDMFormFieldValue.getValue();
            final String nestedValueString = value.getString(locale);
            final Map nestedValuesLocaleMap = value.getValues();
            customMetaTags.add(new CustomMetaTag(){
                {
                    this.key = valueString;
                    this.value = nestedValueString;
                    this.value_i18n = LocalizedMapUtil.getI18nMap((boolean)dtoConverterContext.isAcceptAllLanguages(), (Map)nestedValuesLocaleMap);
                }
            });
        }
        return customMetaTags.toArray(new CustomMetaTag[0]);
    }
}

