/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.dto.v1_0.mapper.util;

import com.liferay.headless.delivery.dto.v1_0.CustomCSSViewport;
import com.liferay.layout.responsive.ViewportSize;
import com.liferay.layout.util.structure.StyledLayoutStructureItem;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class StyledLayoutStructureItemUtil {
    public static String[] getCssClasses(StyledLayoutStructureItem styledLayoutStructureItem) {
        Set cssClasses = styledLayoutStructureItem.getCssClasses();
        if (SetUtil.isEmpty((Set)cssClasses)) {
            return null;
        }
        return ArrayUtil.toStringArray((Collection)cssClasses);
    }

    public static String getCustomCSS(StyledLayoutStructureItem styledLayoutStructureItem) {
        String customCSS = styledLayoutStructureItem.getCustomCSS();
        if (Validator.isNotNull((String)customCSS)) {
            return customCSS;
        }
        return null;
    }

    public static CustomCSSViewport[] getCustomCSSViewports(StyledLayoutStructureItem styledLayoutStructureItem) {
        String tabletCustomCSS;
        String portraitMobileCustomCSS;
        Map customCSSViewportsMap = styledLayoutStructureItem.getCustomCSSViewports();
        if (customCSSViewportsMap == null || customCSSViewportsMap.isEmpty()) {
            return null;
        }
        ArrayList<CustomCSSViewport> customCSSViewports = new ArrayList<CustomCSSViewport>();
        final String mobileLandscapeCustomCSS = (String)customCSSViewportsMap.get(ViewportSize.MOBILE_LANDSCAPE.getViewportSizeId());
        if (Validator.isNotNull((String)mobileLandscapeCustomCSS)) {
            customCSSViewports.add(new CustomCSSViewport(){
                {
                    this.setCustomCSS(mobileLandscapeCustomCSS);
                    this.setId(ViewportSize.MOBILE_LANDSCAPE.getViewportSizeId());
                }
            });
        }
        if (Validator.isNotNull((String)(portraitMobileCustomCSS = (String)customCSSViewportsMap.get(ViewportSize.PORTRAIT_MOBILE.getViewportSizeId())))) {
            customCSSViewports.add(new CustomCSSViewport(){
                {
                    this.setCustomCSS(portraitMobileCustomCSS);
                    this.setId(ViewportSize.PORTRAIT_MOBILE.getViewportSizeId());
                }
            });
        }
        if (Validator.isNotNull((String)(tabletCustomCSS = (String)customCSSViewportsMap.get(ViewportSize.TABLET.getViewportSizeId())))) {
            customCSSViewports.add(new CustomCSSViewport(){
                {
                    this.setCustomCSS(tabletCustomCSS);
                    this.setId(ViewportSize.TABLET.getViewportSizeId());
                }
            });
        }
        if (ListUtil.isEmpty(customCSSViewports)) {
            return null;
        }
        return customCSSViewports.toArray(new CustomCSSViewport[0]);
    }
}

