/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.dto.v1_0.mapper;

import com.liferay.headless.delivery.dto.v1_0.ColumnViewport;
import com.liferay.headless.delivery.dto.v1_0.ColumnViewportDefinition;
import com.liferay.headless.delivery.dto.v1_0.PageColumnDefinition;
import com.liferay.headless.delivery.dto.v1_0.PageElement;
import com.liferay.headless.delivery.internal.dto.v1_0.mapper.LayoutStructureItemMapper;
import com.liferay.layout.responsive.ViewportSize;
import com.liferay.layout.util.structure.ColumnLayoutStructureItem;
import com.liferay.layout.util.structure.LayoutStructureItem;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.MapUtil;
import java.util.Map;
import org.osgi.service.component.annotations.Component;

@Component(service={LayoutStructureItemMapper.class})
public class ColumnLayoutStructureItemMapper
implements LayoutStructureItemMapper {
    @Override
    public String getClassName() {
        return ColumnLayoutStructureItem.class.getName();
    }

    @Override
    public PageElement getPageElement(long groupId, LayoutStructureItem layoutStructureItem, boolean saveInlineContent, boolean saveMappingConfiguration) {
        final ColumnLayoutStructureItem columnLayoutStructureItem = (ColumnLayoutStructureItem)layoutStructureItem;
        return new PageElement(){
            {
                this.definition = new PageColumnDefinition(){
                    {
                        this.size = columnLayoutStructureItem.getSize();
                        this.setColumnViewports(() -> {
                            Map columnViewportConfigurationJSONObjects = columnLayoutStructureItem.getViewportConfigurationJSONObjects();
                            if (MapUtil.isEmpty((Map)columnViewportConfigurationJSONObjects)) {
                                return null;
                            }
                            ColumnViewport[] columnViewports = new ColumnViewport[]{ColumnLayoutStructureItemMapper.this._toColumnViewport(columnViewportConfigurationJSONObjects, ViewportSize.MOBILE_LANDSCAPE), ColumnLayoutStructureItemMapper.this._toColumnViewport(columnViewportConfigurationJSONObjects, ViewportSize.PORTRAIT_MOBILE), ColumnLayoutStructureItemMapper.this._toColumnViewport(columnViewportConfigurationJSONObjects, ViewportSize.TABLET)};
                            return columnViewports;
                        });
                    }
                };
                this.type = PageElement.Type.COLUMN;
            }
        };
    }

    private ColumnViewport _toColumnViewport(final Map<String, JSONObject> columnViewportConfigurationJSONObjects, final ViewportSize viewportSize) {
        return new ColumnViewport(){
            {
                this.columnViewportDefinition = ColumnLayoutStructureItemMapper.this._toColumnViewportColumnViewportDefinition(columnViewportConfigurationJSONObjects, viewportSize);
                this.id = viewportSize.getViewportSizeId();
            }
        };
    }

    private ColumnViewportDefinition _toColumnViewportColumnViewportDefinition(Map<String, JSONObject> columnViewportConfigurationJSONObjects, ViewportSize viewportSize) {
        if (!columnViewportConfigurationJSONObjects.containsKey(viewportSize.getViewportSizeId())) {
            return null;
        }
        final JSONObject jsonObject = columnViewportConfigurationJSONObjects.get(viewportSize.getViewportSizeId());
        return new ColumnViewportDefinition(){
            {
                this.setSize(() -> {
                    if (!jsonObject.has("size")) {
                        return null;
                    }
                    return jsonObject.getInt("size");
                });
            }
        };
    }
}

