/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.dto.v1_0.converter;

import com.liferay.headless.delivery.dto.v1_0.MasterPage;
import com.liferay.headless.delivery.dto.v1_0.PageDefinition;
import com.liferay.headless.delivery.dto.v1_0.Settings;
import com.liferay.headless.delivery.dto.v1_0.StyleBook;
import com.liferay.headless.delivery.internal.dto.v1_0.mapper.LayoutStructureItemMapperRegistry;
import com.liferay.headless.delivery.internal.dto.v1_0.util.PageElementUtil;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryLocalService;
import com.liferay.layout.util.structure.LayoutStructure;
import com.liferay.layout.util.structure.LayoutStructureItem;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ColorScheme;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.Theme;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.style.book.model.StyleBookEntry;
import com.liferay.style.book.service.StyleBookEntryLocalService;
import java.util.Map;
import java.util.Optional;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.layout.util.structure.LayoutStructure"}, service={DTOConverter.class, PageDefinitionDTOConverter.class})
public class PageDefinitionDTOConverter
implements DTOConverter<LayoutStructure, PageDefinition> {
    private static final Log _log = LogFactoryUtil.getLog(PageDefinitionDTOConverter.class);
    @Reference
    private LayoutPageTemplateEntryLocalService _layoutPageTemplateEntryLocalService;
    @Reference
    private LayoutStructureItemMapperRegistry _layoutStructureItemMapperRegistry;
    @Reference
    private StyleBookEntryLocalService _styleBookEntryLocalService;

    public String getContentType() {
        return PageDefinition.class.getSimpleName();
    }

    public PageDefinition toDTO(DTOConverterContext dtoConverterContext, final LayoutStructure layoutStructure) throws Exception {
        final Layout layout = Optional.ofNullable(dtoConverterContext.getAttribute("layout")).map(Layout.class::cast).orElseThrow(() -> new IllegalArgumentException("Layout is not defined for layout structure item " + layoutStructure.getMainItemId()));
        final LayoutStructureItem mainLayoutStructureItem = layoutStructure.getMainLayoutStructureItem();
        final boolean saveInlineContent = GetterUtil.getBoolean((Object)dtoConverterContext.getAttribute("saveInlineContent"), (boolean)true);
        final boolean saveMappingConfiguration = GetterUtil.getBoolean((Object)dtoConverterContext.getAttribute("saveMappingConfiguration"), (boolean)true);
        return new PageDefinition(){
            {
                this.pageElement = PageElementUtil.toPageElement(layout.getGroupId(), layoutStructure, mainLayoutStructureItem, PageDefinitionDTOConverter.this._layoutStructureItemMapperRegistry, saveInlineContent, saveMappingConfiguration);
                this.settings = PageDefinitionDTOConverter.this._toSettings(layout);
                this.version = 1.1;
            }
        };
    }

    private Settings _toSettings(final Layout layout) {
        final UnicodeProperties unicodeProperties = layout.getTypeSettingsProperties();
        return new Settings(){
            {
                this.setColorSchemeName(() -> {
                    ColorScheme colorScheme;
                    block3: {
                        colorScheme = null;
                        try {
                            colorScheme = layout.getColorScheme();
                        }
                        catch (PortalException portalException) {
                            if (!_log.isWarnEnabled()) break block3;
                            _log.warn((Throwable)portalException);
                        }
                    }
                    if (colorScheme == null) {
                        return null;
                    }
                    return colorScheme.getName();
                });
                this.setCss(() -> {
                    if (Validator.isNull((String)layout.getCss())) {
                        return null;
                    }
                    return layout.getCss();
                });
                this.setJavascript(() -> {
                    for (Map.Entry entry : unicodeProperties.entrySet()) {
                        String key = (String)entry.getKey();
                        if (!key.equals("javascript")) continue;
                        return (String)entry.getValue();
                    }
                    return null;
                });
                this.setMasterPage(() -> {
                    final LayoutPageTemplateEntry layoutPageTemplateEntry = PageDefinitionDTOConverter.this._layoutPageTemplateEntryLocalService.fetchLayoutPageTemplateEntryByPlid(layout.getMasterLayoutPlid());
                    if (layoutPageTemplateEntry == null) {
                        return null;
                    }
                    return new MasterPage(){
                        {
                            this.key = layoutPageTemplateEntry.getLayoutPageTemplateEntryKey();
                        }
                    };
                });
                this.setStyleBook(() -> {
                    final StyleBookEntry styleBookEntry = PageDefinitionDTOConverter.this._styleBookEntryLocalService.fetchStyleBookEntry(layout.getStyleBookEntryId());
                    if (styleBookEntry == null) {
                        return null;
                    }
                    return new StyleBook(){
                        {
                            this.key = styleBookEntry.getStyleBookEntryKey();
                            this.name = styleBookEntry.getName();
                        }
                    };
                });
                this.setThemeName(() -> {
                    Theme theme = layout.getTheme();
                    if (theme == null) {
                        return null;
                    }
                    return theme.getName();
                });
                this.setThemeSettings(() -> {
                    UnicodeProperties themeSettingsUnicodeProperties = new UnicodeProperties();
                    for (Map.Entry entry : unicodeProperties.entrySet()) {
                        String key = (String)entry.getKey();
                        if (!key.startsWith("lfr-theme:")) continue;
                        themeSettingsUnicodeProperties.setProperty(key, (String)entry.getValue());
                    }
                    if (themeSettingsUnicodeProperties.isEmpty()) {
                        return null;
                    }
                    return themeSettingsUnicodeProperties;
                });
            }
        };
    }
}

