/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.dto.v1_0.converter;

import com.liferay.asset.kernel.model.AssetTag;
import com.liferay.asset.kernel.service.AssetCategoryLocalService;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.asset.kernel.service.AssetLinkLocalService;
import com.liferay.asset.kernel.service.AssetTagLocalService;
import com.liferay.headless.delivery.dto.v1_0.MessageBoardThread;
import com.liferay.headless.delivery.dto.v1_0.TaxonomyCategoryBrief;
import com.liferay.headless.delivery.dto.v1_0.util.CreatorUtil;
import com.liferay.headless.delivery.dto.v1_0.util.CustomFieldsUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.AggregateRatingUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.CreatorStatisticsUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.RelatedContentUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.TaxonomyCategoryBriefUtil;
import com.liferay.message.boards.model.MBMessage;
import com.liferay.message.boards.model.MBMessageModel;
import com.liferay.message.boards.model.MBThread;
import com.liferay.message.boards.service.MBMessageLocalService;
import com.liferay.message.boards.service.MBStatsUserLocalService;
import com.liferay.message.boards.service.MBThreadFlagLocalService;
import com.liferay.message.boards.settings.MBGroupServiceSettings;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.workflow.WorkflowConstants;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.ratings.kernel.service.RatingsStatsLocalService;
import com.liferay.subscription.service.SubscriptionLocalService;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.message.boards.model.MBThread"}, service={DTOConverter.class, MessageBoardThreadDTOConverter.class})
public class MessageBoardThreadDTOConverter
implements DTOConverter<MBThread, MessageBoardThread> {
    @Reference
    private AssetCategoryLocalService _assetCategoryLocalService;
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;
    @Reference
    private AssetLinkLocalService _assetLinkLocalService;
    @Reference
    private AssetTagLocalService _assetTagLocalService;
    @Reference
    private MBMessageLocalService _mbMessageLocalService;
    @Reference
    private MBStatsUserLocalService _mbStatsUserLocalService;
    @Reference
    private MBThreadFlagLocalService _mbThreadFlagLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private RatingsStatsLocalService _ratingsStatsLocalService;
    @Reference
    private SubscriptionLocalService _subscriptionLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public String getContentType() {
        return MessageBoardThread.class.getSimpleName();
    }

    public MessageBoardThread toDTO(final DTOConverterContext dtoConverterContext, final MBThread mbThread) throws Exception {
        final String languageId = LocaleUtil.toLanguageId((Locale)dtoConverterContext.getLocale());
        final MBMessage mbMessage = this._mbMessageLocalService.getMessage(mbThread.getRootMessageId());
        final User user = this._userLocalService.fetchUser(mbThread.getUserId());
        return new MessageBoardThread(){
            {
                this.actions = dtoConverterContext.getActions();
                this.aggregateRating = AggregateRatingUtil.toAggregateRating(MessageBoardThreadDTOConverter.this._ratingsStatsLocalService.fetchStats(MBMessage.class.getName(), mbMessage.getMessageId()));
                this.articleBody = mbMessage.getBody();
                this.creator = CreatorUtil.toCreator((Portal)MessageBoardThreadDTOConverter.this._portal, (Optional)dtoConverterContext.getUriInfoOptional(), (User)user);
                this.customFields = CustomFieldsUtil.toCustomFields((boolean)dtoConverterContext.isAcceptAllLanguages(), (String)MBMessage.class.getName(), (long)mbMessage.getMessageId(), (long)mbThread.getCompanyId(), (Locale)dtoConverterContext.getLocale());
                this.dateCreated = mbMessage.getCreateDate();
                this.dateModified = mbMessage.getModifiedDate();
                this.encodingFormat = mbMessage.getFormat();
                this.friendlyUrlPath = mbMessage.getUrlSubject();
                this.hasValidAnswer = Stream.of(MessageBoardThreadDTOConverter.this._mbMessageLocalService.getChildMessages(mbMessage.getMessageId(), 0)).flatMap(Collection::stream).anyMatch(MBMessageModel::isAnswer);
                this.headline = mbMessage.getSubject();
                this.id = mbThread.getThreadId();
                this.keywords = (String[])ListUtil.toArray((List)MessageBoardThreadDTOConverter.this._assetTagLocalService.getTags(MBMessage.class.getName(), mbMessage.getMessageId()), (Accessor)AssetTag.NAME_ACCESSOR);
                this.locked = mbThread.isLocked();
                this.messageBoardRootMessageId = mbThread.getRootMessageId();
                this.messageBoardSectionId = mbMessage.getCategoryId();
                this.numberOfMessageBoardAttachments = mbMessage.getAttachmentsFileEntriesCount();
                this.numberOfMessageBoardMessages = MessageBoardThreadDTOConverter.this._mbMessageLocalService.getChildMessagesCount(mbMessage.getMessageId(), 0);
                this.relatedContents = RelatedContentUtil.toRelatedContents(MessageBoardThreadDTOConverter.this._assetEntryLocalService, MessageBoardThreadDTOConverter.this._assetLinkLocalService, dtoConverterContext.getDTOConverterRegistry(), mbMessage.getModelClassName(), mbMessage.getMessageId(), dtoConverterContext.getLocale());
                this.seen = MessageBoardThreadDTOConverter.this._mbThreadFlagLocalService.hasThreadFlag(dtoConverterContext.getUserId(), mbThread);
                this.showAsQuestion = mbThread.isQuestion();
                this.siteId = mbThread.getGroupId();
                this.status = WorkflowConstants.getStatusLabel((int)mbThread.getStatus());
                this.subscribed = MessageBoardThreadDTOConverter.this._subscriptionLocalService.isSubscribed(mbMessage.getCompanyId(), dtoConverterContext.getUserId(), MBThread.class.getName(), mbMessage.getThreadId());
                this.taxonomyCategoryBriefs = (TaxonomyCategoryBrief[])TransformUtil.transformToArray((Collection)MessageBoardThreadDTOConverter.this._assetCategoryLocalService.getCategories(MBMessage.class.getName(), mbThread.getRootMessageId()), assetCategory -> TaxonomyCategoryBriefUtil.toTaxonomyCategoryBrief(assetCategory, dtoConverterContext), TaxonomyCategoryBrief.class);
                this.threadType = MessageBoardThreadDTOConverter.this._toThreadType(languageId, mbThread.getGroupId(), mbThread.getPriority());
                this.viewCount = mbThread.getViewCount();
                this.setCreatorStatistics(() -> {
                    if (mbMessage.isAnonymous() || user == null || user.isDefaultUser()) {
                        return null;
                    }
                    Optional uriInfoOptional = dtoConverterContext.getUriInfoOptional();
                    return CreatorStatisticsUtil.toCreatorStatistics(mbMessage.getGroupId(), languageId, MessageBoardThreadDTOConverter.this._mbStatsUserLocalService, uriInfoOptional.orElse(null), user);
                });
            }
        };
    }

    private String _toThreadType(String languageId, Long siteId, double priority) throws Exception {
        String[] priorities;
        MBGroupServiceSettings mbGroupServiceSettings = MBGroupServiceSettings.getInstance((long)siteId);
        for (String priorityString : priorities = mbGroupServiceSettings.getPriorities(languageId)) {
            String[] parts = StringUtil.split((String)priorityString, (String)"|");
            if (priority != GetterUtil.getDouble((String)parts[2])) continue;
            return parts[0];
        }
        return null;
    }
}

