/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.dto.v1_0.converter;

import com.liferay.headless.delivery.dto.v1_0.MessageBoardSection;
import com.liferay.headless.delivery.dto.v1_0.util.CreatorUtil;
import com.liferay.headless.delivery.dto.v1_0.util.CustomFieldsUtil;
import com.liferay.message.boards.model.MBCategory;
import com.liferay.message.boards.service.MBCategoryService;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.subscription.service.SubscriptionLocalService;
import java.util.Locale;
import java.util.Optional;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.message.boards.model.MBCategory"}, service={DTOConverter.class, MessageBoardSectionDTOConverter.class})
public class MessageBoardSectionDTOConverter
implements DTOConverter<MBCategory, MessageBoardSection> {
    @Reference
    private MBCategoryService _mbCategoryService;
    @Reference
    private Portal _portal;
    @Reference
    private SubscriptionLocalService _subscriptionLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public String getContentType() {
        return MessageBoardSection.class.getSimpleName();
    }

    public MessageBoardSection toDTO(final DTOConverterContext dtoConverterContext) throws Exception {
        final MBCategory mbCategory = this._mbCategoryService.getCategory(((Long)dtoConverterContext.getId()).longValue());
        return new MessageBoardSection(){
            {
                this.actions = dtoConverterContext.getActions();
                this.creator = CreatorUtil.toCreator((Portal)MessageBoardSectionDTOConverter.this._portal, (Optional)dtoConverterContext.getUriInfoOptional(), (User)MessageBoardSectionDTOConverter.this._userLocalService.fetchUser(mbCategory.getUserId()));
                this.customFields = CustomFieldsUtil.toCustomFields((boolean)dtoConverterContext.isAcceptAllLanguages(), (String)MBCategory.class.getName(), (long)mbCategory.getCategoryId(), (long)mbCategory.getCompanyId(), (Locale)dtoConverterContext.getLocale());
                this.dateCreated = mbCategory.getCreateDate();
                this.dateModified = mbCategory.getModifiedDate();
                this.description = mbCategory.getDescription();
                this.id = mbCategory.getCategoryId();
                this.numberOfMessageBoardSections = MessageBoardSectionDTOConverter.this._mbCategoryService.getCategoriesCount(mbCategory.getGroupId(), mbCategory.getCategoryId(), 0);
                this.numberOfMessageBoardThreads = mbCategory.getThreadCount();
                this.siteId = mbCategory.getGroupId();
                this.subscribed = MessageBoardSectionDTOConverter.this._subscriptionLocalService.isSubscribed(mbCategory.getCompanyId(), dtoConverterContext.getUserId(), MBCategory.class.getName(), mbCategory.getCategoryId());
                this.title = mbCategory.getName();
                this.setParentMessageBoardSectionId(() -> {
                    if (mbCategory.getParentCategoryId() == 0L) {
                        return null;
                    }
                    return mbCategory.getParentCategoryId();
                });
            }
        };
    }
}

