/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.resource.v1_0;

import com.liferay.dynamic.data.mapping.util.DDMIndexer;
import com.liferay.expando.kernel.service.ExpandoColumnLocalService;
import com.liferay.expando.kernel.service.ExpandoTableLocalService;
import com.liferay.headless.common.spi.resource.SPIRatingResource;
import com.liferay.headless.common.spi.service.context.ServiceContextUtil;
import com.liferay.headless.delivery.dto.v1_0.KnowledgeBaseArticle;
import com.liferay.headless.delivery.dto.v1_0.Rating;
import com.liferay.headless.delivery.internal.dto.v1_0.converter.KnowledgeBaseArticleDTOConverter;
import com.liferay.headless.delivery.internal.dto.v1_0.util.CustomFieldsUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.EntityFieldsUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.RatingUtil;
import com.liferay.headless.delivery.internal.odata.entity.v1_0.KnowledgeBaseArticleEntityModel;
import com.liferay.headless.delivery.internal.resource.v1_0.BaseKnowledgeBaseArticleResourceImpl;
import com.liferay.headless.delivery.internal.search.aggregation.AggregationUtil;
import com.liferay.headless.delivery.internal.search.filter.FilterUtil;
import com.liferay.headless.delivery.internal.search.sort.SortUtil;
import com.liferay.headless.delivery.resource.v1_0.KnowledgeBaseArticleResource;
import com.liferay.knowledge.base.model.KBArticle;
import com.liferay.knowledge.base.model.KBFolder;
import com.liferay.knowledge.base.service.KBArticleService;
import com.liferay.knowledge.base.service.KBFolderService;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermFilter;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.search.aggregation.Aggregations;
import com.liferay.portal.search.legacy.searcher.SearchRequestBuilderFactory;
import com.liferay.portal.search.query.Queries;
import com.liferay.portal.search.searcher.SearchRequestBuilder;
import com.liferay.portal.search.sort.Sorts;
import com.liferay.portal.vulcan.aggregation.Aggregation;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.resource.EntityModelResource;
import com.liferay.portal.vulcan.util.SearchUtil;
import com.liferay.ratings.kernel.service.RatingsEntryLocalService;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import javax.ws.rs.core.MultivaluedMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/knowledge-base-article.properties"}, scope=ServiceScope.PROTOTYPE, service={KnowledgeBaseArticleResource.class})
public class KnowledgeBaseArticleResourceImpl
extends BaseKnowledgeBaseArticleResourceImpl
implements EntityModelResource {
    @Reference
    private Aggregations _aggregations;
    @Reference
    private DDMIndexer _ddmIndexer;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private ExpandoColumnLocalService _expandoColumnLocalService;
    @Reference
    private ExpandoTableLocalService _expandoTableLocalService;
    @Reference
    private KBArticleService _kbArticleService;
    @Reference
    private KBFolderService _kbFolderService;
    @Reference
    private KnowledgeBaseArticleDTOConverter _knowledgeBaseArticleDTOConverter;
    @Reference
    private Portal _portal;
    @Reference
    private Queries _queries;
    @Reference
    private RatingsEntryLocalService _ratingsEntryLocalService;
    @Reference
    private SearchRequestBuilderFactory _searchRequestBuilderFactory;
    @Reference
    private Sorts _sorts;
    @Reference
    private UserLocalService _userLocalService;

    @Override
    public void deleteKnowledgeBaseArticle(Long knowledgeBaseArticleId) throws Exception {
        this._kbArticleService.deleteKBArticle(knowledgeBaseArticleId.longValue());
    }

    @Override
    public void deleteKnowledgeBaseArticleMyRating(Long knowledgeBaseArticleId) throws Exception {
        SPIRatingResource<Rating> spiRatingResource = this._getSPIRatingResource();
        spiRatingResource.deleteRating(knowledgeBaseArticleId);
    }

    @Override
    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) {
        return new KnowledgeBaseArticleEntityModel(EntityFieldsUtil.getEntityFields(this._portal.getClassNameId(KBArticle.class.getName()), this.contextCompany.getCompanyId(), this._expandoColumnLocalService, this._expandoTableLocalService));
    }

    @Override
    public KnowledgeBaseArticle getKnowledgeBaseArticle(Long knowledgeBaseArticleId) throws Exception {
        return this._toKnowledgeBaseArticle(this._kbArticleService.getLatestKBArticle(knowledgeBaseArticleId.longValue(), 0));
    }

    @Override
    public Page<KnowledgeBaseArticle> getKnowledgeBaseArticleKnowledgeBaseArticlesPage(Long parentKnowledgeBaseArticleId, String search, Aggregation aggregation, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        KBArticle kbArticle = this._kbArticleService.getLatestKBArticle(parentKnowledgeBaseArticleId.longValue(), 0);
        return this._getKnowledgeBaseArticlesPage(HashMapBuilder.put((Object)"create", this.addAction("ADD_KB_ARTICLE", "postKnowledgeBaseArticleKnowledgeBaseArticle", "com.liferay.knowledge.base.admin", kbArticle.getGroupId())).put((Object)"get", this.addAction("VIEW", "getKnowledgeBaseArticleKnowledgeBaseArticlesPage", "com.liferay.knowledge.base.admin", kbArticle.getGroupId())).build(), (UnsafeConsumer<BooleanQuery, Exception>)((UnsafeConsumer)booleanQuery -> {
            BooleanFilter booleanFilter = booleanQuery.getPreBooleanFilter();
            booleanFilter.add((Filter)new TermFilter("parentMessageId", String.valueOf(kbArticle.getResourcePrimKey())), BooleanClauseOccur.MUST);
        }), kbArticle.getGroupId(), search, aggregation, filter, pagination, sorts);
    }

    @Override
    public Rating getKnowledgeBaseArticleMyRating(Long knowledgeBaseArticleId) throws Exception {
        SPIRatingResource<Rating> spiRatingResource = this._getSPIRatingResource();
        return (Rating)spiRatingResource.getRating(knowledgeBaseArticleId);
    }

    @Override
    public Page<KnowledgeBaseArticle> getKnowledgeBaseFolderKnowledgeBaseArticlesPage(Long knowledgeBaseFolderId, Boolean flatten, String search, Aggregation aggregation, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        KBFolder kbFolder = this._kbFolderService.getKBFolder(knowledgeBaseFolderId.longValue());
        return this._getKnowledgeBaseArticlesPage(HashMapBuilder.put((Object)"create", this.addAction("ADD_KB_ARTICLE", "postKnowledgeBaseFolderKnowledgeBaseArticle", "com.liferay.knowledge.base.admin", kbFolder.getGroupId())).put((Object)"get", this.addAction("VIEW", "getKnowledgeBaseFolderKnowledgeBaseArticlesPage", "com.liferay.knowledge.base.admin", kbFolder.getGroupId())).build(), (UnsafeConsumer<BooleanQuery, Exception>)((UnsafeConsumer)booleanQuery -> {
            BooleanFilter booleanFilter = booleanQuery.getPreBooleanFilter();
            if (GetterUtil.getBoolean((Object)flatten)) {
                booleanFilter.add((Filter)new TermFilter("treePath", String.valueOf(kbFolder.getKbFolderId())), BooleanClauseOccur.MUST);
            } else {
                booleanFilter.add((Filter)new TermFilter("folderId", String.valueOf(kbFolder.getKbFolderId())), BooleanClauseOccur.MUST);
                booleanFilter.add((Filter)new TermFilter("parentMessageId", String.valueOf(kbFolder.getKbFolderId())), BooleanClauseOccur.MUST);
            }
        }), kbFolder.getGroupId(), search, aggregation, filter, pagination, sorts);
    }

    @Override
    public Page<KnowledgeBaseArticle> getSiteKnowledgeBaseArticlesPage(Long siteId, Boolean flatten, String search, Aggregation aggregation, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return this._getKnowledgeBaseArticlesPage(HashMapBuilder.put((Object)"create", this.addAction("ADD_KB_ARTICLE", "postSiteKnowledgeBaseArticle", "com.liferay.knowledge.base.admin", siteId)).put((Object)"get", this.addAction("VIEW", "getSiteKnowledgeBaseArticlesPage", "com.liferay.knowledge.base.admin", siteId)).put((Object)"subscribe", this.addAction("SUBSCRIBE", "putSiteKnowledgeBaseArticleSubscribe", "com.liferay.knowledge.base.admin", siteId)).put((Object)"unsubscribe", this.addAction("SUBSCRIBE", "putSiteKnowledgeBaseArticleUnsubscribe", "com.liferay.knowledge.base.admin", siteId)).build(), (UnsafeConsumer<BooleanQuery, Exception>)((UnsafeConsumer)booleanQuery -> {
            if (!GetterUtil.getBoolean((Object)flatten)) {
                BooleanFilter booleanFilter = booleanQuery.getPreBooleanFilter();
                booleanFilter.add((Filter)new TermFilter("folderId", "0"), BooleanClauseOccur.MUST);
                booleanFilter.add((Filter)new TermFilter("parentMessageId", "0"), BooleanClauseOccur.MUST);
            }
        }), siteId, search, aggregation, filter, pagination, sorts);
    }

    @Override
    public KnowledgeBaseArticle postKnowledgeBaseArticleKnowledgeBaseArticle(Long parentKnowledgeBaseArticleId, KnowledgeBaseArticle knowledgeBaseArticle) throws Exception {
        KBArticle kbArticle = this._kbArticleService.getLatestKBArticle(parentKnowledgeBaseArticleId.longValue(), 0);
        return this._getKnowledgeBaseArticle(kbArticle.getGroupId(), this._portal.getClassNameId(KBArticle.class.getName()), parentKnowledgeBaseArticleId, knowledgeBaseArticle);
    }

    @Override
    public Rating postKnowledgeBaseArticleMyRating(Long knowledgeBaseArticleId, Rating rating) throws Exception {
        SPIRatingResource<Rating> spiRatingResource = this._getSPIRatingResource();
        return (Rating)spiRatingResource.addOrUpdateRating((Number)rating.getRatingValue(), knowledgeBaseArticleId.longValue());
    }

    @Override
    public KnowledgeBaseArticle postKnowledgeBaseFolderKnowledgeBaseArticle(Long knowledgeBaseFolderId, KnowledgeBaseArticle knowledgeBaseArticle) throws Exception {
        KBFolder kbFolder = this._kbFolderService.getKBFolder(knowledgeBaseFolderId.longValue());
        return this._getKnowledgeBaseArticle(kbFolder.getGroupId(), this._portal.getClassNameId(KBFolder.class.getName()), knowledgeBaseFolderId, knowledgeBaseArticle);
    }

    @Override
    public KnowledgeBaseArticle postSiteKnowledgeBaseArticle(Long siteId, KnowledgeBaseArticle knowledgeBaseArticle) throws Exception {
        return this._getKnowledgeBaseArticle(siteId, this._portal.getClassNameId(KBFolder.class.getName()), 0L, knowledgeBaseArticle);
    }

    @Override
    public KnowledgeBaseArticle putKnowledgeBaseArticle(Long knowledgeBaseArticleId, KnowledgeBaseArticle knowledgeBaseArticle) throws Exception {
        return this._toKnowledgeBaseArticle(this._kbArticleService.updateKBArticle(knowledgeBaseArticleId.longValue(), knowledgeBaseArticle.getTitle(), knowledgeBaseArticle.getArticleBody(), knowledgeBaseArticle.getDescription(), null, null, null, null, ServiceContextUtil.createServiceContext((Long[])Optional.ofNullable(knowledgeBaseArticle.getTaxonomyCategoryIds()).orElse(new Long[0]), (String[])Optional.ofNullable(knowledgeBaseArticle.getKeywords()).orElse(new String[0]), this._getExpandoBridgeAttributes(knowledgeBaseArticle), (Long)knowledgeBaseArticle.getSiteId(), (String)knowledgeBaseArticle.getViewableByAsString())));
    }

    @Override
    public Rating putKnowledgeBaseArticleMyRating(Long knowledgeBaseArticleId, Rating rating) throws Exception {
        SPIRatingResource<Rating> spiRatingResource = this._getSPIRatingResource();
        return (Rating)spiRatingResource.addOrUpdateRating((Number)rating.getRatingValue(), knowledgeBaseArticleId.longValue());
    }

    @Override
    public void putKnowledgeBaseArticleSubscribe(Long knowledgeBaseArticleId) throws Exception {
        KBArticle kbArticle = this._kbArticleService.getLatestKBArticle(knowledgeBaseArticleId.longValue(), 0);
        this._kbArticleService.subscribeKBArticle(kbArticle.getGroupId(), kbArticle.getResourcePrimKey());
    }

    @Override
    public void putKnowledgeBaseArticleUnsubscribe(Long knowledgeBaseArticleId) throws Exception {
        this._kbArticleService.unsubscribeKBArticle(knowledgeBaseArticleId.longValue());
    }

    @Override
    public void putSiteKnowledgeBaseArticleSubscribe(Long siteId) throws Exception {
        this._kbArticleService.subscribeGroupKBArticles(siteId.longValue(), "com_liferay_knowledge_base_web_portlet_DisplayPortlet");
    }

    @Override
    public void putSiteKnowledgeBaseArticleUnsubscribe(Long siteId) throws Exception {
        this._kbArticleService.unsubscribeGroupKBArticles(siteId.longValue(), "com_liferay_knowledge_base_web_portlet_DisplayPortlet");
    }

    private Map<String, Serializable> _getExpandoBridgeAttributes(KnowledgeBaseArticle knowledgeBaseArticle) {
        return CustomFieldsUtil.toMap(KBArticle.class.getName(), this.contextCompany.getCompanyId(), knowledgeBaseArticle.getCustomFields(), this.contextAcceptLanguage.getPreferredLocale());
    }

    private KnowledgeBaseArticle _getKnowledgeBaseArticle(Long siteId, long parentResourceClassNameId, Long parentResourcePrimaryKey, KnowledgeBaseArticle knowledgeBaseArticle) throws Exception {
        return this._toKnowledgeBaseArticle(this._kbArticleService.addKBArticle("com_liferay_knowledge_base_web_portlet_DisplayPortlet", parentResourceClassNameId, parentResourcePrimaryKey.longValue(), knowledgeBaseArticle.getTitle(), knowledgeBaseArticle.getFriendlyUrlPath(), knowledgeBaseArticle.getArticleBody(), knowledgeBaseArticle.getDescription(), null, null, null, ServiceContextUtil.createServiceContext((Long[])knowledgeBaseArticle.getTaxonomyCategoryIds(), (String[])knowledgeBaseArticle.getKeywords(), this._getExpandoBridgeAttributes(knowledgeBaseArticle), (Long)siteId, (String)knowledgeBaseArticle.getViewableByAsString())));
    }

    private Page<KnowledgeBaseArticle> _getKnowledgeBaseArticlesPage(Map<String, Map<String, String>> actions, UnsafeConsumer<BooleanQuery, Exception> booleanQueryUnsafeConsumer, Long siteId, String keywords, Aggregation aggregation, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return SearchUtil.search(actions, booleanQueryUnsafeConsumer, (Filter)FilterUtil.processFilter(this._ddmIndexer, filter), KBArticle.class, (String)keywords, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), searchContext -> {
            searchContext.addVulcanAggregation(aggregation);
            searchContext.setAttribute("status", (Serializable)Integer.valueOf(0));
            searchContext.setCompanyId(this.contextCompany.getCompanyId());
            searchContext.setGroupIds(new long[]{siteId});
            if (keywords == null) {
                searchContext.setKeywords("");
            }
            SearchRequestBuilder searchRequestBuilder = this._searchRequestBuilderFactory.builder((SearchContext)searchContext);
            AggregationUtil.processVulcanAggregation(this._aggregations, this._ddmIndexer, this._queries, searchRequestBuilder, aggregation);
            SortUtil.processSorts(this._ddmIndexer, searchRequestBuilder, searchContext.getSorts(), this._queries, this._sorts);
        }, (Sort[])sorts, document -> this._toKnowledgeBaseArticle(this._kbArticleService.getLatestKBArticle(GetterUtil.getLong((String)document.get("entryClassPK")), 0)));
    }

    private SPIRatingResource<Rating> _getSPIRatingResource() {
        return new SPIRatingResource(KBArticle.class.getName(), this._ratingsEntryLocalService, ratingsEntry -> {
            KBArticle kbArticle = this._kbArticleService.getLatestKBArticle(ratingsEntry.getClassPK(), 0);
            return RatingUtil.toRating(HashMapBuilder.put((Object)"create", this.addAction("UPDATE", kbArticle.getResourcePrimKey(), "postKnowledgeBaseArticleMyRating", kbArticle.getUserId(), "com.liferay.knowledge.base.model.KBArticle", kbArticle.getGroupId())).put((Object)"delete", this.addAction("UPDATE", kbArticle.getResourcePrimKey(), "deleteKnowledgeBaseArticleMyRating", kbArticle.getUserId(), "com.liferay.knowledge.base.model.KBArticle", kbArticle.getGroupId())).put((Object)"get", this.addAction("VIEW", kbArticle.getResourcePrimKey(), "getKnowledgeBaseArticleMyRating", kbArticle.getUserId(), "com.liferay.knowledge.base.model.KBArticle", kbArticle.getGroupId())).put((Object)"replace", this.addAction("UPDATE", kbArticle.getResourcePrimKey(), "putKnowledgeBaseArticleMyRating", kbArticle.getUserId(), "com.liferay.knowledge.base.model.KBArticle", kbArticle.getGroupId())).build(), this._portal, ratingsEntry, this._userLocalService);
        }, this.contextUser);
    }

    private KnowledgeBaseArticle _toKnowledgeBaseArticle(KBArticle kbArticle) throws Exception {
        if (kbArticle == null) {
            return null;
        }
        return this._knowledgeBaseArticleDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), (Map)HashMapBuilder.put((Object)"delete", this.addAction("DELETE", kbArticle.getResourcePrimKey(), "deleteKnowledgeBaseArticle", kbArticle.getUserId(), "com.liferay.knowledge.base.model.KBArticle", kbArticle.getGroupId())).put((Object)"get", this.addAction("VIEW", kbArticle.getResourcePrimKey(), "getKnowledgeBaseArticle", kbArticle.getUserId(), "com.liferay.knowledge.base.model.KBArticle", kbArticle.getGroupId())).put((Object)"replace", this.addAction("UPDATE", kbArticle.getResourcePrimKey(), "putKnowledgeBaseArticle", kbArticle.getUserId(), "com.liferay.knowledge.base.model.KBArticle", kbArticle.getGroupId())).put((Object)"subscribe", this.addAction("SUBSCRIBE", kbArticle.getResourcePrimKey(), "putKnowledgeBaseArticleSubscribe", kbArticle.getUserId(), "com.liferay.knowledge.base.model.KBArticle", kbArticle.getGroupId())).put((Object)"unsubscribe", this.addAction("SUBSCRIBE", kbArticle.getResourcePrimKey(), "putKnowledgeBaseArticleUnsubscribe", kbArticle.getUserId(), "com.liferay.knowledge.base.model.KBArticle", kbArticle.getGroupId())).build(), this._dtoConverterRegistry, (Object)kbArticle.getResourcePrimKey(), this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser));
    }
}

