/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.dto.v1_0.util;

import com.liferay.expando.kernel.model.ExpandoColumn;
import com.liferay.expando.kernel.model.ExpandoTable;
import com.liferay.expando.kernel.service.ExpandoColumnLocalService;
import com.liferay.expando.kernel.service.ExpandoTableLocalService;
import com.liferay.expando.kernel.util.ExpandoBridgeIndexerUtil;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.odata.entity.BooleanEntityField;
import com.liferay.portal.odata.entity.DateTimeEntityField;
import com.liferay.portal.odata.entity.EntityField;
import com.liferay.portal.odata.entity.StringEntityField;
import com.liferay.portal.odata.normalizer.Normalizer;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class EntityFieldsUtil {
    public static List<EntityField> getEntityFields(long classNameId, long companyId, ExpandoColumnLocalService expandoColumnLocalService, ExpandoTableLocalService expandoTableLocalService) {
        ExpandoTable expandoTable = expandoTableLocalService.fetchDefaultTable(companyId, classNameId);
        if (expandoTable == null) {
            return Collections.emptyList();
        }
        List expandoColumns = expandoColumnLocalService.getColumns(expandoTable.getTableId());
        Stream expandoColumnStream = expandoColumns.stream();
        return expandoColumnStream.map(EntityFieldsUtil::_getEntityField).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static EntityField _getEntityField(ExpandoColumn expandoColumn) {
        UnicodeProperties unicodeProperties = expandoColumn.getTypeSettingsProperties();
        int indexType = GetterUtil.getInteger((String)((String)unicodeProperties.get((Object)"index-type")));
        if (indexType == 0) {
            return null;
        }
        int type = expandoColumn.getType();
        String externalName = Normalizer.normalizeIdentifier((String)expandoColumn.getName());
        String internalName = ExpandoBridgeIndexerUtil.encodeFieldName((String)expandoColumn.getName(), (int)indexType);
        if (type == 1) {
            return new BooleanEntityField(externalName, locale -> internalName);
        }
        if (type == 3) {
            return new DateTimeEntityField(externalName, locale -> Field.getSortableFieldName((String)internalName), locale -> internalName);
        }
        if (type == 20) {
            return new StringEntityField(externalName, locale -> Field.getLocalizedName((Locale)locale, (String)internalName));
        }
        return new StringEntityField(externalName, locale -> internalName);
    }
}

