/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.resource.v1_0;

import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesSerializer;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesSerializerSerializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesSerializerSerializeResponse;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesSerializerTracker;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.service.DDMStructureService;
import com.liferay.dynamic.data.mapping.service.DDMTemplateService;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.storage.Field;
import com.liferay.dynamic.data.mapping.storage.Fields;
import com.liferay.dynamic.data.mapping.util.DDM;
import com.liferay.dynamic.data.mapping.validator.DDMFormValuesValidationException;
import com.liferay.dynamic.data.mapping.validator.DDMFormValuesValidator;
import com.liferay.expando.kernel.service.ExpandoColumnLocalService;
import com.liferay.expando.kernel.service.ExpandoTableLocalService;
import com.liferay.headless.common.spi.resource.SPIRatingResource;
import com.liferay.headless.common.spi.service.context.ServiceContextUtil;
import com.liferay.headless.delivery.dto.v1_0.ContentField;
import com.liferay.headless.delivery.dto.v1_0.Rating;
import com.liferay.headless.delivery.dto.v1_0.StructuredContent;
import com.liferay.headless.delivery.dto.v1_0.converter.DTOConverterContext;
import com.liferay.headless.delivery.dto.v1_0.converter.DefaultDTOConverterContext;
import com.liferay.headless.delivery.internal.dto.v1_0.converter.StructuredContentDTOConverter;
import com.liferay.headless.delivery.internal.dto.v1_0.util.CustomFieldsUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.DDMFormValuesUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.DDMValueUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.EntityFieldsUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.RatingUtil;
import com.liferay.headless.delivery.internal.odata.entity.v1_0.EntityFieldsProvider;
import com.liferay.headless.delivery.internal.odata.entity.v1_0.StructuredContentEntityModel;
import com.liferay.headless.delivery.internal.resource.v1_0.BaseStructuredContentResourceImpl;
import com.liferay.headless.delivery.resource.v1_0.StructuredContentResource;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.model.JournalArticleDisplay;
import com.liferay.journal.model.JournalFolder;
import com.liferay.journal.service.JournalArticleLocalService;
import com.liferay.journal.service.JournalArticleService;
import com.liferay.journal.service.JournalFolderService;
import com.liferay.journal.util.JournalContent;
import com.liferay.journal.util.JournalConverter;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermFilter;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.odata.entity.EntityField;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.resource.EntityModelResource;
import com.liferay.portal.vulcan.util.ContentLanguageUtil;
import com.liferay.portal.vulcan.util.LocalDateTimeUtil;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import com.liferay.portal.vulcan.util.SearchUtil;
import com.liferay.ratings.kernel.service.RatingsEntryLocalService;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.AbstractMap;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/structured-content.properties"}, scope=ServiceScope.PROTOTYPE, service={StructuredContentResource.class})
public class StructuredContentResourceImpl
extends BaseStructuredContentResourceImpl
implements EntityModelResource {
    @Reference
    private DDM _ddm;
    @Reference
    private DDMFormValuesSerializerTracker _ddmFormValuesSerializerTracker;
    @Reference
    private DDMFormValuesValidator _ddmFormValuesValidator;
    @Reference
    private DDMStructureService _ddmStructureService;
    @Reference
    private DDMTemplateService _ddmTemplateService;
    @Reference
    private DLAppService _dlAppService;
    @Reference
    private EntityFieldsProvider _entityFieldsProvider;
    @Reference
    private ExpandoColumnLocalService _expandoColumnLocalService;
    @Reference
    private ExpandoTableLocalService _expandoTableLocalService;
    @Context
    private HttpServletRequest _httpServletRequest;
    @Context
    private HttpServletResponse _httpServletResponse;
    @Reference
    private JournalArticleLocalService _journalArticleLocalService;
    @Reference(target="(model.class.name=com.liferay.journal.model.JournalArticle)")
    private ModelResourcePermission<JournalArticle> _journalArticleModelResourcePermission;
    @Reference
    private JournalArticleService _journalArticleService;
    @Reference
    private JournalContent _journalContent;
    @Reference
    private JournalConverter _journalConverter;
    @Reference
    private JournalFolderService _journalFolderService;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private RatingsEntryLocalService _ratingsEntryLocalService;
    @Reference
    private StructuredContentDTOConverter _structuredContentDTOConverter;
    @Context
    private User _user;
    @Reference
    private UserLocalService _userLocalService;

    @Override
    public void deleteStructuredContent(Long structuredContentId) throws Exception {
        JournalArticle journalArticle = this._journalArticleService.getLatestArticle(structuredContentId.longValue());
        this._journalArticleService.deleteArticle(journalArticle.getGroupId(), journalArticle.getArticleId(), journalArticle.getArticleResourceUuid(), new ServiceContext());
    }

    @Override
    public void deleteStructuredContentMyRating(Long structuredContentId) throws Exception {
        SPIRatingResource<Rating> spiRatingResource = this._getSPIRatingResource();
        spiRatingResource.deleteRating(structuredContentId);
    }

    @Override
    public Page<StructuredContent> getContentStructureStructuredContentsPage(Long contentStructureId, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return this._getStructuredContentsPage((UnsafeConsumer<BooleanQuery, Exception>)((UnsafeConsumer)booleanQuery -> {
            if (contentStructureId != null) {
                BooleanFilter booleanFilter = booleanQuery.getPreBooleanFilter();
                booleanFilter.add((Filter)new TermFilter("classTypeId", contentStructureId.toString()), BooleanClauseOccur.MUST);
            }
        }), null, search, filter, pagination, sorts);
    }

    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) throws Exception {
        List<EntityField> entityFields = null;
        Long contentStructureId = GetterUtil.getLong((String)((String)multivaluedMap.getFirst((Object)"contentStructureId")));
        if (contentStructureId > 0L) {
            DDMStructure ddmStructure = this._ddmStructureService.getStructure(contentStructureId.longValue());
            entityFields = this._entityFieldsProvider.provide(ddmStructure);
        }
        return new StructuredContentEntityModel(entityFields, EntityFieldsUtil.getEntityFields(this._portal.getClassNameId(JournalArticle.class.getName()), this.contextCompany.getCompanyId(), this._expandoColumnLocalService, this._expandoTableLocalService));
    }

    @Override
    public StructuredContent getSiteStructuredContentByKey(Long siteId, String key) throws Exception {
        JournalArticle journalArticle = this._journalArticleService.getArticle(siteId.longValue(), key);
        return this._getStructuredContent(journalArticle);
    }

    @Override
    public StructuredContent getSiteStructuredContentByUuid(Long siteId, String uuid) throws Exception {
        JournalArticle journalArticle = this._journalArticleLocalService.fetchJournalArticleByUuidAndGroupId(uuid, siteId.longValue());
        this._journalArticleModelResourcePermission.check(PermissionThreadLocal.getPermissionChecker(), journalArticle.getResourcePrimKey(), "VIEW");
        return this._getStructuredContent(journalArticle);
    }

    @Override
    public Page<StructuredContent> getSiteStructuredContentsPage(Long siteId, Boolean flatten, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return this._getStructuredContentsPage((UnsafeConsumer<BooleanQuery, Exception>)((UnsafeConsumer)booleanQuery -> {
            BooleanFilter booleanFilter = booleanQuery.getPreBooleanFilter();
            if (!GetterUtil.getBoolean((Object)flatten)) {
                booleanFilter.add((Filter)new TermFilter("folderId", String.valueOf(0L)), BooleanClauseOccur.MUST);
            }
        }), siteId, search, filter, pagination, sorts);
    }

    @Override
    public StructuredContent getStructuredContent(Long structuredContentId) throws Exception {
        JournalArticle journalArticle = this._journalArticleService.getLatestArticle(structuredContentId.longValue());
        return this._getStructuredContent(journalArticle);
    }

    @Override
    public Page<StructuredContent> getStructuredContentFolderStructuredContentsPage(Long structuredContentFolderId, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return this._getStructuredContentsPage((UnsafeConsumer<BooleanQuery, Exception>)((UnsafeConsumer)booleanQuery -> {
            if (structuredContentFolderId != null) {
                BooleanFilter booleanFilter = booleanQuery.getPreBooleanFilter();
                booleanFilter.add((Filter)new TermFilter("folderId", structuredContentFolderId.toString()), BooleanClauseOccur.MUST);
            }
        }), null, search, filter, pagination, sorts);
    }

    @Override
    public Rating getStructuredContentMyRating(Long structuredContentId) throws Exception {
        SPIRatingResource<Rating> spiRatingResource = this._getSPIRatingResource();
        return (Rating)spiRatingResource.getRating(structuredContentId);
    }

    @Override
    public String getStructuredContentRenderedContentTemplate(Long structuredContentId, Long templateId) throws Exception {
        JournalArticle journalArticle = this._journalArticleService.getLatestArticle(structuredContentId.longValue());
        ThemeDisplay themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        themeDisplay.setScopeGroupId(journalArticle.getGroupId());
        themeDisplay.setSiteGroupId(journalArticle.getGroupId());
        DDMTemplate ddmTemplate = this._ddmTemplateService.getTemplate(templateId.longValue());
        JournalArticleDisplay journalArticleDisplay = this._journalContent.getDisplay(journalArticle.getGroupId(), journalArticle.getArticleId(), ddmTemplate.getTemplateKey(), null, this.contextAcceptLanguage.getPreferredLanguageId(), themeDisplay);
        String content = journalArticleDisplay.getContent();
        return content.replaceAll("[\\t\\n]", "");
    }

    @Override
    public StructuredContent patchStructuredContent(Long structuredContentId, StructuredContent structuredContent) throws Exception {
        JournalArticle journalArticle = this._journalArticleService.getLatestArticle(structuredContentId.longValue());
        if (!ArrayUtil.contains((Object[])journalArticle.getAvailableLanguageIds(), (Object)this.contextAcceptLanguage.getPreferredLanguageId())) {
            throw new BadRequestException(StringBundler.concat((Object[])new Object[]{"Unable to patch structured content with language ", LocaleUtil.toW3cLanguageId((String)this.contextAcceptLanguage.getPreferredLanguageId()), " because it is only available in the following languages ", LocaleUtil.toW3cLanguageIds((String[])journalArticle.getAvailableLanguageIds())}));
        }
        DDMStructure ddmStructure = journalArticle.getDDMStructure();
        this._validateContentFields(structuredContent.getContentFields(), ddmStructure);
        LocalDateTime localDateTime = LocalDateTimeUtil.toLocalDateTime((Date)structuredContent.getDatePublished(), (Date)journalArticle.getDisplayDate());
        return this._toStructuredContent(this._journalArticleService.updateArticle(journalArticle.getGroupId(), journalArticle.getFolderId(), journalArticle.getArticleId(), journalArticle.getVersion(), LocalizedMapUtil.patch((Map)journalArticle.getTitleMap(), (Locale)this.contextAcceptLanguage.getPreferredLocale(), (String)structuredContent.getTitle()), LocalizedMapUtil.patch((Map)journalArticle.getDescriptionMap(), (Locale)this.contextAcceptLanguage.getPreferredLocale(), (String)structuredContent.getDescription()), LocalizedMapUtil.patch((Map)journalArticle.getFriendlyURLMap(), (Locale)this.contextAcceptLanguage.getPreferredLocale(), (String)structuredContent.getFriendlyUrlPath()), this._journalConverter.getContent(ddmStructure, this._toPatchedFields(structuredContent.getContentFields(), journalArticle)), journalArticle.getDDMStructureKey(), this._getDDMTemplateKey(ddmStructure), journalArticle.getLayoutUuid(), localDateTime.getMonthValue() - 1, localDateTime.getDayOfMonth(), localDateTime.getYear(), localDateTime.getHour(), localDateTime.getMinute(), 0, 0, 0, 0, 0, true, 0, 0, 0, 0, 0, true, true, false, null, null, null, null, ServiceContextUtil.createServiceContext((Long[])structuredContent.getTaxonomyCategoryIds(), (String[])structuredContent.getKeywords(), this._getExpandoBridgeAttributes(structuredContent), (Long)journalArticle.getGroupId(), (String)structuredContent.getViewableByAsString())));
    }

    @Override
    public StructuredContent postSiteStructuredContent(Long siteId, StructuredContent structuredContent) throws Exception {
        return this._addStructuredContent(siteId, 0L, structuredContent);
    }

    @Override
    public StructuredContent postStructuredContentFolderStructuredContent(Long structuredContentFolderId, StructuredContent structuredContent) throws Exception {
        JournalFolder journalFolder = this._journalFolderService.getFolder(structuredContentFolderId.longValue());
        return this._addStructuredContent(journalFolder.getGroupId(), structuredContentFolderId, structuredContent);
    }

    @Override
    public Rating postStructuredContentMyRating(Long structuredContentId, Rating rating) throws Exception {
        SPIRatingResource<Rating> spiRatingResource = this._getSPIRatingResource();
        return (Rating)spiRatingResource.addOrUpdateRating((Number)rating.getRatingValue(), structuredContentId.longValue());
    }

    @Override
    public StructuredContent putStructuredContent(Long structuredContentId, StructuredContent structuredContent) throws Exception {
        JournalArticle journalArticle = this._journalArticleService.getLatestArticle(structuredContentId.longValue());
        DDMStructure ddmStructure = journalArticle.getDDMStructure();
        this._validateContentFields(structuredContent.getContentFields(), ddmStructure);
        LocalDateTime localDateTime = LocalDateTimeUtil.toLocalDateTime((Date)structuredContent.getDatePublished(), (Date)journalArticle.getDisplayDate());
        return this._toStructuredContent(this._journalArticleService.updateArticle(journalArticle.getGroupId(), journalArticle.getFolderId(), journalArticle.getArticleId(), journalArticle.getVersion(), LocalizedMapUtil.merge((Map)journalArticle.getTitleMap(), new AbstractMap.SimpleEntry<Locale, String>(this.contextAcceptLanguage.getPreferredLocale(), structuredContent.getTitle())), LocalizedMapUtil.merge((Map)journalArticle.getDescriptionMap(), new AbstractMap.SimpleEntry<Locale, String>(this.contextAcceptLanguage.getPreferredLocale(), structuredContent.getDescription())), LocalizedMapUtil.merge((Map)journalArticle.getFriendlyURLMap(), new AbstractMap.SimpleEntry<Locale, String>(this.contextAcceptLanguage.getPreferredLocale(), structuredContent.getFriendlyUrlPath())), this._journalConverter.getContent(ddmStructure, this._toFields(structuredContent.getContentFields(), journalArticle)), journalArticle.getDDMStructureKey(), this._getDDMTemplateKey(ddmStructure), journalArticle.getLayoutUuid(), localDateTime.getMonthValue() - 1, localDateTime.getDayOfMonth(), localDateTime.getYear(), localDateTime.getHour(), localDateTime.getMinute(), 0, 0, 0, 0, 0, true, 0, 0, 0, 0, 0, true, true, false, null, null, null, null, ServiceContextUtil.createServiceContext((Long[])structuredContent.getTaxonomyCategoryIds(), (String[])structuredContent.getKeywords(), this._getExpandoBridgeAttributes(structuredContent), (Long)journalArticle.getGroupId(), (String)structuredContent.getViewableByAsString())));
    }

    @Override
    public Rating putStructuredContentMyRating(Long structuredContentId, Rating rating) throws Exception {
        SPIRatingResource<Rating> spiRatingResource = this._getSPIRatingResource();
        return (Rating)spiRatingResource.addOrUpdateRating((Number)rating.getRatingValue(), structuredContentId.longValue());
    }

    private StructuredContent _addStructuredContent(Long siteId, Long parentStructuredContentFolderId, final StructuredContent structuredContent) throws Exception {
        DDMStructure ddmStructure = this._checkDDMStructurePermission(structuredContent);
        LocalDateTime localDateTime = LocalDateTimeUtil.toLocalDateTime((Date)structuredContent.getDatePublished());
        if (!LocaleUtil.equals((Locale)LocaleUtil.fromLanguageId((String)ddmStructure.getDefaultLanguageId()), (Locale)this.contextAcceptLanguage.getPreferredLocale())) {
            String w3cLanguageId = LocaleUtil.toW3cLanguageId((String)ddmStructure.getDefaultLanguageId());
            throw new BadRequestException("Structured contents can only be created with the default language " + w3cLanguageId);
        }
        this._validateContentFields(structuredContent.getContentFields(), ddmStructure);
        return this._toStructuredContent(this._journalArticleService.addArticle(siteId.longValue(), parentStructuredContentFolderId.longValue(), 0L, 0L, null, true, (Map)new HashMap<Locale, String>(){
            {
                this.put(StructuredContentResourceImpl.this.contextAcceptLanguage.getPreferredLocale(), structuredContent.getTitle());
            }
        }, (Map)new HashMap<Locale, String>(){
            {
                this.put(StructuredContentResourceImpl.this.contextAcceptLanguage.getPreferredLocale(), structuredContent.getDescription());
            }
        }, this._createJournalArticleContent(DDMFormValuesUtil.toDDMFormValues(structuredContent.getContentFields(), ddmStructure.getDDMForm(), this._dlAppService, siteId, this._journalArticleService, this._layoutLocalService, this.contextAcceptLanguage.getPreferredLocale(), this._getRootDDMFormFields(ddmStructure)), ddmStructure), ddmStructure.getStructureKey(), this._getDDMTemplateKey(ddmStructure), null, localDateTime.getMonthValue() - 1, localDateTime.getDayOfMonth(), localDateTime.getYear(), localDateTime.getHour(), localDateTime.getMinute(), 0, 0, 0, 0, 0, true, 0, 0, 0, 0, 0, true, true, null, ServiceContextUtil.createServiceContext((Long[])structuredContent.getTaxonomyCategoryIds(), (String[])structuredContent.getKeywords(), this._getExpandoBridgeAttributes(structuredContent), (Long)siteId, (String)structuredContent.getViewableByAsString())));
    }

    private DDMStructure _checkDDMStructurePermission(StructuredContent structuredContent) throws Exception {
        try {
            return this._ddmStructureService.getStructure(structuredContent.getContentStructureId().longValue());
        }
        catch (PrincipalException.MustHavePermission mhp) {
            throw new ForbiddenException("You do not have permission to create a structured content using the content structure ID " + structuredContent.getContentStructureId(), (Throwable)mhp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String _createJournalArticleContent(final DDMFormValues ddmFormValues, DDMStructure ddmStructure) throws Exception {
        this._validateDDMFormValues(ddmFormValues);
        Locale originalSiteDefaultLocale = LocaleThreadLocal.getSiteDefaultLocale();
        try {
            LocaleThreadLocal.setSiteDefaultLocale((Locale)LocaleUtil.fromLanguageId((String)ddmStructure.getDefaultLanguageId()));
            ServiceContext serviceContext = new ServiceContext();
            final DDMForm ddmForm = ddmStructure.getDDMForm();
            serviceContext.setAttribute("ddmFormValues", (Serializable)((Object)this._toString(new DDMFormValues(ddmForm){
                {
                    super(x0);
                    this.setAvailableLocales(ddmForm.getAvailableLocales());
                    this.setDDMFormFieldValues(ddmFormValues.getDDMFormFieldValues());
                    this.setDefaultLocale(ddmForm.getDefaultLocale());
                }
            })));
            String string = this._journalConverter.getContent(ddmStructure, this._ddm.getFields(ddmStructure.getStructureId(), serviceContext));
            return string;
        }
        finally {
            LocaleThreadLocal.setSiteDefaultLocale((Locale)originalSiteDefaultLocale);
        }
    }

    private DDMFormField _getDDMFormField(DDMStructure ddmStructure, String name) {
        try {
            return ddmStructure.getDDMFormField(name);
        }
        catch (Exception sfe) {
            throw new BadRequestException(StringBundler.concat((Object[])new Object[]{"Unable to get content field value for \"", name, "\" for content structure ", ddmStructure.getStructureId()}), (Throwable)sfe);
        }
    }

    private String _getDDMTemplateKey(DDMStructure ddmStructure) {
        List ddmTemplates = ddmStructure.getTemplates();
        if (ddmTemplates.isEmpty()) {
            return "";
        }
        DDMTemplate ddmTemplate = (DDMTemplate)ddmTemplates.get(0);
        return ddmTemplate.getTemplateKey();
    }

    private Map<String, Serializable> _getExpandoBridgeAttributes(StructuredContent structuredContent) {
        return CustomFieldsUtil.toMap(JournalArticle.class.getName(), this.contextCompany.getCompanyId(), structuredContent.getCustomFields(), this.contextAcceptLanguage.getPreferredLocale());
    }

    private List<DDMFormField> _getRootDDMFormFields(DDMStructure ddmStructure) {
        return this.transform(ddmStructure.getRootFieldNames(), fieldName -> this._getDDMFormField(ddmStructure, (String)fieldName));
    }

    private SPIRatingResource<Rating> _getSPIRatingResource() {
        return new SPIRatingResource(JournalArticle.class.getName(), this._ratingsEntryLocalService, ratingsEntry -> RatingUtil.toRating(this._portal, ratingsEntry, this._userLocalService), this._user);
    }

    private StructuredContent _getStructuredContent(JournalArticle journalArticle) throws Exception {
        ContentLanguageUtil.addContentLanguageHeader((String[])journalArticle.getAvailableLanguageIds(), (String)journalArticle.getDefaultLanguageId(), (HttpServletResponse)this._httpServletResponse, (Locale)this.contextAcceptLanguage.getPreferredLocale());
        return this._toStructuredContent(journalArticle);
    }

    private Page<StructuredContent> _getStructuredContentsPage(UnsafeConsumer<BooleanQuery, Exception> booleanQueryUnsafeConsumer, Long siteId, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return SearchUtil.search(booleanQueryUnsafeConsumer, (Filter)filter, JournalArticle.class, (String)search, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"articleId", "scopeGroupId"}), searchContext -> {
            searchContext.setAttribute("status", (Serializable)Integer.valueOf(0));
            searchContext.setAttribute("head", (Serializable)Boolean.TRUE);
            searchContext.setCompanyId(this.contextCompany.getCompanyId());
            if (siteId != null) {
                searchContext.setGroupIds(new long[]{siteId});
            }
        }, document -> this._toStructuredContent(this._journalArticleService.getLatestArticle(GetterUtil.getLong((String)document.get("scopeGroupId")), document.get("articleId"), 0)), (Sort[])sorts);
    }

    private Fields _toFields(ContentField[] contentFields, JournalArticle journalArticle) throws Exception {
        DDMStructure ddmStructure = journalArticle.getDDMStructure();
        Fields fields = this._journalConverter.getDDMFields(ddmStructure, journalArticle.getContent());
        ServiceContext serviceContext = new ServiceContext();
        DDMFormValues ddmFormValues = DDMFormValuesUtil.toDDMFormValues(contentFields, ddmStructure.getDDMForm(), this._dlAppService, journalArticle.getGroupId(), this._journalArticleService, this._layoutLocalService, this.contextAcceptLanguage.getPreferredLocale(), this._getRootDDMFormFields(ddmStructure));
        serviceContext.setAttribute("ddmFormValues", (Serializable)((Object)this._toString(ddmFormValues)));
        Fields newFields = this._ddm.getFields(ddmStructure.getStructureId(), serviceContext);
        for (Field field : fields) {
            Field newField = newFields.get(field.getName());
            field.setValues(this.contextAcceptLanguage.getPreferredLocale(), newField.getValues(this.contextAcceptLanguage.getPreferredLocale()));
        }
        return fields;
    }

    private Fields _toPatchedFields(ContentField[] contentFields, JournalArticle journalArticle) throws Exception {
        DDMStructure ddmStructure = journalArticle.getDDMStructure();
        Fields fields = this._journalConverter.getDDMFields(ddmStructure, journalArticle.getContent());
        if (ArrayUtil.isEmpty((Object[])contentFields)) {
            return fields;
        }
        for (Field field : fields) {
            if (!field.isRepeatable()) continue;
            throw new BadRequestException("Unable to patch a structured content with a repeatable field. Instead, update the structured content.");
        }
        for (Field contentField : contentFields) {
            Field field = fields.get(contentField.getName());
            Value value = DDMValueUtil.toDDMValue((ContentField)contentField, this._getDDMFormField(ddmStructure, contentField.getName()), this._dlAppService, journalArticle.getGroupId(), this._journalArticleService, this._layoutLocalService, this.contextAcceptLanguage.getPreferredLocale());
            field.setValue(this.contextAcceptLanguage.getPreferredLocale(), (Serializable)((Object)value.getString(this.contextAcceptLanguage.getPreferredLocale())));
            ContentField[] nestedContentFields = contentField.getNestedFields();
            if (nestedContentFields == null) continue;
            this._toPatchedFields(nestedContentFields, journalArticle);
        }
        DDMFormValues ddmFormValues = this._journalConverter.getDDMFormValues(ddmStructure, fields);
        this._validateDDMFormValues(ddmFormValues);
        return fields;
    }

    private String _toString(DDMFormValues ddmFormValues) {
        DDMFormValuesSerializer ddmFormValuesSerializer = this._ddmFormValuesSerializerTracker.getDDMFormValuesSerializer("json");
        DDMFormValuesSerializerSerializeRequest.Builder builder = DDMFormValuesSerializerSerializeRequest.Builder.newBuilder((DDMFormValues)ddmFormValues);
        DDMFormValuesSerializerSerializeResponse ddmFormValuesSerializerSerializeResponse = ddmFormValuesSerializer.serialize(builder.build());
        return ddmFormValuesSerializerSerializeResponse.getContent();
    }

    private StructuredContent _toStructuredContent(JournalArticle journalArticle) throws Exception {
        return this._structuredContentDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.getPreferredLocale(), journalArticle.getResourcePrimKey(), this.contextUriInfo));
    }

    private void _validateContentFields(ContentField[] contentFields, DDMStructure ddmStructure) {
        if (ArrayUtil.isEmpty((Object[])contentFields)) {
            return;
        }
        for (ContentField contentField : contentFields) {
            DDMFormField ddmFormField = this._getDDMFormField(ddmStructure, contentField.getName());
            if (ddmFormField == null) {
                throw new BadRequestException(StringBundler.concat((Object[])new Object[]{"Unable to get content field value for \"", contentField.getName(), "\" for content structure ", ddmStructure.getStructureId()}));
            }
            this._validateContentFields(contentField.getNestedFields(), ddmStructure);
        }
    }

    private void _validateDDMFormValues(DDMFormValues ddmFormValues) {
        try {
            this._ddmFormValuesValidator.validate(ddmFormValues);
        }
        catch (DDMFormValuesValidationException ddmfvve) {
            throw new BadRequestException("Validation error: " + ddmfvve.getMessage(), (Throwable)ddmfvve);
        }
    }
}

