/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.resource.v1_0;

import com.liferay.expando.kernel.service.ExpandoColumnLocalService;
import com.liferay.expando.kernel.service.ExpandoTableLocalService;
import com.liferay.headless.common.spi.service.context.ServiceContextUtil;
import com.liferay.headless.delivery.dto.v1_0.StructuredContentFolder;
import com.liferay.headless.delivery.dto.v1_0.converter.DTOConverterContext;
import com.liferay.headless.delivery.dto.v1_0.converter.DefaultDTOConverterContext;
import com.liferay.headless.delivery.internal.dto.v1_0.converter.StructuredContentFolderDTOConverter;
import com.liferay.headless.delivery.internal.dto.v1_0.util.CustomFieldsUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.EntityFieldsUtil;
import com.liferay.headless.delivery.internal.odata.entity.v1_0.StructuredContentFolderEntityModel;
import com.liferay.headless.delivery.internal.resource.v1_0.BaseStructuredContentFolderResourceImpl;
import com.liferay.headless.delivery.resource.v1_0.StructuredContentFolderResource;
import com.liferay.journal.model.JournalFolder;
import com.liferay.journal.service.JournalFolderService;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermFilter;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.resource.EntityModelResource;
import com.liferay.portal.vulcan.util.SearchUtil;
import java.io.Serializable;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/structured-content-folder.properties"}, scope=ServiceScope.PROTOTYPE, service={StructuredContentFolderResource.class})
public class StructuredContentFolderResourceImpl
extends BaseStructuredContentFolderResourceImpl
implements EntityModelResource {
    @Reference
    private ExpandoColumnLocalService _expandoColumnLocalService;
    @Reference
    private ExpandoTableLocalService _expandoTableLocalService;
    @Reference
    private JournalFolderService _journalFolderService;
    @Reference
    private Portal _portal;
    @Reference
    private StructuredContentFolderDTOConverter _structuredContentFolderDTOConverter;

    @Override
    public void deleteStructuredContentFolder(Long structuredContentFolderId) throws Exception {
        this._journalFolderService.deleteFolder(structuredContentFolderId.longValue());
    }

    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) {
        return new StructuredContentFolderEntityModel(EntityFieldsUtil.getEntityFields(this._portal.getClassNameId(JournalFolder.class.getName()), this.contextCompany.getCompanyId(), this._expandoColumnLocalService, this._expandoTableLocalService));
    }

    @Override
    public Page<StructuredContentFolder> getSiteStructuredContentFoldersPage(Long siteId, Boolean flatten, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        Long parentStructuredContentFolderId = null;
        if (!GetterUtil.getBoolean((Object)flatten)) {
            parentStructuredContentFolderId = 0L;
        }
        return this._getFoldersPage(siteId, parentStructuredContentFolderId, search, filter, pagination, sorts);
    }

    @Override
    public StructuredContentFolder getStructuredContentFolder(Long structuredContentFolderId) throws Exception {
        return this._toStructuredContentFolder(this._journalFolderService.getFolder(structuredContentFolderId.longValue()));
    }

    @Override
    public Page<StructuredContentFolder> getStructuredContentFolderStructuredContentFoldersPage(Long parentStructuredContentFolderId, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        JournalFolder journalFolder = this._journalFolderService.getFolder(parentStructuredContentFolderId.longValue());
        return this._getFoldersPage(journalFolder.getGroupId(), parentStructuredContentFolderId, search, filter, pagination, sorts);
    }

    @Override
    public StructuredContentFolder postSiteStructuredContentFolder(Long siteId, StructuredContentFolder structuredContentFolder) throws Exception {
        return this._addStructuredContentFolder(siteId, 0L, structuredContentFolder);
    }

    @Override
    public StructuredContentFolder postStructuredContentFolderStructuredContentFolder(Long parentStructuredContentFolderId, StructuredContentFolder structuredContentFolder) throws Exception {
        JournalFolder journalFolder = this._journalFolderService.getFolder(parentStructuredContentFolderId.longValue());
        return this._addStructuredContentFolder(journalFolder.getGroupId(), parentStructuredContentFolderId, structuredContentFolder);
    }

    @Override
    public StructuredContentFolder putStructuredContentFolder(Long structuredContentFolderId, StructuredContentFolder structuredContentFolder) throws Exception {
        JournalFolder journalFolder = this._journalFolderService.getFolder(structuredContentFolderId.longValue());
        return this._toStructuredContentFolder(this._journalFolderService.updateFolder(journalFolder.getGroupId(), structuredContentFolderId.longValue(), journalFolder.getParentFolderId(), structuredContentFolder.getName(), structuredContentFolder.getDescription(), false, ServiceContextUtil.createServiceContext(this._getExpandoBridgeAttributes(structuredContentFolder), (long)journalFolder.getGroupId(), (String)structuredContentFolder.getViewableByAsString())));
    }

    private StructuredContentFolder _addStructuredContentFolder(Long siteId, Long parentFolderId, StructuredContentFolder structuredContentFolder) throws Exception {
        return this._toStructuredContentFolder(this._journalFolderService.addFolder(siteId.longValue(), parentFolderId.longValue(), structuredContentFolder.getName(), structuredContentFolder.getDescription(), ServiceContextUtil.createServiceContext(this._getExpandoBridgeAttributes(structuredContentFolder), (long)siteId, (String)structuredContentFolder.getViewableByAsString())));
    }

    private Map<String, Serializable> _getExpandoBridgeAttributes(StructuredContentFolder structuredContentFolder) {
        return CustomFieldsUtil.toMap(JournalFolder.class.getName(), this.contextCompany.getCompanyId(), structuredContentFolder.getCustomFields(), this.contextAcceptLanguage.getPreferredLocale());
    }

    private Page<StructuredContentFolder> _getFoldersPage(Long siteId, Long parentStructuredContentFolderId, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return SearchUtil.search(booleanQuery -> {
            if (parentStructuredContentFolderId != null) {
                BooleanFilter booleanFilter = booleanQuery.getPreBooleanFilter();
                booleanFilter.add((Filter)new TermFilter("folderId", String.valueOf(parentStructuredContentFolderId)), BooleanClauseOccur.MUST);
            }
        }, (Filter)filter, JournalFolder.class, (String)search, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), searchContext -> {
            searchContext.setCompanyId(this.contextCompany.getCompanyId());
            searchContext.setGroupIds(new long[]{siteId});
        }, document -> this._toStructuredContentFolder(this._journalFolderService.getFolder(GetterUtil.getLong((String)document.get("entryClassPK")))), (Sort[])sorts);
    }

    private StructuredContentFolder _toStructuredContentFolder(JournalFolder journalFolder) throws Exception {
        return this._structuredContentFolderDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.getPreferredLocale(), journalFolder.getFolderId()));
    }
}

