/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.resource.v1_0;

import com.liferay.asset.kernel.model.AssetTag;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.asset.kernel.service.AssetLinkLocalService;
import com.liferay.asset.kernel.service.AssetTagLocalService;
import com.liferay.expando.kernel.service.ExpandoColumnLocalService;
import com.liferay.expando.kernel.service.ExpandoTableLocalService;
import com.liferay.headless.common.spi.resource.SPIRatingResource;
import com.liferay.headless.common.spi.service.context.ServiceContextUtil;
import com.liferay.headless.delivery.dto.v1_0.MessageBoardThread;
import com.liferay.headless.delivery.dto.v1_0.Rating;
import com.liferay.headless.delivery.internal.dto.v1_0.util.AggregateRatingUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.CreatorUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.CustomFieldsUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.EntityFieldsUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.RatingUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.RelatedContentUtil;
import com.liferay.headless.delivery.internal.odata.entity.v1_0.MessageBoardMessageEntityModel;
import com.liferay.headless.delivery.internal.resource.v1_0.BaseMessageBoardThreadResourceImpl;
import com.liferay.headless.delivery.resource.v1_0.MessageBoardThreadResource;
import com.liferay.message.boards.constants.MBMessageConstants;
import com.liferay.message.boards.model.MBCategory;
import com.liferay.message.boards.model.MBMessage;
import com.liferay.message.boards.model.MBThread;
import com.liferay.message.boards.service.MBCategoryService;
import com.liferay.message.boards.service.MBMessageLocalService;
import com.liferay.message.boards.service.MBMessageService;
import com.liferay.message.boards.service.MBThreadLocalService;
import com.liferay.message.boards.service.MBThreadService;
import com.liferay.message.boards.settings.MBGroupServiceSettings;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermFilter;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.UserService;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.odata.entity.EntityField;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.resource.EntityModelResource;
import com.liferay.portal.vulcan.util.SearchUtil;
import com.liferay.ratings.kernel.service.RatingsEntryLocalService;
import com.liferay.ratings.kernel.service.RatingsStatsLocalService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/message-board-thread.properties"}, scope=ServiceScope.PROTOTYPE, service={MessageBoardThreadResource.class})
public class MessageBoardThreadResourceImpl
extends BaseMessageBoardThreadResourceImpl
implements EntityModelResource {
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;
    @Reference
    private AssetLinkLocalService _assetLinkLocalService;
    @Reference
    private AssetTagLocalService _assetTagLocalService;
    @Reference
    private ExpandoColumnLocalService _expandoColumnLocalService;
    @Reference
    private ExpandoTableLocalService _expandoTableLocalService;
    @Reference
    private MBCategoryService _mbCategoryService;
    @Reference
    private MBMessageLocalService _mbMessageLocalService;
    @Reference
    private MBMessageService _mbMessageService;
    @Reference
    private MBThreadLocalService _mbThreadLocalService;
    @Reference
    private MBThreadService _mbThreadService;
    @Reference
    private Portal _portal;
    @Reference
    private RatingsEntryLocalService _ratingsEntryLocalService;
    @Reference
    private RatingsStatsLocalService _ratingsStatsLocalService;
    @Context
    private User _user;
    @Reference
    private UserLocalService _userLocalService;
    @Reference
    private UserService _userService;

    @Override
    public void deleteMessageBoardThread(Long messageBoardThreadId) throws Exception {
        this._mbThreadService.deleteThread(messageBoardThreadId.longValue());
    }

    @Override
    public void deleteMessageBoardThreadMyRating(Long messageBoardThreadId) throws Exception {
        SPIRatingResource<Rating> spiRatingResource = this._getSPIRatingResource();
        MBThread mbThread = this._mbThreadLocalService.getMBThread(messageBoardThreadId.longValue());
        spiRatingResource.deleteRating(Long.valueOf(mbThread.getRootMessageId()));
    }

    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) {
        return new MessageBoardMessageEntityModel(new ArrayList<EntityField>(EntityFieldsUtil.getEntityFields(this._portal.getClassNameId(MBMessage.class.getName()), this.contextCompany.getCompanyId(), this._expandoColumnLocalService, this._expandoTableLocalService)));
    }

    @Override
    public Page<MessageBoardThread> getMessageBoardSectionMessageBoardThreadsPage(Long messageBoardSectionId, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        MBCategory mbCategory = this._mbCategoryService.getCategory(messageBoardSectionId.longValue());
        return this._getSiteMessageBoardThreadsPage((UnsafeConsumer<BooleanQuery, Exception>)((UnsafeConsumer)booleanQuery -> {
            BooleanFilter booleanFilter = booleanQuery.getPreBooleanFilter();
            booleanFilter.add((Filter)new TermFilter("categoryId", String.valueOf(mbCategory.getCategoryId())), BooleanClauseOccur.MUST);
            booleanFilter.add((Filter)new TermFilter("parentMessageId", "0"), BooleanClauseOccur.MUST);
        }), mbCategory.getGroupId(), search, filter, pagination, sorts);
    }

    @Override
    public MessageBoardThread getMessageBoardThread(Long messageBoardThreadId) throws Exception {
        return this._toMessageBoardThread(this._mbThreadLocalService.getMBThread(messageBoardThreadId.longValue()));
    }

    @Override
    public Rating getMessageBoardThreadMyRating(Long messageBoardThreadId) throws Exception {
        SPIRatingResource<Rating> spiRatingResource = this._getSPIRatingResource();
        MBThread mbThread = this._mbThreadLocalService.getMBThread(messageBoardThreadId.longValue());
        return (Rating)spiRatingResource.getRating(Long.valueOf(mbThread.getRootMessageId()));
    }

    @Override
    public Page<MessageBoardThread> getSiteMessageBoardThreadsPage(Long siteId, Boolean flatten, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return this._getSiteMessageBoardThreadsPage((UnsafeConsumer<BooleanQuery, Exception>)((UnsafeConsumer)booleanQuery -> {
            BooleanFilter booleanFilter = booleanQuery.getPreBooleanFilter();
            if (!GetterUtil.getBoolean((Object)flatten)) {
                booleanFilter.add((Filter)new TermFilter("categoryId", "0"), BooleanClauseOccur.MUST);
            }
            booleanFilter.add((Filter)new TermFilter("parentMessageId", "0"), BooleanClauseOccur.MUST);
        }), siteId, search, filter, pagination, sorts);
    }

    @Override
    public MessageBoardThread postMessageBoardSectionMessageBoardThread(Long messageBoardSectionId, MessageBoardThread messageBoardThread) throws Exception {
        MBCategory mbCategory = this._mbCategoryService.getCategory(messageBoardSectionId.longValue());
        return this._addMessageBoardThread(mbCategory.getGroupId(), messageBoardSectionId, messageBoardThread);
    }

    @Override
    public Rating postMessageBoardThreadMyRating(Long messageBoardThreadId, Rating rating) throws Exception {
        SPIRatingResource<Rating> spiRatingResource = this._getSPIRatingResource();
        MBThread mbThread = this._mbThreadLocalService.getThread(messageBoardThreadId.longValue());
        return (Rating)spiRatingResource.addOrUpdateRating((Number)rating.getRatingValue(), mbThread.getRootMessageId());
    }

    @Override
    public MessageBoardThread postSiteMessageBoardThread(Long siteId, MessageBoardThread messageBoardThread) throws Exception {
        return this._addMessageBoardThread(siteId, 0L, messageBoardThread);
    }

    @Override
    public MessageBoardThread putMessageBoardThread(Long messageBoardThreadId, MessageBoardThread messageBoardThread) throws Exception {
        MBThread mbThread = this._mbThreadLocalService.getMBThread(messageBoardThreadId.longValue());
        MBMessage mbMessage = this._mbMessageService.getMessage(mbThread.getRootMessageId());
        this._updateQuestion(mbMessage, messageBoardThread);
        return this._toMessageBoardThread(this._mbMessageService.updateMessage(mbThread.getRootMessageId(), messageBoardThread.getHeadline(), messageBoardThread.getArticleBody(), null, this._toPriority(mbThread.getGroupId(), messageBoardThread.getThreadType()), false, ServiceContextUtil.createServiceContext(null, (String[])Optional.ofNullable(messageBoardThread.getKeywords()).orElse(new String[0]), this._getExpandoBridgeAttributes(messageBoardThread), (Long)mbThread.getGroupId(), (String)messageBoardThread.getViewableByAsString())));
    }

    @Override
    public Rating putMessageBoardThreadMyRating(Long messageBoardThreadId, Rating rating) throws Exception {
        SPIRatingResource<Rating> spiRatingResource = this._getSPIRatingResource();
        MBThread mbThread = this._mbThreadLocalService.getThread(messageBoardThreadId.longValue());
        return (Rating)spiRatingResource.addOrUpdateRating((Number)rating.getRatingValue(), mbThread.getRootMessageId());
    }

    private MessageBoardThread _addMessageBoardThread(Long siteId, Long messageBoardSectionId, MessageBoardThread messageBoardThread) throws Exception {
        MBMessage mbMessage = this._mbMessageService.addMessage(siteId.longValue(), messageBoardSectionId.longValue(), messageBoardThread.getHeadline(), messageBoardThread.getArticleBody(), MBMessageConstants.DEFAULT_FORMAT, Collections.emptyList(), false, this._toPriority(siteId, messageBoardThread.getThreadType()), false, ServiceContextUtil.createServiceContext(null, (String[])messageBoardThread.getKeywords(), this._getExpandoBridgeAttributes(messageBoardThread), (Long)siteId, (String)messageBoardThread.getViewableByAsString()));
        this._updateQuestion(mbMessage, messageBoardThread);
        return this._toMessageBoardThread(mbMessage);
    }

    private Map<String, Serializable> _getExpandoBridgeAttributes(MessageBoardThread messageBoardThread) {
        return CustomFieldsUtil.toMap(MBMessage.class.getName(), this.contextCompany.getCompanyId(), messageBoardThread.getCustomFields(), this.contextAcceptLanguage.getPreferredLocale());
    }

    private Page<MessageBoardThread> _getSiteMessageBoardThreadsPage(UnsafeConsumer<BooleanQuery, Exception> booleanQueryUnsafeConsumer, Long siteId, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return SearchUtil.search(booleanQueryUnsafeConsumer, (Filter)filter, MBMessage.class, (String)search, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), searchContext -> {
            searchContext.setCompanyId(this.contextCompany.getCompanyId());
            searchContext.setGroupIds(new long[]{siteId});
        }, document -> this._toMessageBoardThread(this._mbMessageService.getMessage(GetterUtil.getLong((String)document.get("entryClassPK")))), (Sort[])sorts);
    }

    private SPIRatingResource<Rating> _getSPIRatingResource() {
        return new SPIRatingResource(MBMessage.class.getName(), this._ratingsEntryLocalService, ratingsEntry -> RatingUtil.toRating(this._portal, ratingsEntry, this._userLocalService), this._user);
    }

    private MessageBoardThread _toMessageBoardThread(MBMessage mbMessage) throws Exception {
        return this._toMessageBoardThread(mbMessage.getThread());
    }

    private MessageBoardThread _toMessageBoardThread(final MBThread mbThread) throws Exception {
        final MBMessage mbMessage = this._mbMessageService.getMessage(mbThread.getRootMessageId());
        return new MessageBoardThread(){
            {
                this.aggregateRating = AggregateRatingUtil.toAggregateRating(MessageBoardThreadResourceImpl.this._ratingsStatsLocalService.fetchStats(MBMessage.class.getName(), mbMessage.getMessageId()));
                this.articleBody = mbMessage.getBody();
                this.creator = CreatorUtil.toCreator(MessageBoardThreadResourceImpl.this._portal, MessageBoardThreadResourceImpl.this._userService.getUserById(mbThread.getUserId()));
                this.customFields = CustomFieldsUtil.toCustomFields(MBMessage.class.getName(), mbMessage.getMessageId(), mbThread.getCompanyId(), MessageBoardThreadResourceImpl.this.contextAcceptLanguage.getPreferredLocale());
                this.dateCreated = mbMessage.getCreateDate();
                this.dateModified = mbMessage.getModifiedDate();
                this.encodingFormat = mbMessage.getFormat();
                this.headline = mbMessage.getSubject();
                this.id = mbThread.getThreadId();
                this.keywords = (String[])ListUtil.toArray((List)MessageBoardThreadResourceImpl.this._assetTagLocalService.getTags(MBMessage.class.getName(), mbMessage.getMessageId()), (Accessor)AssetTag.NAME_ACCESSOR);
                this.numberOfMessageBoardAttachments = mbMessage.getAttachmentsFileEntriesCount();
                this.numberOfMessageBoardMessages = MessageBoardThreadResourceImpl.this._mbMessageLocalService.getChildMessagesCount(mbMessage.getMessageId(), 0);
                this.relatedContents = RelatedContentUtil.toRelatedContents(MessageBoardThreadResourceImpl.this._assetEntryLocalService, MessageBoardThreadResourceImpl.this._assetLinkLocalService, mbMessage.getModelClassName(), mbMessage.getMessageId(), MessageBoardThreadResourceImpl.this.contextAcceptLanguage.getPreferredLocale());
                this.showAsQuestion = mbThread.isQuestion();
                this.siteId = mbThread.getGroupId();
                this.threadType = MessageBoardThreadResourceImpl.this._toThreadType(mbThread.getGroupId(), mbThread.getPriority());
            }
        };
    }

    private double _toPriority(Long siteId, String threadType) throws Exception {
        String[] priorities;
        if (threadType == null) {
            return -1.0;
        }
        MBGroupServiceSettings mbGroupServiceSettings = MBGroupServiceSettings.getInstance((long)siteId);
        for (String priorityString : priorities = mbGroupServiceSettings.getPriorities(this.contextAcceptLanguage.getPreferredLanguageId())) {
            String[] parts = StringUtil.split((String)priorityString, (String)"|");
            if (!StringUtil.equalsIgnoreCase((String)parts[0], (String)threadType)) continue;
            return GetterUtil.getDouble((String)parts[2]);
        }
        throw new BadRequestException(StringBundler.concat((String[])new String[]{"Thread type \"", threadType, "\" is not available in ", Arrays.toString(this.transform(priorities, priority -> {
            String[] parts = StringUtil.split((String)priority, (String)"|");
            return parts[0];
        }, String.class))}));
    }

    private String _toThreadType(Long siteId, double priority) throws Exception {
        String[] priorities;
        MBGroupServiceSettings mbGroupServiceSettings = MBGroupServiceSettings.getInstance((long)siteId);
        for (String priorityString : priorities = mbGroupServiceSettings.getPriorities(this.contextAcceptLanguage.getPreferredLanguageId())) {
            String[] parts = StringUtil.split((String)priorityString, (String)"|");
            if (priority != GetterUtil.getDouble((String)parts[2])) continue;
            return parts[0];
        }
        return null;
    }

    private void _updateQuestion(MBMessage mbMessage, MessageBoardThread messageBoardThread) throws Exception {
        Boolean showAsQuestion = messageBoardThread.getShowAsQuestion();
        if (showAsQuestion != null) {
            this._mbThreadLocalService.updateQuestion(mbMessage.getThreadId(), showAsQuestion.booleanValue());
            MBThread mbThread = mbMessage.getThread();
            mbThread.setQuestion(showAsQuestion.booleanValue());
        }
    }
}

