/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.resource.v1_0;

import com.liferay.expando.kernel.service.ExpandoColumnLocalService;
import com.liferay.expando.kernel.service.ExpandoTableLocalService;
import com.liferay.headless.common.spi.service.context.ServiceContextUtil;
import com.liferay.headless.delivery.dto.v1_0.MessageBoardSection;
import com.liferay.headless.delivery.internal.dto.v1_0.util.CreatorUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.CustomFieldsUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.EntityFieldsUtil;
import com.liferay.headless.delivery.internal.odata.entity.v1_0.MessageBoardSectionEntityModel;
import com.liferay.headless.delivery.internal.resource.v1_0.BaseMessageBoardSectionResourceImpl;
import com.liferay.headless.delivery.resource.v1_0.MessageBoardSectionResource;
import com.liferay.message.boards.model.MBCategory;
import com.liferay.message.boards.service.MBCategoryService;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermFilter;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.odata.entity.EntityField;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.resource.EntityModelResource;
import com.liferay.portal.vulcan.util.SearchUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/message-board-section.properties"}, scope=ServiceScope.PROTOTYPE, service={MessageBoardSectionResource.class})
public class MessageBoardSectionResourceImpl
extends BaseMessageBoardSectionResourceImpl
implements EntityModelResource {
    @Reference
    private ExpandoColumnLocalService _expandoColumnLocalService;
    @Reference
    private ExpandoTableLocalService _expandoTableLocalService;
    @Reference
    private MBCategoryService _mbCategoryService;
    @Reference
    private Portal _portal;
    @Context
    private User _user;
    @Reference
    private UserLocalService _userLocalService;

    @Override
    public void deleteMessageBoardSection(Long messageBoardSectionId) throws Exception {
        this._mbCategoryService.deleteCategory(messageBoardSectionId.longValue(), true);
    }

    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) {
        return new MessageBoardSectionEntityModel(new ArrayList<EntityField>(EntityFieldsUtil.getEntityFields(this._portal.getClassNameId(MBCategory.class.getName()), this.contextCompany.getCompanyId(), this._expandoColumnLocalService, this._expandoTableLocalService)));
    }

    @Override
    public MessageBoardSection getMessageBoardSection(Long messageBoardSectionId) throws Exception {
        return this._toMessageBoardSection(this._mbCategoryService.getCategory(messageBoardSectionId.longValue()));
    }

    @Override
    public Page<MessageBoardSection> getMessageBoardSectionMessageBoardSectionsPage(Long parentMessageBoardSectionId, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        MBCategory mbCategory = this._mbCategoryService.getCategory(parentMessageBoardSectionId.longValue());
        return this._getSiteMessageBoardSectionsPage((UnsafeConsumer<BooleanQuery, Exception>)((UnsafeConsumer)booleanQuery -> {
            BooleanFilter booleanFilter = booleanQuery.getPreBooleanFilter();
            booleanFilter.add((Filter)new TermFilter("parentCategoryId", String.valueOf(mbCategory.getCategoryId())), BooleanClauseOccur.MUST);
        }), mbCategory.getGroupId(), search, filter, pagination, sorts);
    }

    @Override
    public Page<MessageBoardSection> getSiteMessageBoardSectionsPage(Long siteId, Boolean flatten, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return this._getSiteMessageBoardSectionsPage((UnsafeConsumer<BooleanQuery, Exception>)((UnsafeConsumer)booleanQuery -> {
            if (!GetterUtil.getBoolean((Object)flatten)) {
                BooleanFilter booleanFilter = booleanQuery.getPreBooleanFilter();
                booleanFilter.add((Filter)new TermFilter("parentCategoryId", "0"), BooleanClauseOccur.MUST);
            }
        }), siteId, search, filter, pagination, sorts);
    }

    @Override
    public MessageBoardSection postMessageBoardSectionMessageBoardSection(Long parentMessageBoardSectionId, MessageBoardSection messageBoardSection) throws Exception {
        MBCategory mbCategory = this._mbCategoryService.getCategory(parentMessageBoardSectionId.longValue());
        return this._addMessageBoardSection(mbCategory.getGroupId(), parentMessageBoardSectionId, messageBoardSection);
    }

    @Override
    public MessageBoardSection postSiteMessageBoardSection(Long siteId, MessageBoardSection messageBoardSection) throws Exception {
        return this._addMessageBoardSection(siteId, 0L, messageBoardSection);
    }

    @Override
    public MessageBoardSection putMessageBoardSection(Long messageBoardSectionId, MessageBoardSection messageBoardSection) throws Exception {
        MBCategory mbCategory = this._mbCategoryService.getCategory(messageBoardSectionId.longValue());
        return this._toMessageBoardSection(this._mbCategoryService.updateCategory(messageBoardSectionId.longValue(), mbCategory.getParentCategoryId(), messageBoardSection.getTitle(), messageBoardSection.getDescription(), mbCategory.getDisplayStyle(), "", "", "", 0, false, "", "", 0, "", false, "", 0, false, "", "", false, false, false, ServiceContextUtil.createServiceContext(this._getExpandoBridgeAttributes(messageBoardSection), (long)mbCategory.getGroupId(), null)));
    }

    private MessageBoardSection _addMessageBoardSection(long siteId, Long parentMessageBoardSectionId, MessageBoardSection messageBoardSection) throws Exception {
        return this._toMessageBoardSection(this._mbCategoryService.addCategory(this._user.getUserId(), parentMessageBoardSectionId.longValue(), messageBoardSection.getTitle(), messageBoardSection.getDescription(), ServiceContextUtil.createServiceContext(this._getExpandoBridgeAttributes(messageBoardSection), (long)siteId, (String)messageBoardSection.getViewableByAsString())));
    }

    private Map<String, Serializable> _getExpandoBridgeAttributes(MessageBoardSection messageBoardSection) {
        return CustomFieldsUtil.toMap(MBCategory.class.getName(), this.contextCompany.getCompanyId(), messageBoardSection.getCustomFields(), this.contextAcceptLanguage.getPreferredLocale());
    }

    private Page<MessageBoardSection> _getSiteMessageBoardSectionsPage(UnsafeConsumer<BooleanQuery, Exception> booleanQueryUnsafeConsumer, Long siteId, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return SearchUtil.search(booleanQueryUnsafeConsumer, (Filter)filter, MBCategory.class, (String)search, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), searchContext -> {
            searchContext.setCompanyId(this.contextCompany.getCompanyId());
            searchContext.setGroupIds(new long[]{siteId});
        }, document -> this._toMessageBoardSection(this._mbCategoryService.getCategory(GetterUtil.getLong((String)document.get("entryClassPK")))), (Sort[])sorts);
    }

    private MessageBoardSection _toMessageBoardSection(final MBCategory mbCategory) throws Exception {
        return new MessageBoardSection(){
            {
                this.creator = CreatorUtil.toCreator(MessageBoardSectionResourceImpl.this._portal, MessageBoardSectionResourceImpl.this._userLocalService.getUserById(mbCategory.getUserId()));
                this.customFields = CustomFieldsUtil.toCustomFields(MBCategory.class.getName(), mbCategory.getCategoryId(), mbCategory.getCompanyId(), MessageBoardSectionResourceImpl.this.contextAcceptLanguage.getPreferredLocale());
                this.dateCreated = mbCategory.getCreateDate();
                this.dateModified = mbCategory.getModifiedDate();
                this.description = mbCategory.getDescription();
                this.id = mbCategory.getCategoryId();
                this.numberOfMessageBoardSections = MessageBoardSectionResourceImpl.this._mbCategoryService.getCategoriesCount(mbCategory.getGroupId(), mbCategory.getCategoryId());
                this.numberOfMessageBoardThreads = mbCategory.getThreadCount();
                this.siteId = mbCategory.getGroupId();
                this.title = mbCategory.getName();
            }
        };
    }
}

