/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.resource.v1_0;

import com.liferay.document.library.util.DLURLHelper;
import com.liferay.headless.delivery.dto.v1_0.MessageBoardAttachment;
import com.liferay.headless.delivery.internal.resource.v1_0.BaseMessageBoardAttachmentResourceImpl;
import com.liferay.headless.delivery.resource.v1_0.MessageBoardAttachmentResource;
import com.liferay.message.boards.model.MBMessage;
import com.liferay.message.boards.model.MBThread;
import com.liferay.message.boards.service.MBMessageService;
import com.liferay.message.boards.service.MBThreadLocalService;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepository;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.vulcan.multipart.BinaryFile;
import com.liferay.portal.vulcan.multipart.MultipartBody;
import com.liferay.portal.vulcan.pagination.Page;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.core.Context;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/message-board-attachment.properties"}, scope=ServiceScope.PROTOTYPE, service={MessageBoardAttachmentResource.class})
public class MessageBoardAttachmentResourceImpl
extends BaseMessageBoardAttachmentResourceImpl {
    @Reference
    private DLURLHelper _dlURLHelper;
    @Reference
    private MBMessageService _mbMessageService;
    @Reference
    private MBThreadLocalService _mbThreadLocalService;
    @Reference
    private PortletFileRepository _portletFileRepository;
    @Context
    private User _user;

    @Override
    public void deleteMessageBoardAttachment(Long messageBoardAttachmentId) throws Exception {
        this._portletFileRepository.deletePortletFileEntry(messageBoardAttachmentId.longValue());
    }

    @Override
    public MessageBoardAttachment getMessageBoardAttachment(Long messageBoardAttachmentId) throws Exception {
        return this._toMessageBoardAttachment(this._portletFileRepository.getPortletFileEntry(messageBoardAttachmentId.longValue()));
    }

    @Override
    public Page<MessageBoardAttachment> getMessageBoardMessageMessageBoardAttachmentsPage(Long messageBoardMessageId) throws Exception {
        return this._getMessageBoardAttachmentsPage(messageBoardMessageId);
    }

    @Override
    public Page<MessageBoardAttachment> getMessageBoardThreadMessageBoardAttachmentsPage(Long messageBoardThreadId) throws Exception {
        MBThread mbThread = this._mbThreadLocalService.getMBThread(messageBoardThreadId.longValue());
        return this._getMessageBoardAttachmentsPage(mbThread.getRootMessageId());
    }

    @Override
    public MessageBoardAttachment postMessageBoardMessageMessageBoardAttachment(Long messageBoardMessageId, MultipartBody multipartBody) throws Exception {
        return this._addMessageBoardAttachment(messageBoardMessageId, multipartBody);
    }

    @Override
    public MessageBoardAttachment postMessageBoardThreadMessageBoardAttachment(Long messageBoardThreadId, MultipartBody multipartBody) throws Exception {
        MBThread mbThread = this._mbThreadLocalService.getMBThread(messageBoardThreadId.longValue());
        return this._addMessageBoardAttachment(mbThread.getRootMessageId(), multipartBody);
    }

    private MessageBoardAttachment _addMessageBoardAttachment(Long messageBoardMessageId, MultipartBody multipartBody) throws Exception {
        MBMessage mbMessage = this._mbMessageService.getMessage(messageBoardMessageId.longValue());
        BinaryFile binaryFile = multipartBody.getBinaryFile("file");
        if (binaryFile == null) {
            throw new BadRequestException("No file found in body");
        }
        Folder folder = mbMessage.addAttachmentsFolder();
        return this._toMessageBoardAttachment(this._portletFileRepository.addPortletFileEntry(mbMessage.getGroupId(), this._user.getUserId(), MBMessage.class.getName(), mbMessage.getClassPK(), "com.liferay.message.boards", folder.getFolderId(), binaryFile.getInputStream(), binaryFile.getFileName(), binaryFile.getFileName(), false));
    }

    private Page<MessageBoardAttachment> _getMessageBoardAttachmentsPage(Long messageBoardMessageId) throws Exception {
        MBMessage mbMessage = this._mbMessageService.getMessage(messageBoardMessageId.longValue());
        return Page.of(this.transform(mbMessage.getAttachmentsFileEntries(), this::_toMessageBoardAttachment));
    }

    private MessageBoardAttachment _toMessageBoardAttachment(final FileEntry fileEntry) throws Exception {
        return new MessageBoardAttachment(){
            {
                this.contentUrl = MessageBoardAttachmentResourceImpl.this._dlURLHelper.getPreviewURL(fileEntry, fileEntry.getFileVersion(), null, "", false, false);
                this.encodingFormat = fileEntry.getMimeType();
                this.fileExtension = fileEntry.getExtension();
                this.id = fileEntry.getFileEntryId();
                this.sizeInBytes = fileEntry.getSize();
                this.title = fileEntry.getTitle();
            }
        };
    }
}

