/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.resource.v1_0;

import com.liferay.document.library.util.DLURLHelper;
import com.liferay.headless.delivery.dto.v1_0.KnowledgeBaseAttachment;
import com.liferay.headless.delivery.internal.resource.v1_0.BaseKnowledgeBaseAttachmentResourceImpl;
import com.liferay.headless.delivery.resource.v1_0.KnowledgeBaseAttachmentResource;
import com.liferay.knowledge.base.model.KBArticle;
import com.liferay.knowledge.base.service.KBArticleService;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepository;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.vulcan.multipart.BinaryFile;
import com.liferay.portal.vulcan.multipart.MultipartBody;
import com.liferay.portal.vulcan.pagination.Page;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.core.Context;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/knowledge-base-attachment.properties"}, scope=ServiceScope.PROTOTYPE, service={KnowledgeBaseAttachmentResource.class})
public class KnowledgeBaseAttachmentResourceImpl
extends BaseKnowledgeBaseAttachmentResourceImpl {
    @Reference
    private DLURLHelper _dlURLHelper;
    @Reference
    private KBArticleService _kbArticleService;
    @Reference
    private PortletFileRepository _portletFileRepository;
    @Context
    private User _user;

    @Override
    public void deleteKnowledgeBaseAttachment(Long knowledgeBaseAttachmentId) throws Exception {
        this._portletFileRepository.deletePortletFileEntry(knowledgeBaseAttachmentId.longValue());
    }

    @Override
    public Page<KnowledgeBaseAttachment> getKnowledgeBaseArticleKnowledgeBaseAttachmentsPage(Long knowledgeBaseArticleId) throws Exception {
        KBArticle kbArticle = this._kbArticleService.getLatestKBArticle(knowledgeBaseArticleId.longValue(), 0);
        return Page.of(this.transform(kbArticle.getAttachmentsFileEntries(), this::_toKnowledgeBaseAttachment));
    }

    @Override
    public KnowledgeBaseAttachment getKnowledgeBaseAttachment(Long knowledgeBaseAttachmentId) throws Exception {
        return this._toKnowledgeBaseAttachment(this._portletFileRepository.getPortletFileEntry(knowledgeBaseAttachmentId.longValue()));
    }

    @Override
    public KnowledgeBaseAttachment postKnowledgeBaseArticleKnowledgeBaseAttachment(Long knowledgeBaseArticleId, MultipartBody multipartBody) throws Exception {
        KBArticle kbArticle = this._kbArticleService.getLatestKBArticle(knowledgeBaseArticleId.longValue(), 0);
        BinaryFile binaryFile = multipartBody.getBinaryFile("file");
        if (binaryFile == null) {
            throw new BadRequestException("No file found in body");
        }
        return this._toKnowledgeBaseAttachment(this._portletFileRepository.addPortletFileEntry(kbArticle.getGroupId(), this._user.getUserId(), KBArticle.class.getName(), kbArticle.getClassPK(), "com.liferay.knowledge.base", kbArticle.getAttachmentsFolderId(), binaryFile.getInputStream(), binaryFile.getFileName(), binaryFile.getFileName(), false));
    }

    private KnowledgeBaseAttachment _toKnowledgeBaseAttachment(final FileEntry fileEntry) throws Exception {
        return new KnowledgeBaseAttachment(){
            {
                this.contentUrl = KnowledgeBaseAttachmentResourceImpl.this._dlURLHelper.getPreviewURL(fileEntry, fileEntry.getFileVersion(), null, "", false, false);
                this.encodingFormat = fileEntry.getMimeType();
                this.fileExtension = fileEntry.getExtension();
                this.id = fileEntry.getFileEntryId();
                this.sizeInBytes = fileEntry.getSize();
                this.title = fileEntry.getTitle();
            }
        };
    }
}

