/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.resource.v1_0;

import com.liferay.asset.kernel.service.AssetCategoryLocalService;
import com.liferay.asset.kernel.service.AssetTagLocalService;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLVersionNumberIncrease;
import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.expando.kernel.service.ExpandoColumnLocalService;
import com.liferay.expando.kernel.service.ExpandoTableLocalService;
import com.liferay.headless.common.spi.resource.SPIRatingResource;
import com.liferay.headless.common.spi.service.context.ServiceContextUtil;
import com.liferay.headless.delivery.dto.v1_0.CustomField;
import com.liferay.headless.delivery.dto.v1_0.Document;
import com.liferay.headless.delivery.dto.v1_0.Rating;
import com.liferay.headless.delivery.dto.v1_0.converter.DTOConverterContext;
import com.liferay.headless.delivery.dto.v1_0.converter.DefaultDTOConverterContext;
import com.liferay.headless.delivery.internal.dto.v1_0.converter.DocumentDTOConverter;
import com.liferay.headless.delivery.internal.dto.v1_0.util.CustomFieldsUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.EntityFieldsUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.RatingUtil;
import com.liferay.headless.delivery.internal.odata.entity.v1_0.DocumentEntityModel;
import com.liferay.headless.delivery.internal.resource.v1_0.BaseDocumentResourceImpl;
import com.liferay.headless.delivery.resource.v1_0.DocumentResource;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermFilter;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.multipart.BinaryFile;
import com.liferay.portal.vulcan.multipart.MultipartBody;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.resource.EntityModelResource;
import com.liferay.portal.vulcan.util.SearchUtil;
import com.liferay.ratings.kernel.service.RatingsEntryLocalService;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/document.properties"}, scope=ServiceScope.PROTOTYPE, service={DocumentResource.class})
public class DocumentResourceImpl
extends BaseDocumentResourceImpl
implements EntityModelResource {
    @Reference
    private AssetCategoryLocalService _assetCategoryLocalService;
    @Reference
    private AssetTagLocalService _assetTagLocalService;
    @Reference
    private DLAppService _dlAppService;
    @Reference
    private DocumentDTOConverter _documentDTOConverter;
    @Reference
    private ExpandoColumnLocalService _expandoColumnLocalService;
    @Reference
    private ExpandoTableLocalService _expandoTableLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private RatingsEntryLocalService _ratingsEntryLocalService;
    @Context
    private User _user;
    @Reference
    private UserLocalService _userLocalService;

    @Override
    public void deleteDocument(Long documentId) throws Exception {
        this._dlAppService.deleteFileEntry(documentId.longValue());
    }

    @Override
    public void deleteDocumentMyRating(Long documentId) throws Exception {
        SPIRatingResource<Rating> spiRatingResource = this._getSPIRatingResource();
        spiRatingResource.deleteRating(documentId);
    }

    @Override
    public Document getDocument(Long documentId) throws Exception {
        FileEntry fileEntry = this._dlAppService.getFileEntry(documentId.longValue());
        return this._toDocument(fileEntry);
    }

    @Override
    public Page<Document> getDocumentFolderDocumentsPage(Long documentFolderId, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return this._getDocumentsPage((UnsafeConsumer<BooleanQuery, Exception>)((UnsafeConsumer)booleanQuery -> {
            if (documentFolderId != null) {
                BooleanFilter booleanFilter = booleanQuery.getPreBooleanFilter();
                booleanFilter.add((Filter)new TermFilter("folderId", String.valueOf(documentFolderId)), BooleanClauseOccur.MUST);
            }
        }), search, filter, pagination, sorts);
    }

    @Override
    public Rating getDocumentMyRating(Long documentId) throws Exception {
        SPIRatingResource<Rating> spiRatingResource = this._getSPIRatingResource();
        return (Rating)spiRatingResource.getRating(documentId);
    }

    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) {
        return new DocumentEntityModel(EntityFieldsUtil.getEntityFields(this._portal.getClassNameId(DLFileEntry.class.getName()), this.contextCompany.getCompanyId(), this._expandoColumnLocalService, this._expandoTableLocalService));
    }

    @Override
    public Page<Document> getSiteDocumentsPage(Long siteId, Boolean flatten, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return this._getDocumentsPage((UnsafeConsumer<BooleanQuery, Exception>)((UnsafeConsumer)booleanQuery -> {
            BooleanFilter booleanFilter = booleanQuery.getPreBooleanFilter();
            if (!GetterUtil.getBoolean((Object)flatten)) {
                booleanFilter.add((Filter)new TermFilter("folderId", String.valueOf(0L)), BooleanClauseOccur.MUST);
            }
            if (siteId != null) {
                booleanFilter.add((Filter)new TermFilter("groupId", String.valueOf(siteId)), BooleanClauseOccur.MUST);
            }
        }), search, filter, pagination, sorts);
    }

    @Override
    public Document patchDocument(Long documentId, MultipartBody multipartBody) throws Exception {
        FileEntry existingFileEntry = this._dlAppService.getFileEntry(documentId.longValue());
        BinaryFile binaryFile = Optional.ofNullable(multipartBody.getBinaryFile("file")).orElse(new BinaryFile(existingFileEntry.getMimeType(), existingFileEntry.getFileName(), existingFileEntry.getContentStream(), existingFileEntry.getSize()));
        Optional documentOptional = multipartBody.getValueAsInstanceOptional("document", Document.class);
        Long[] categoryIds = documentOptional.map(Document::getTaxonomyCategoryIds).orElseGet(() -> ArrayUtil.toArray((long[])this._assetCategoryLocalService.getCategoryIds(DLFileEntry.class.getName(), documentId.longValue())));
        String[] keywords = documentOptional.map(Document::getKeywords).orElseGet(() -> this._assetTagLocalService.getTagNames(DLFileEntry.class.getName(), documentId.longValue()));
        return this._toDocument(this._dlAppService.updateFileEntry(documentId.longValue(), binaryFile.getFileName(), binaryFile.getContentType(), documentOptional.map(Document::getTitle).orElse(existingFileEntry.getTitle()), documentOptional.map(Document::getDescription).orElse(existingFileEntry.getDescription()), null, DLVersionNumberIncrease.AUTOMATIC, binaryFile.getInputStream(), binaryFile.getSize(), ServiceContextUtil.createServiceContext((Long[])categoryIds, (String[])keywords, this._getExpandoBridgeAttributes1(documentOptional), (Long)existingFileEntry.getGroupId(), (String)documentOptional.map(Document::getViewableBy).map(Document.ViewableBy::getValue).orElse(null))));
    }

    @Override
    public Document postDocumentFolderDocument(Long documentFolderId, MultipartBody multipartBody) throws Exception {
        Folder folder = this._dlAppService.getFolder(documentFolderId.longValue());
        return this._addDocument(folder.getRepositoryId(), documentFolderId, folder.getGroupId(), multipartBody);
    }

    @Override
    public Rating postDocumentMyRating(Long documentId, Rating rating) throws Exception {
        SPIRatingResource<Rating> spiRatingResource = this._getSPIRatingResource();
        return (Rating)spiRatingResource.addOrUpdateRating((Number)rating.getRatingValue(), documentId.longValue());
    }

    @Override
    public Document postSiteDocument(Long siteId, MultipartBody multipartBody) throws Exception {
        return this._addDocument(siteId, 0L, siteId, multipartBody);
    }

    @Override
    public Document putDocument(Long documentId, MultipartBody multipartBody) throws Exception {
        Optional documentOptional = multipartBody.getValueAsInstanceOptional("document", Document.class);
        if (multipartBody.getBinaryFile("file") == null && !documentOptional.isPresent()) {
            throw new BadRequestException("No document or file found in body");
        }
        FileEntry existingFileEntry = this._dlAppService.getFileEntry(documentId.longValue());
        BinaryFile binaryFile = Optional.ofNullable(multipartBody.getBinaryFile("file")).orElse(new BinaryFile(existingFileEntry.getMimeType(), existingFileEntry.getFileName(), existingFileEntry.getContentStream(), existingFileEntry.getSize()));
        return this._toDocument(this._dlAppService.updateFileEntry(documentId.longValue(), binaryFile.getFileName(), binaryFile.getContentType(), documentOptional.map(Document::getTitle).orElse(existingFileEntry.getTitle()), (String)documentOptional.map(Document::getDescription).orElse(null), null, DLVersionNumberIncrease.AUTOMATIC, binaryFile.getInputStream(), binaryFile.getSize(), ServiceContextUtil.createServiceContext((Long[])documentOptional.map(Document::getTaxonomyCategoryIds).orElse(new Long[0]), (String[])documentOptional.map(Document::getKeywords).orElse(new String[0]), this._getExpandoBridgeAttributes1(documentOptional), (Long)existingFileEntry.getGroupId(), (String)documentOptional.map(Document::getViewableByAsString).orElse(Document.ViewableBy.OWNER.getValue()))));
    }

    @Override
    public Rating putDocumentMyRating(Long documentId, Rating rating) throws Exception {
        SPIRatingResource<Rating> spiRatingResource = this._getSPIRatingResource();
        return (Rating)spiRatingResource.addOrUpdateRating((Number)rating.getRatingValue(), documentId.longValue());
    }

    private Document _addDocument(Long repositoryId, long documentFolderId, Long groupId, MultipartBody multipartBody) throws Exception {
        BinaryFile binaryFile = multipartBody.getBinaryFile("file");
        if (binaryFile == null) {
            throw new BadRequestException("No file found in body");
        }
        Optional documentOptional = multipartBody.getValueAsInstanceOptional("document", Document.class);
        return this._toDocument(this._dlAppService.addFileEntry(repositoryId.longValue(), documentFolderId, binaryFile.getFileName(), binaryFile.getContentType(), documentOptional.map(Document::getTitle).orElse(binaryFile.getFileName()), (String)documentOptional.map(Document::getDescription).orElse(null), null, binaryFile.getInputStream(), binaryFile.getSize(), ServiceContextUtil.createServiceContext((Long[])documentOptional.map(Document::getTaxonomyCategoryIds).orElse(null), (String[])documentOptional.map(Document::getKeywords).orElse(null), this._getExpandoBridgeAttributes1(documentOptional), (Long)groupId, (String)documentOptional.map(Document::getViewableByAsString).orElse(Document.ViewableBy.OWNER.getValue()))));
    }

    private Page<Document> _getDocumentsPage(UnsafeConsumer<BooleanQuery, Exception> booleanQueryUnsafeConsumer, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return SearchUtil.search(booleanQueryUnsafeConsumer, (Filter)filter, DLFileEntry.class, (String)search, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), searchContext -> searchContext.setCompanyId(this.contextCompany.getCompanyId()), document -> this._toDocument(this._dlAppService.getFileEntry(GetterUtil.getLong((String)document.get("entryClassPK")))), (Sort[])sorts);
    }

    private CustomField[] _getExpandoBridgeAttributes(Optional<Document> documentOptional) {
        return documentOptional.map(Document::getCustomFields).orElse(null);
    }

    private Map<String, Serializable> _getExpandoBridgeAttributes1(Optional<Document> documentOptional) {
        return CustomFieldsUtil.toMap(DLFileEntry.class.getName(), this.contextCompany.getCompanyId(), this._getExpandoBridgeAttributes(documentOptional), this.contextAcceptLanguage.getPreferredLocale());
    }

    private SPIRatingResource<Rating> _getSPIRatingResource() {
        return new SPIRatingResource(DLFileEntry.class.getName(), this._ratingsEntryLocalService, ratingsEntry -> RatingUtil.toRating(this._portal, ratingsEntry, this._userLocalService), this._user);
    }

    private Document _toDocument(FileEntry fileEntry) throws Exception {
        return this._documentDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(null, fileEntry.getFileEntryId()));
    }
}

