/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.resource.v1_0;

import com.liferay.blogs.model.BlogsEntry;
import com.liferay.blogs.service.BlogsEntryService;
import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.expando.kernel.service.ExpandoColumnLocalService;
import com.liferay.expando.kernel.service.ExpandoTableLocalService;
import com.liferay.headless.common.spi.resource.SPIRatingResource;
import com.liferay.headless.common.spi.service.context.ServiceContextUtil;
import com.liferay.headless.delivery.dto.v1_0.BlogPosting;
import com.liferay.headless.delivery.dto.v1_0.Image;
import com.liferay.headless.delivery.dto.v1_0.Rating;
import com.liferay.headless.delivery.dto.v1_0.TaxonomyCategory;
import com.liferay.headless.delivery.dto.v1_0.converter.DTOConverterContext;
import com.liferay.headless.delivery.dto.v1_0.converter.DefaultDTOConverterContext;
import com.liferay.headless.delivery.internal.dto.v1_0.converter.BlogPostingDTOConverter;
import com.liferay.headless.delivery.internal.dto.v1_0.util.CustomFieldsUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.EntityFieldsUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.RatingUtil;
import com.liferay.headless.delivery.internal.odata.entity.v1_0.BlogPostingEntityModel;
import com.liferay.headless.delivery.internal.resource.v1_0.BaseBlogPostingResourceImpl;
import com.liferay.headless.delivery.resource.v1_0.BlogPostingResource;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.servlet.taglib.ui.ImageSelector;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.resource.EntityModelResource;
import com.liferay.portal.vulcan.util.LocalDateTimeUtil;
import com.liferay.portal.vulcan.util.SearchUtil;
import com.liferay.ratings.kernel.service.RatingsEntryLocalService;
import java.io.InputStream;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/blog-posting.properties"}, scope=ServiceScope.PROTOTYPE, service={BlogPostingResource.class})
public class BlogPostingResourceImpl
extends BaseBlogPostingResourceImpl
implements EntityModelResource {
    @Reference
    private BlogPostingDTOConverter _blogPostingDTOConverter;
    @Reference
    private BlogsEntryService _blogsEntryService;
    @Reference
    private DLAppService _dlAppService;
    @Reference
    private ExpandoColumnLocalService _expandoColumnLocalService;
    @Reference
    private ExpandoTableLocalService _expandoTableLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private RatingsEntryLocalService _ratingsEntryLocalService;
    @Context
    private User _user;
    @Reference
    private UserLocalService _userLocalService;

    @Override
    public void deleteBlogPosting(Long blogPostingId) throws Exception {
        this._blogsEntryService.deleteEntry(blogPostingId.longValue());
    }

    @Override
    public void deleteBlogPostingMyRating(Long blogPostingId) throws Exception {
        SPIRatingResource<Rating> spiRatingResource = this._getSPIRatingResource();
        spiRatingResource.deleteRating(blogPostingId);
    }

    @Override
    public BlogPosting getBlogPosting(Long blogPostingId) throws Exception {
        BlogsEntry blogsEntry = this._blogsEntryService.getEntry(blogPostingId.longValue());
        return this._toBlogPosting(blogsEntry);
    }

    @Override
    public Rating getBlogPostingMyRating(Long blogPostingId) throws Exception {
        SPIRatingResource<Rating> spiRatingResource = this._getSPIRatingResource();
        return (Rating)spiRatingResource.getRating(blogPostingId);
    }

    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) {
        return new BlogPostingEntityModel(EntityFieldsUtil.getEntityFields(this._portal.getClassNameId(BlogsEntry.class.getName()), this.contextCompany.getCompanyId(), this._expandoColumnLocalService, this._expandoTableLocalService));
    }

    @Override
    public Page<BlogPosting> getSiteBlogPostingsPage(Long siteId, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return SearchUtil.search(booleanQuery -> {}, (Filter)filter, BlogsEntry.class, (String)search, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), searchContext -> {
            searchContext.setAttribute("status", (Serializable)Integer.valueOf(0));
            searchContext.setCompanyId(this.contextCompany.getCompanyId());
            searchContext.setGroupIds(new long[]{siteId});
        }, document -> this._toBlogPosting(this._blogsEntryService.getEntry(GetterUtil.getLong((String)document.get("entryClassPK")))), (Sort[])sorts);
    }

    @Override
    public Rating postBlogPostingMyRating(Long blogPostingId, Rating rating) throws Exception {
        SPIRatingResource<Rating> spiRatingResource = this._getSPIRatingResource();
        return (Rating)spiRatingResource.addOrUpdateRating((Number)rating.getRatingValue(), blogPostingId.longValue());
    }

    @Override
    public BlogPosting postSiteBlogPosting(Long siteId, BlogPosting blogPosting) throws Exception {
        LocalDateTime localDateTime = LocalDateTimeUtil.toLocalDateTime((Date)blogPosting.getDatePublished());
        Optional<Image> imageOptional = Optional.ofNullable(blogPosting.getImage());
        return this._toBlogPosting(this._blogsEntryService.addEntry(blogPosting.getHeadline(), blogPosting.getAlternativeHeadline(), blogPosting.getFriendlyUrlPath(), blogPosting.getDescription(), blogPosting.getArticleBody(), localDateTime.getMonthValue() - 1, localDateTime.getDayOfMonth(), localDateTime.getYear(), localDateTime.getHour(), localDateTime.getMinute(), true, true, new String[0], (String)imageOptional.map(Image::getCaption).orElse(null), this._getImageSelector(imageOptional.map(Image::getImageId).orElse(null)), null, ServiceContextUtil.createServiceContext((Long[])blogPosting.getTaxonomyCategoryIds(), (String[])blogPosting.getKeywords(), this._getExpandoBridgeAttributes(blogPosting), (Long)siteId, (String)blogPosting.getViewableByAsString())));
    }

    @Override
    public BlogPosting putBlogPosting(Long blogPostingId, BlogPosting blogPosting) throws Exception {
        LocalDateTime localDateTime = LocalDateTimeUtil.toLocalDateTime((Date)blogPosting.getDatePublished());
        Optional<Image> imageOptional = Optional.ofNullable(blogPosting.getImage());
        BlogsEntry blogsEntry = this._blogsEntryService.getEntry(blogPostingId.longValue());
        return this._toBlogPosting(this._blogsEntryService.updateEntry(blogPostingId.longValue(), blogPosting.getHeadline(), blogPosting.getAlternativeHeadline(), blogPosting.getFriendlyUrlPath(), blogPosting.getDescription(), blogPosting.getArticleBody(), localDateTime.getMonthValue() - 1, localDateTime.getDayOfMonth(), localDateTime.getYear(), localDateTime.getHour(), localDateTime.getMinute(), true, true, new String[0], (String)imageOptional.map(Image::getCaption).orElse(null), this._getImageSelector(imageOptional.map(Image::getImageId).orElse(null)), null, ServiceContextUtil.createServiceContext((Long[])blogPosting.getTaxonomyCategoryIds(), (String[])blogPosting.getKeywords(), this._getExpandoBridgeAttributes(blogPosting), (Long)blogsEntry.getGroupId(), (String)blogPosting.getViewableByAsString())));
    }

    @Override
    public Rating putBlogPostingMyRating(Long blogPostingId, Rating rating) throws Exception {
        SPIRatingResource<Rating> spiRatingResource = this._getSPIRatingResource();
        return (Rating)spiRatingResource.addOrUpdateRating((Number)rating.getRatingValue(), blogPostingId.longValue());
    }

    @Override
    protected void preparePatch(BlogPosting blogPosting, BlogPosting existingBlogPosting) {
        TaxonomyCategory[] taxonomyCategories;
        final Image image = blogPosting.getImage();
        if (image != null) {
            existingBlogPosting.setImage(new Image(){
                {
                    this.caption = image.getCaption();
                    this.imageId = image.getImageId();
                }
            });
        }
        if ((taxonomyCategories = blogPosting.getTaxonomyCategories()) != null) {
            blogPosting.setTaxonomyCategoryIds((Long[])this.transform(taxonomyCategories, TaxonomyCategory::getTaxonomyCategoryId, Long[].class));
        }
    }

    private Map<String, Serializable> _getExpandoBridgeAttributes(BlogPosting blogPosting) {
        return CustomFieldsUtil.toMap(BlogsEntry.class.getName(), this.contextCompany.getCompanyId(), blogPosting.getCustomFields(), this.contextAcceptLanguage.getPreferredLocale());
    }

    private ImageSelector _getImageSelector(Long imageId) {
        if (imageId == null || imageId == 0L) {
            return new ImageSelector();
        }
        try {
            FileEntry fileEntry = this._dlAppService.getFileEntry(imageId.longValue());
            return new ImageSelector(FileUtil.getBytes((InputStream)fileEntry.getContentStream()), fileEntry.getFileName(), fileEntry.getMimeType(), "{\"height\": 0, \"width\": 0, \"x\": 0, \"y\": 0}");
        }
        catch (Exception e) {
            throw new BadRequestException("Unable to get file entry " + imageId, (Throwable)e);
        }
    }

    private SPIRatingResource<Rating> _getSPIRatingResource() {
        return new SPIRatingResource(BlogsEntry.class.getName(), this._ratingsEntryLocalService, ratingsEntry -> RatingUtil.toRating(this._portal, ratingsEntry, this._userLocalService), this._user);
    }

    private BlogPosting _toBlogPosting(BlogsEntry blogsEntry) throws Exception {
        return this._blogPostingDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.getPreferredLocale(), blogsEntry.getEntryId()));
    }
}

