/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.resource.v1_0;

import com.liferay.blogs.service.BlogsEntryService;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.document.library.util.DLURLHelper;
import com.liferay.headless.common.spi.service.context.ServiceContextUtil;
import com.liferay.headless.delivery.dto.v1_0.BlogPostingImage;
import com.liferay.headless.delivery.internal.odata.entity.v1_0.BlogPostingImageEntityModel;
import com.liferay.headless.delivery.internal.resource.v1_0.BaseBlogPostingImageResourceImpl;
import com.liferay.headless.delivery.resource.v1_0.BlogPostingImageResource;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.multipart.BinaryFile;
import com.liferay.portal.vulcan.multipart.MultipartBody;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.resource.EntityModelResource;
import com.liferay.portal.vulcan.util.SearchUtil;
import java.util.Optional;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.core.MultivaluedMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/blog-posting-image.properties"}, scope=ServiceScope.PROTOTYPE, service={BlogPostingImageResource.class})
public class BlogPostingImageResourceImpl
extends BaseBlogPostingImageResourceImpl
implements EntityModelResource {
    private static final EntityModel _entityModel = new BlogPostingImageEntityModel();
    @Reference
    private BlogsEntryService _blogsEntryService;
    @Reference
    private DLAppService _dlAppService;
    @Reference
    private DLURLHelper _dlURLHelper;

    @Override
    public void deleteBlogPostingImage(Long blogPostingImageId) throws Exception {
        FileEntry fileEntry = this._getFileEntry(blogPostingImageId);
        this._dlAppService.deleteFileEntry(fileEntry.getFileEntryId());
    }

    @Override
    public BlogPostingImage getBlogPostingImage(Long blogPostingImageId) throws Exception {
        FileEntry fileEntry = this._getFileEntry(blogPostingImageId);
        return this._toBlogPostingImage(fileEntry);
    }

    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) {
        return _entityModel;
    }

    @Override
    public Page<BlogPostingImage> getSiteBlogPostingImagesPage(Long siteId, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        Folder folder = this._blogsEntryService.addAttachmentsFolder(siteId.longValue());
        return SearchUtil.search(booleanQuery -> {}, (Filter)filter, DLFileEntry.class, (String)search, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), searchContext -> {
            searchContext.setCompanyId(this.contextCompany.getCompanyId());
            searchContext.setFolderIds(new long[]{folder.getFolderId()});
        }, document -> this._toBlogPostingImage(this._dlAppService.getFileEntry(GetterUtil.getLong((String)document.get("entryClassPK")))), (Sort[])sorts);
    }

    @Override
    public BlogPostingImage postSiteBlogPostingImage(Long siteId, MultipartBody multipartBody) throws Exception {
        Folder folder = this._blogsEntryService.addAttachmentsFolder(siteId.longValue());
        BinaryFile binaryFile = multipartBody.getBinaryFile("file");
        if (binaryFile == null) {
            throw new BadRequestException("No file found in body");
        }
        Optional blogPostingImageOptional = multipartBody.getValueAsInstanceOptional("blogPostingImage", BlogPostingImage.class);
        FileEntry fileEntry = this._dlAppService.addFileEntry(siteId.longValue(), folder.getFolderId(), binaryFile.getFileName(), binaryFile.getContentType(), blogPostingImageOptional.map(BlogPostingImage::getTitle).orElse(binaryFile.getFileName()), null, null, binaryFile.getInputStream(), binaryFile.getSize(), ServiceContextUtil.createServiceContext((long)siteId, (String)blogPostingImageOptional.map(BlogPostingImage::getViewableByAsString).orElse(BlogPostingImage.ViewableBy.ANYONE.getValue())));
        return this._toBlogPostingImage(fileEntry);
    }

    private FileEntry _getFileEntry(Long fileEntryId) throws Exception {
        FileEntry fileEntry = this._dlAppService.getFileEntry(fileEntryId.longValue());
        Folder folder = this._blogsEntryService.addAttachmentsFolder(fileEntry.getGroupId());
        if (fileEntry.getFolderId() != folder.getFolderId()) {
            throw new BadRequestException(fileEntryId + " does not correspond to a valid BlogPostingImage");
        }
        return fileEntry;
    }

    private BlogPostingImage _toBlogPostingImage(final FileEntry fileEntry) throws Exception {
        return new BlogPostingImage(){
            {
                this.contentUrl = BlogPostingImageResourceImpl.this._dlURLHelper.getPreviewURL(fileEntry, fileEntry.getFileVersion(), null, "");
                this.encodingFormat = fileEntry.getMimeType();
                this.fileExtension = fileEntry.getExtension();
                this.id = fileEntry.getFileEntryId();
                this.sizeInBytes = fileEntry.getSize();
                this.title = fileEntry.getTitle();
            }
        };
    }
}

