/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.resource.v1_0;

import com.liferay.headless.delivery.dto.v1_0.StructuredContentFolder;
import com.liferay.headless.delivery.resource.v1_0.StructuredContentFolderResource;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.TransformUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;

@Path(value="/v1.0")
public abstract class BaseStructuredContentFolderResourceImpl
implements StructuredContentFolderResource {
    @Context
    protected AcceptLanguage contextAcceptLanguage;
    @Context
    protected Company contextCompany;
    @Context
    protected UriInfo contextUriInfo;

    @GET
    @Operation(description="Retrieves the Site's structured content folders. Results can be paginated, filtered, searched, flattened, and sorted.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId"), @Parameter(in=ParameterIn.QUERY, name="flatten"), @Parameter(in=ParameterIn.QUERY, name="search"), @Parameter(in=ParameterIn.QUERY, name="filter"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Path(value="/sites/{siteId}/structured-content-folders")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="StructuredContentFolder")})
    public Page<StructuredContentFolder> getSiteStructuredContentFoldersPage(@NotNull @Parameter(hidden=true) @PathParam(value="siteId") Long siteId, @Parameter(hidden=true) @QueryParam(value="flatten") Boolean flatten, @Parameter(hidden=true) @QueryParam(value="search") String search, @Context Filter filter, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Consumes(value={"application/json", "application/xml"})
    @Operation(description="Creates a new structured content folder.")
    @POST
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId")})
    @Path(value="/sites/{siteId}/structured-content-folders")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="StructuredContentFolder")})
    public StructuredContentFolder postSiteStructuredContentFolder(@NotNull @Parameter(hidden=true) @PathParam(value="siteId") Long siteId, StructuredContentFolder structuredContentFolder) throws Exception {
        return new StructuredContentFolder();
    }

    @GET
    @Operation(description="Retrieves the parent structured content folder's subfolders. Results can be paginated, filtered, searched, and sorted.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="parentStructuredContentFolderId"), @Parameter(in=ParameterIn.QUERY, name="search"), @Parameter(in=ParameterIn.QUERY, name="filter"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Path(value="/structured-content-folders/{parentStructuredContentFolderId}/structured-content-folders")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="StructuredContentFolder")})
    public Page<StructuredContentFolder> getStructuredContentFolderStructuredContentFoldersPage(@NotNull @Parameter(hidden=true) @PathParam(value="parentStructuredContentFolderId") Long parentStructuredContentFolderId, @Parameter(hidden=true) @QueryParam(value="search") String search, @Context Filter filter, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Consumes(value={"application/json", "application/xml"})
    @Operation(description="Creates a new structured content folder in an existing folder.")
    @POST
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="parentStructuredContentFolderId")})
    @Path(value="/structured-content-folders/{parentStructuredContentFolderId}/structured-content-folders")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="StructuredContentFolder")})
    public StructuredContentFolder postStructuredContentFolderStructuredContentFolder(@NotNull @Parameter(hidden=true) @PathParam(value="parentStructuredContentFolderId") Long parentStructuredContentFolderId, StructuredContentFolder structuredContentFolder) throws Exception {
        return new StructuredContentFolder();
    }

    @DELETE
    @Operation(description="Deletes the structured content folder and returns a 204 if the operation succeeds.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="structuredContentFolderId")})
    @Path(value="/structured-content-folders/{structuredContentFolderId}")
    @Produces(value={"application/json"})
    @Tags(value={@Tag(name="StructuredContentFolder")})
    public void deleteStructuredContentFolder(@NotNull @Parameter(hidden=true) @PathParam(value="structuredContentFolderId") Long structuredContentFolderId) throws Exception {
    }

    @GET
    @Operation(description="Retrieves the structured content folder.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="structuredContentFolderId")})
    @Path(value="/structured-content-folders/{structuredContentFolderId}")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="StructuredContentFolder")})
    public StructuredContentFolder getStructuredContentFolder(@NotNull @Parameter(hidden=true) @PathParam(value="structuredContentFolderId") Long structuredContentFolderId) throws Exception {
        return new StructuredContentFolder();
    }

    @Consumes(value={"application/json", "application/xml"})
    @Operation(description="Updates only the fields received in the request body, leaving any other fields untouched.")
    @PATCH
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="structuredContentFolderId")})
    @Path(value="/structured-content-folders/{structuredContentFolderId}")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="StructuredContentFolder")})
    public StructuredContentFolder patchStructuredContentFolder(@NotNull @Parameter(hidden=true) @PathParam(value="structuredContentFolderId") Long structuredContentFolderId, StructuredContentFolder structuredContentFolder) throws Exception {
        StructuredContentFolder existingStructuredContentFolder = this.getStructuredContentFolder(structuredContentFolderId);
        if (structuredContentFolder.getDateCreated() != null) {
            existingStructuredContentFolder.setDateCreated(structuredContentFolder.getDateCreated());
        }
        if (structuredContentFolder.getDateModified() != null) {
            existingStructuredContentFolder.setDateModified(structuredContentFolder.getDateModified());
        }
        if (structuredContentFolder.getDescription() != null) {
            existingStructuredContentFolder.setDescription(structuredContentFolder.getDescription());
        }
        if (structuredContentFolder.getName() != null) {
            existingStructuredContentFolder.setName(structuredContentFolder.getName());
        }
        if (structuredContentFolder.getNumberOfStructuredContentFolders() != null) {
            existingStructuredContentFolder.setNumberOfStructuredContentFolders(structuredContentFolder.getNumberOfStructuredContentFolders());
        }
        if (structuredContentFolder.getNumberOfStructuredContents() != null) {
            existingStructuredContentFolder.setNumberOfStructuredContents(structuredContentFolder.getNumberOfStructuredContents());
        }
        if (structuredContentFolder.getSiteId() != null) {
            existingStructuredContentFolder.setSiteId(structuredContentFolder.getSiteId());
        }
        if (structuredContentFolder.getViewableBy() != null) {
            existingStructuredContentFolder.setViewableBy(structuredContentFolder.getViewableBy());
        }
        this.preparePatch(structuredContentFolder, existingStructuredContentFolder);
        return this.putStructuredContentFolder(structuredContentFolderId, existingStructuredContentFolder);
    }

    @Consumes(value={"application/json", "application/xml"})
    @Operation(description="Replaces the structured content folder with the information sent in the request body. Any missing fields are deleted, unless they are required.")
    @PUT
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="structuredContentFolderId")})
    @Path(value="/structured-content-folders/{structuredContentFolderId}")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="StructuredContentFolder")})
    public StructuredContentFolder putStructuredContentFolder(@NotNull @Parameter(hidden=true) @PathParam(value="structuredContentFolderId") Long structuredContentFolderId, StructuredContentFolder structuredContentFolder) throws Exception {
        return new StructuredContentFolder();
    }

    public void setContextCompany(Company contextCompany) {
        this.contextCompany = contextCompany;
    }

    protected void preparePatch(StructuredContentFolder structuredContentFolder, StructuredContentFolder existingStructuredContentFolder) {
    }

    protected <T, R> List<R> transform(Collection<T> collection, UnsafeFunction<T, R, Exception> unsafeFunction) {
        return TransformUtil.transform(collection, unsafeFunction);
    }

    protected <T, R> R[] transform(T[] array, UnsafeFunction<T, R, Exception> unsafeFunction, Class<?> clazz) {
        return TransformUtil.transform((Object[])array, unsafeFunction, clazz);
    }

    protected <T, R> R[] transformToArray(Collection<T> collection, UnsafeFunction<T, R, Exception> unsafeFunction, Class<?> clazz) {
        return TransformUtil.transformToArray(collection, unsafeFunction, clazz);
    }

    protected <T, R> List<R> transformToList(T[] array, UnsafeFunction<T, R, Exception> unsafeFunction) {
        return TransformUtil.transformToList((Object[])array, unsafeFunction);
    }
}

