/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.resource.v1_0;

import com.liferay.headless.delivery.dto.v1_0.MessageBoardMessage;
import com.liferay.headless.delivery.dto.v1_0.Rating;
import com.liferay.headless.delivery.resource.v1_0.MessageBoardMessageResource;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.TransformUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;

@Path(value="/v1.0")
public abstract class BaseMessageBoardMessageResourceImpl
implements MessageBoardMessageResource {
    @Context
    protected AcceptLanguage contextAcceptLanguage;
    @Context
    protected Company contextCompany;
    @Context
    protected UriInfo contextUriInfo;

    @DELETE
    @Operation(description="Deletes the message board message and returns a 204 if the operation succeeds.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="messageBoardMessageId")})
    @Path(value="/message-board-messages/{messageBoardMessageId}")
    @Produces(value={"application/json"})
    @Tags(value={@Tag(name="MessageBoardMessage")})
    public void deleteMessageBoardMessage(@NotNull @Parameter(hidden=true) @PathParam(value="messageBoardMessageId") Long messageBoardMessageId) throws Exception {
    }

    @GET
    @Operation(description="Retrieves the message board message.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="messageBoardMessageId")})
    @Path(value="/message-board-messages/{messageBoardMessageId}")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="MessageBoardMessage")})
    public MessageBoardMessage getMessageBoardMessage(@NotNull @Parameter(hidden=true) @PathParam(value="messageBoardMessageId") Long messageBoardMessageId) throws Exception {
        return new MessageBoardMessage();
    }

    @Consumes(value={"application/json", "application/xml"})
    @Operation(description="Updates only the fields received in the request body, leaving any other fields untouched.")
    @PATCH
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="messageBoardMessageId")})
    @Path(value="/message-board-messages/{messageBoardMessageId}")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="MessageBoardMessage")})
    public MessageBoardMessage patchMessageBoardMessage(@NotNull @Parameter(hidden=true) @PathParam(value="messageBoardMessageId") Long messageBoardMessageId, MessageBoardMessage messageBoardMessage) throws Exception {
        MessageBoardMessage existingMessageBoardMessage = this.getMessageBoardMessage(messageBoardMessageId);
        if (messageBoardMessage.getAnonymous() != null) {
            existingMessageBoardMessage.setAnonymous(messageBoardMessage.getAnonymous());
        }
        if (messageBoardMessage.getArticleBody() != null) {
            existingMessageBoardMessage.setArticleBody(messageBoardMessage.getArticleBody());
        }
        if (messageBoardMessage.getDateCreated() != null) {
            existingMessageBoardMessage.setDateCreated(messageBoardMessage.getDateCreated());
        }
        if (messageBoardMessage.getDateModified() != null) {
            existingMessageBoardMessage.setDateModified(messageBoardMessage.getDateModified());
        }
        if (messageBoardMessage.getEncodingFormat() != null) {
            existingMessageBoardMessage.setEncodingFormat(messageBoardMessage.getEncodingFormat());
        }
        if (messageBoardMessage.getHeadline() != null) {
            existingMessageBoardMessage.setHeadline(messageBoardMessage.getHeadline());
        }
        if (messageBoardMessage.getKeywords() != null) {
            existingMessageBoardMessage.setKeywords(messageBoardMessage.getKeywords());
        }
        if (messageBoardMessage.getNumberOfMessageBoardAttachments() != null) {
            existingMessageBoardMessage.setNumberOfMessageBoardAttachments(messageBoardMessage.getNumberOfMessageBoardAttachments());
        }
        if (messageBoardMessage.getNumberOfMessageBoardMessages() != null) {
            existingMessageBoardMessage.setNumberOfMessageBoardMessages(messageBoardMessage.getNumberOfMessageBoardMessages());
        }
        if (messageBoardMessage.getShowAsAnswer() != null) {
            existingMessageBoardMessage.setShowAsAnswer(messageBoardMessage.getShowAsAnswer());
        }
        if (messageBoardMessage.getSiteId() != null) {
            existingMessageBoardMessage.setSiteId(messageBoardMessage.getSiteId());
        }
        if (messageBoardMessage.getViewableBy() != null) {
            existingMessageBoardMessage.setViewableBy(messageBoardMessage.getViewableBy());
        }
        this.preparePatch(messageBoardMessage, existingMessageBoardMessage);
        return this.putMessageBoardMessage(messageBoardMessageId, existingMessageBoardMessage);
    }

    @Consumes(value={"application/json", "application/xml"})
    @Operation(description="Replaces the message board message with the information sent in the request body. Any missing fields are deleted, unless they are required.")
    @PUT
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="messageBoardMessageId")})
    @Path(value="/message-board-messages/{messageBoardMessageId}")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="MessageBoardMessage")})
    public MessageBoardMessage putMessageBoardMessage(@NotNull @Parameter(hidden=true) @PathParam(value="messageBoardMessageId") Long messageBoardMessageId, MessageBoardMessage messageBoardMessage) throws Exception {
        return new MessageBoardMessage();
    }

    @DELETE
    @Operation(description="Deletes the message board message's rating and returns a 204 if the operation succeeds.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="messageBoardMessageId")})
    @Path(value="/message-board-messages/{messageBoardMessageId}/my-rating")
    @Produces(value={"application/json"})
    @Tags(value={@Tag(name="MessageBoardMessage")})
    public void deleteMessageBoardMessageMyRating(@NotNull @Parameter(hidden=true) @PathParam(value="messageBoardMessageId") Long messageBoardMessageId) throws Exception {
    }

    @GET
    @Operation(description="Retrieves the message board message's rating.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="messageBoardMessageId")})
    @Path(value="/message-board-messages/{messageBoardMessageId}/my-rating")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="MessageBoardMessage")})
    public Rating getMessageBoardMessageMyRating(@NotNull @Parameter(hidden=true) @PathParam(value="messageBoardMessageId") Long messageBoardMessageId) throws Exception {
        return new Rating();
    }

    @Consumes(value={"application/json", "application/xml"})
    @Operation(description="Creates a rating for the message board message.")
    @POST
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="messageBoardMessageId")})
    @Path(value="/message-board-messages/{messageBoardMessageId}/my-rating")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="MessageBoardMessage")})
    public Rating postMessageBoardMessageMyRating(@NotNull @Parameter(hidden=true) @PathParam(value="messageBoardMessageId") Long messageBoardMessageId, Rating rating) throws Exception {
        return new Rating();
    }

    @Consumes(value={"application/json", "application/xml"})
    @Operation(description="Replaces the rating with the information sent in the request body. Any missing fields are deleted, unless they are required.")
    @PUT
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="messageBoardMessageId")})
    @Path(value="/message-board-messages/{messageBoardMessageId}/my-rating")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="MessageBoardMessage")})
    public Rating putMessageBoardMessageMyRating(@NotNull @Parameter(hidden=true) @PathParam(value="messageBoardMessageId") Long messageBoardMessageId, Rating rating) throws Exception {
        return new Rating();
    }

    @GET
    @Operation(description="Retrieves the parent message board message's child messages. Results can be paginated, filtered, searched, and sorted.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="parentMessageBoardMessageId"), @Parameter(in=ParameterIn.QUERY, name="search"), @Parameter(in=ParameterIn.QUERY, name="filter"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Path(value="/message-board-messages/{parentMessageBoardMessageId}/message-board-messages")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="MessageBoardMessage")})
    public Page<MessageBoardMessage> getMessageBoardMessageMessageBoardMessagesPage(@NotNull @Parameter(hidden=true) @PathParam(value="parentMessageBoardMessageId") Long parentMessageBoardMessageId, @Parameter(hidden=true) @QueryParam(value="search") String search, @Context Filter filter, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Consumes(value={"application/json", "application/xml"})
    @Operation(description="Creates a child message board message of the parent message.")
    @POST
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="parentMessageBoardMessageId")})
    @Path(value="/message-board-messages/{parentMessageBoardMessageId}/message-board-messages")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="MessageBoardMessage")})
    public MessageBoardMessage postMessageBoardMessageMessageBoardMessage(@NotNull @Parameter(hidden=true) @PathParam(value="parentMessageBoardMessageId") Long parentMessageBoardMessageId, MessageBoardMessage messageBoardMessage) throws Exception {
        return new MessageBoardMessage();
    }

    @GET
    @Operation(description="Retrieves the message board thread's messages. Results can be paginated, filtered, searched, and sorted.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="messageBoardThreadId"), @Parameter(in=ParameterIn.QUERY, name="search"), @Parameter(in=ParameterIn.QUERY, name="filter"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Path(value="/message-board-threads/{messageBoardThreadId}/message-board-messages")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="MessageBoardMessage")})
    public Page<MessageBoardMessage> getMessageBoardThreadMessageBoardMessagesPage(@NotNull @Parameter(hidden=true) @PathParam(value="messageBoardThreadId") Long messageBoardThreadId, @Parameter(hidden=true) @QueryParam(value="search") String search, @Context Filter filter, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Consumes(value={"application/json", "application/xml"})
    @Operation(description="Creates a new message in the message board thread.")
    @POST
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="messageBoardThreadId")})
    @Path(value="/message-board-threads/{messageBoardThreadId}/message-board-messages")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="MessageBoardMessage")})
    public MessageBoardMessage postMessageBoardThreadMessageBoardMessage(@NotNull @Parameter(hidden=true) @PathParam(value="messageBoardThreadId") Long messageBoardThreadId, MessageBoardMessage messageBoardMessage) throws Exception {
        return new MessageBoardMessage();
    }

    public void setContextCompany(Company contextCompany) {
        this.contextCompany = contextCompany;
    }

    protected void preparePatch(MessageBoardMessage messageBoardMessage, MessageBoardMessage existingMessageBoardMessage) {
    }

    protected <T, R> List<R> transform(Collection<T> collection, UnsafeFunction<T, R, Exception> unsafeFunction) {
        return TransformUtil.transform(collection, unsafeFunction);
    }

    protected <T, R> R[] transform(T[] array, UnsafeFunction<T, R, Exception> unsafeFunction, Class<?> clazz) {
        return TransformUtil.transform((Object[])array, unsafeFunction, clazz);
    }

    protected <T, R> R[] transformToArray(Collection<T> collection, UnsafeFunction<T, R, Exception> unsafeFunction, Class<?> clazz) {
        return TransformUtil.transformToArray(collection, unsafeFunction, clazz);
    }

    protected <T, R> List<R> transformToList(T[] array, UnsafeFunction<T, R, Exception> unsafeFunction) {
        return TransformUtil.transformToList((Object[])array, unsafeFunction);
    }
}

