/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.resource.v1_0;

import com.liferay.headless.delivery.dto.v1_0.KnowledgeBaseArticle;
import com.liferay.headless.delivery.dto.v1_0.Rating;
import com.liferay.headless.delivery.resource.v1_0.KnowledgeBaseArticleResource;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.TransformUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;

@Path(value="/v1.0")
public abstract class BaseKnowledgeBaseArticleResourceImpl
implements KnowledgeBaseArticleResource {
    @Context
    protected AcceptLanguage contextAcceptLanguage;
    @Context
    protected Company contextCompany;
    @Context
    protected UriInfo contextUriInfo;

    @DELETE
    @Operation(description="Deletes the knowledge base article and returns a 204 if the operation succeeds.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="knowledgeBaseArticleId")})
    @Path(value="/knowledge-base-articles/{knowledgeBaseArticleId}")
    @Produces(value={"application/json"})
    @Tags(value={@Tag(name="KnowledgeBaseArticle")})
    public void deleteKnowledgeBaseArticle(@NotNull @Parameter(hidden=true) @PathParam(value="knowledgeBaseArticleId") Long knowledgeBaseArticleId) throws Exception {
    }

    @GET
    @Operation(description="Retrieves the knowledge base article.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="knowledgeBaseArticleId")})
    @Path(value="/knowledge-base-articles/{knowledgeBaseArticleId}")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="KnowledgeBaseArticle")})
    public KnowledgeBaseArticle getKnowledgeBaseArticle(@NotNull @Parameter(hidden=true) @PathParam(value="knowledgeBaseArticleId") Long knowledgeBaseArticleId) throws Exception {
        return new KnowledgeBaseArticle();
    }

    @Consumes(value={"application/json", "application/xml"})
    @Operation(description="Updates only the fields received in the request body, leaving any other fields untouched.")
    @PATCH
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="knowledgeBaseArticleId")})
    @Path(value="/knowledge-base-articles/{knowledgeBaseArticleId}")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="KnowledgeBaseArticle")})
    public KnowledgeBaseArticle patchKnowledgeBaseArticle(@NotNull @Parameter(hidden=true) @PathParam(value="knowledgeBaseArticleId") Long knowledgeBaseArticleId, KnowledgeBaseArticle knowledgeBaseArticle) throws Exception {
        KnowledgeBaseArticle existingKnowledgeBaseArticle = this.getKnowledgeBaseArticle(knowledgeBaseArticleId);
        if (knowledgeBaseArticle.getArticleBody() != null) {
            existingKnowledgeBaseArticle.setArticleBody(knowledgeBaseArticle.getArticleBody());
        }
        if (knowledgeBaseArticle.getDateCreated() != null) {
            existingKnowledgeBaseArticle.setDateCreated(knowledgeBaseArticle.getDateCreated());
        }
        if (knowledgeBaseArticle.getDateModified() != null) {
            existingKnowledgeBaseArticle.setDateModified(knowledgeBaseArticle.getDateModified());
        }
        if (knowledgeBaseArticle.getDescription() != null) {
            existingKnowledgeBaseArticle.setDescription(knowledgeBaseArticle.getDescription());
        }
        if (knowledgeBaseArticle.getEncodingFormat() != null) {
            existingKnowledgeBaseArticle.setEncodingFormat(knowledgeBaseArticle.getEncodingFormat());
        }
        if (knowledgeBaseArticle.getFriendlyUrlPath() != null) {
            existingKnowledgeBaseArticle.setFriendlyUrlPath(knowledgeBaseArticle.getFriendlyUrlPath());
        }
        if (knowledgeBaseArticle.getKeywords() != null) {
            existingKnowledgeBaseArticle.setKeywords(knowledgeBaseArticle.getKeywords());
        }
        if (knowledgeBaseArticle.getNumberOfAttachments() != null) {
            existingKnowledgeBaseArticle.setNumberOfAttachments(knowledgeBaseArticle.getNumberOfAttachments());
        }
        if (knowledgeBaseArticle.getNumberOfKnowledgeBaseArticles() != null) {
            existingKnowledgeBaseArticle.setNumberOfKnowledgeBaseArticles(knowledgeBaseArticle.getNumberOfKnowledgeBaseArticles());
        }
        if (knowledgeBaseArticle.getParentKnowledgeBaseFolderId() != null) {
            existingKnowledgeBaseArticle.setParentKnowledgeBaseFolderId(knowledgeBaseArticle.getParentKnowledgeBaseFolderId());
        }
        if (knowledgeBaseArticle.getSiteId() != null) {
            existingKnowledgeBaseArticle.setSiteId(knowledgeBaseArticle.getSiteId());
        }
        if (knowledgeBaseArticle.getTaxonomyCategoryIds() != null) {
            existingKnowledgeBaseArticle.setTaxonomyCategoryIds(knowledgeBaseArticle.getTaxonomyCategoryIds());
        }
        if (knowledgeBaseArticle.getTitle() != null) {
            existingKnowledgeBaseArticle.setTitle(knowledgeBaseArticle.getTitle());
        }
        if (knowledgeBaseArticle.getViewableBy() != null) {
            existingKnowledgeBaseArticle.setViewableBy(knowledgeBaseArticle.getViewableBy());
        }
        this.preparePatch(knowledgeBaseArticle, existingKnowledgeBaseArticle);
        return this.putKnowledgeBaseArticle(knowledgeBaseArticleId, existingKnowledgeBaseArticle);
    }

    @Consumes(value={"application/json", "application/xml"})
    @Operation(description="Replaces the knowledge base article with the information sent in the request body. Any missing fields are deleted, unless they are required.")
    @PUT
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="knowledgeBaseArticleId")})
    @Path(value="/knowledge-base-articles/{knowledgeBaseArticleId}")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="KnowledgeBaseArticle")})
    public KnowledgeBaseArticle putKnowledgeBaseArticle(@NotNull @Parameter(hidden=true) @PathParam(value="knowledgeBaseArticleId") Long knowledgeBaseArticleId, KnowledgeBaseArticle knowledgeBaseArticle) throws Exception {
        return new KnowledgeBaseArticle();
    }

    @DELETE
    @Operation(description="Deletes the knowledge base article's rating and returns a 204 if the operation succeeds.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="knowledgeBaseArticleId")})
    @Path(value="/knowledge-base-articles/{knowledgeBaseArticleId}/my-rating")
    @Produces(value={"application/json"})
    @Tags(value={@Tag(name="KnowledgeBaseArticle")})
    public void deleteKnowledgeBaseArticleMyRating(@NotNull @Parameter(hidden=true) @PathParam(value="knowledgeBaseArticleId") Long knowledgeBaseArticleId) throws Exception {
    }

    @GET
    @Operation(description="Retrieves the knowledge base article's rating.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="knowledgeBaseArticleId")})
    @Path(value="/knowledge-base-articles/{knowledgeBaseArticleId}/my-rating")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="KnowledgeBaseArticle")})
    public Rating getKnowledgeBaseArticleMyRating(@NotNull @Parameter(hidden=true) @PathParam(value="knowledgeBaseArticleId") Long knowledgeBaseArticleId) throws Exception {
        return new Rating();
    }

    @Consumes(value={"application/json", "application/xml"})
    @Operation(description="Creates a rating for the knowledge base article.")
    @POST
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="knowledgeBaseArticleId")})
    @Path(value="/knowledge-base-articles/{knowledgeBaseArticleId}/my-rating")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="KnowledgeBaseArticle")})
    public Rating postKnowledgeBaseArticleMyRating(@NotNull @Parameter(hidden=true) @PathParam(value="knowledgeBaseArticleId") Long knowledgeBaseArticleId, Rating rating) throws Exception {
        return new Rating();
    }

    @Consumes(value={"application/json", "application/xml"})
    @Operation(description="Replaces the rating with the information sent in the request body. Any missing fields are deleted, unless they are required.")
    @PUT
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="knowledgeBaseArticleId")})
    @Path(value="/knowledge-base-articles/{knowledgeBaseArticleId}/my-rating")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="KnowledgeBaseArticle")})
    public Rating putKnowledgeBaseArticleMyRating(@NotNull @Parameter(hidden=true) @PathParam(value="knowledgeBaseArticleId") Long knowledgeBaseArticleId, Rating rating) throws Exception {
        return new Rating();
    }

    @GET
    @Operation(description="Retrieves the parent knowledge base article's child knowledge base articles. Results can be paginated, filtered, searched, and sorted.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="parentKnowledgeBaseArticleId"), @Parameter(in=ParameterIn.QUERY, name="search"), @Parameter(in=ParameterIn.QUERY, name="filter"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Path(value="/knowledge-base-articles/{parentKnowledgeBaseArticleId}/knowledge-base-articles")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="KnowledgeBaseArticle")})
    public Page<KnowledgeBaseArticle> getKnowledgeBaseArticleKnowledgeBaseArticlesPage(@NotNull @Parameter(hidden=true) @PathParam(value="parentKnowledgeBaseArticleId") Long parentKnowledgeBaseArticleId, @Parameter(hidden=true) @QueryParam(value="search") String search, @Context Filter filter, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Consumes(value={"application/json", "application/xml"})
    @Operation(description="Creates a child knowledge base article of the knowledge base article identified by `parentKnowledgeBaseArticleId`.")
    @POST
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="parentKnowledgeBaseArticleId")})
    @Path(value="/knowledge-base-articles/{parentKnowledgeBaseArticleId}/knowledge-base-articles")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="KnowledgeBaseArticle")})
    public KnowledgeBaseArticle postKnowledgeBaseArticleKnowledgeBaseArticle(@NotNull @Parameter(hidden=true) @PathParam(value="parentKnowledgeBaseArticleId") Long parentKnowledgeBaseArticleId, KnowledgeBaseArticle knowledgeBaseArticle) throws Exception {
        return new KnowledgeBaseArticle();
    }

    @GET
    @Operation(description="Retrieves the folder's knowledge base articles. Results can be paginated, filtered, searched, flattened, and sorted.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="knowledgeBaseFolderId"), @Parameter(in=ParameterIn.QUERY, name="flatten"), @Parameter(in=ParameterIn.QUERY, name="search"), @Parameter(in=ParameterIn.QUERY, name="filter"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Path(value="/knowledge-base-folders/{knowledgeBaseFolderId}/knowledge-base-articles")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="KnowledgeBaseArticle")})
    public Page<KnowledgeBaseArticle> getKnowledgeBaseFolderKnowledgeBaseArticlesPage(@NotNull @Parameter(hidden=true) @PathParam(value="knowledgeBaseFolderId") Long knowledgeBaseFolderId, @Parameter(hidden=true) @QueryParam(value="flatten") Boolean flatten, @Parameter(hidden=true) @QueryParam(value="search") String search, @Context Filter filter, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Consumes(value={"application/json", "application/xml"})
    @Operation(description="Creates a new knowledge base article in the folder.")
    @POST
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="knowledgeBaseFolderId")})
    @Path(value="/knowledge-base-folders/{knowledgeBaseFolderId}/knowledge-base-articles")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="KnowledgeBaseArticle")})
    public KnowledgeBaseArticle postKnowledgeBaseFolderKnowledgeBaseArticle(@NotNull @Parameter(hidden=true) @PathParam(value="knowledgeBaseFolderId") Long knowledgeBaseFolderId, KnowledgeBaseArticle knowledgeBaseArticle) throws Exception {
        return new KnowledgeBaseArticle();
    }

    @GET
    @Operation(description="Retrieves the Site's knowledge base articles. Results can be paginated, filtered, searched, flattened, and sorted.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId"), @Parameter(in=ParameterIn.QUERY, name="flatten"), @Parameter(in=ParameterIn.QUERY, name="search"), @Parameter(in=ParameterIn.QUERY, name="filter"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Path(value="/sites/{siteId}/knowledge-base-articles")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="KnowledgeBaseArticle")})
    public Page<KnowledgeBaseArticle> getSiteKnowledgeBaseArticlesPage(@NotNull @Parameter(hidden=true) @PathParam(value="siteId") Long siteId, @Parameter(hidden=true) @QueryParam(value="flatten") Boolean flatten, @Parameter(hidden=true) @QueryParam(value="search") String search, @Context Filter filter, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Consumes(value={"application/json", "application/xml"})
    @Operation(description="Creates a new knowledge base article.")
    @POST
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId")})
    @Path(value="/sites/{siteId}/knowledge-base-articles")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="KnowledgeBaseArticle")})
    public KnowledgeBaseArticle postSiteKnowledgeBaseArticle(@NotNull @Parameter(hidden=true) @PathParam(value="siteId") Long siteId, KnowledgeBaseArticle knowledgeBaseArticle) throws Exception {
        return new KnowledgeBaseArticle();
    }

    public void setContextCompany(Company contextCompany) {
        this.contextCompany = contextCompany;
    }

    protected void preparePatch(KnowledgeBaseArticle knowledgeBaseArticle, KnowledgeBaseArticle existingKnowledgeBaseArticle) {
    }

    protected <T, R> List<R> transform(Collection<T> collection, UnsafeFunction<T, R, Exception> unsafeFunction) {
        return TransformUtil.transform(collection, unsafeFunction);
    }

    protected <T, R> R[] transform(T[] array, UnsafeFunction<T, R, Exception> unsafeFunction, Class<?> clazz) {
        return TransformUtil.transform((Object[])array, unsafeFunction, clazz);
    }

    protected <T, R> R[] transformToArray(Collection<T> collection, UnsafeFunction<T, R, Exception> unsafeFunction, Class<?> clazz) {
        return TransformUtil.transformToArray(collection, unsafeFunction, clazz);
    }

    protected <T, R> List<R> transformToList(T[] array, UnsafeFunction<T, R, Exception> unsafeFunction) {
        return TransformUtil.transformToList((Object[])array, unsafeFunction);
    }
}

