/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.resource.v1_0;

import com.liferay.headless.delivery.dto.v1_0.BlogPosting;
import com.liferay.headless.delivery.dto.v1_0.Rating;
import com.liferay.headless.delivery.resource.v1_0.BlogPostingResource;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.TransformUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;

@Path(value="/v1.0")
public abstract class BaseBlogPostingResourceImpl
implements BlogPostingResource {
    @Context
    protected AcceptLanguage contextAcceptLanguage;
    @Context
    protected Company contextCompany;
    @Context
    protected UriInfo contextUriInfo;

    @DELETE
    @Operation(description="Deletes the blog post and returns a 204 if the operation succeeds.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="blogPostingId")})
    @Path(value="/blog-postings/{blogPostingId}")
    @Produces(value={"application/json"})
    @Tags(value={@Tag(name="BlogPosting")})
    public void deleteBlogPosting(@NotNull @Parameter(hidden=true) @PathParam(value="blogPostingId") Long blogPostingId) throws Exception {
    }

    @GET
    @Operation(description="Retrieves the blog post.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="blogPostingId")})
    @Path(value="/blog-postings/{blogPostingId}")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="BlogPosting")})
    public BlogPosting getBlogPosting(@NotNull @Parameter(hidden=true) @PathParam(value="blogPostingId") Long blogPostingId) throws Exception {
        return new BlogPosting();
    }

    @Consumes(value={"application/json", "application/xml"})
    @Operation(description="Updates the blog post using only the fields received in the request body. Any other fields are left untouched. Returns the updated blog post.")
    @PATCH
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="blogPostingId")})
    @Path(value="/blog-postings/{blogPostingId}")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="BlogPosting")})
    public BlogPosting patchBlogPosting(@NotNull @Parameter(hidden=true) @PathParam(value="blogPostingId") Long blogPostingId, BlogPosting blogPosting) throws Exception {
        BlogPosting existingBlogPosting = this.getBlogPosting(blogPostingId);
        if (blogPosting.getAlternativeHeadline() != null) {
            existingBlogPosting.setAlternativeHeadline(blogPosting.getAlternativeHeadline());
        }
        if (blogPosting.getArticleBody() != null) {
            existingBlogPosting.setArticleBody(blogPosting.getArticleBody());
        }
        if (blogPosting.getDateCreated() != null) {
            existingBlogPosting.setDateCreated(blogPosting.getDateCreated());
        }
        if (blogPosting.getDateModified() != null) {
            existingBlogPosting.setDateModified(blogPosting.getDateModified());
        }
        if (blogPosting.getDatePublished() != null) {
            existingBlogPosting.setDatePublished(blogPosting.getDatePublished());
        }
        if (blogPosting.getDescription() != null) {
            existingBlogPosting.setDescription(blogPosting.getDescription());
        }
        if (blogPosting.getEncodingFormat() != null) {
            existingBlogPosting.setEncodingFormat(blogPosting.getEncodingFormat());
        }
        if (blogPosting.getFriendlyUrlPath() != null) {
            existingBlogPosting.setFriendlyUrlPath(blogPosting.getFriendlyUrlPath());
        }
        if (blogPosting.getHeadline() != null) {
            existingBlogPosting.setHeadline(blogPosting.getHeadline());
        }
        if (blogPosting.getKeywords() != null) {
            existingBlogPosting.setKeywords(blogPosting.getKeywords());
        }
        if (blogPosting.getNumberOfComments() != null) {
            existingBlogPosting.setNumberOfComments(blogPosting.getNumberOfComments());
        }
        if (blogPosting.getSiteId() != null) {
            existingBlogPosting.setSiteId(blogPosting.getSiteId());
        }
        if (blogPosting.getTaxonomyCategoryIds() != null) {
            existingBlogPosting.setTaxonomyCategoryIds(blogPosting.getTaxonomyCategoryIds());
        }
        if (blogPosting.getViewableBy() != null) {
            existingBlogPosting.setViewableBy(blogPosting.getViewableBy());
        }
        this.preparePatch(blogPosting, existingBlogPosting);
        return this.putBlogPosting(blogPostingId, existingBlogPosting);
    }

    @Consumes(value={"application/json", "application/xml"})
    @Operation(description="Replaces the blog post with the information sent in the request body. Any missing fields are deleted, unless they are required.")
    @PUT
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="blogPostingId")})
    @Path(value="/blog-postings/{blogPostingId}")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="BlogPosting")})
    public BlogPosting putBlogPosting(@NotNull @Parameter(hidden=true) @PathParam(value="blogPostingId") Long blogPostingId, BlogPosting blogPosting) throws Exception {
        return new BlogPosting();
    }

    @DELETE
    @Operation(description="Deletes the blog post rating of the user who authenticated the request.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="blogPostingId")})
    @Path(value="/blog-postings/{blogPostingId}/my-rating")
    @Produces(value={"application/json"})
    @Tags(value={@Tag(name="BlogPosting")})
    public void deleteBlogPostingMyRating(@NotNull @Parameter(hidden=true) @PathParam(value="blogPostingId") Long blogPostingId) throws Exception {
    }

    @GET
    @Operation(description="Retrieves the blog post rating of the user who authenticated the request.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="blogPostingId")})
    @Path(value="/blog-postings/{blogPostingId}/my-rating")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="BlogPosting")})
    public Rating getBlogPostingMyRating(@NotNull @Parameter(hidden=true) @PathParam(value="blogPostingId") Long blogPostingId) throws Exception {
        return new Rating();
    }

    @Consumes(value={"application/json", "application/xml"})
    @Operation(description="Creates a new blog post rating by the user who authenticated the request.")
    @POST
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="blogPostingId")})
    @Path(value="/blog-postings/{blogPostingId}/my-rating")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="BlogPosting")})
    public Rating postBlogPostingMyRating(@NotNull @Parameter(hidden=true) @PathParam(value="blogPostingId") Long blogPostingId, Rating rating) throws Exception {
        return new Rating();
    }

    @Consumes(value={"application/json", "application/xml"})
    @Operation(description="Replaces an existing blog post rating by the user who authenticated the request.")
    @PUT
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="blogPostingId")})
    @Path(value="/blog-postings/{blogPostingId}/my-rating")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="BlogPosting")})
    public Rating putBlogPostingMyRating(@NotNull @Parameter(hidden=true) @PathParam(value="blogPostingId") Long blogPostingId, Rating rating) throws Exception {
        return new Rating();
    }

    @GET
    @Operation(description="Retrieves the Site's blog postings. Results can be paginated, filtered, searched, and sorted.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId"), @Parameter(in=ParameterIn.QUERY, name="search"), @Parameter(in=ParameterIn.QUERY, name="filter"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Path(value="/sites/{siteId}/blog-postings")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="BlogPosting")})
    public Page<BlogPosting> getSiteBlogPostingsPage(@NotNull @Parameter(hidden=true) @PathParam(value="siteId") Long siteId, @Parameter(hidden=true) @QueryParam(value="search") String search, @Context Filter filter, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Consumes(value={"application/json", "application/xml"})
    @Operation(description="Creates a new blog post.")
    @POST
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId")})
    @Path(value="/sites/{siteId}/blog-postings")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="BlogPosting")})
    public BlogPosting postSiteBlogPosting(@NotNull @Parameter(hidden=true) @PathParam(value="siteId") Long siteId, BlogPosting blogPosting) throws Exception {
        return new BlogPosting();
    }

    public void setContextCompany(Company contextCompany) {
        this.contextCompany = contextCompany;
    }

    protected void preparePatch(BlogPosting blogPosting, BlogPosting existingBlogPosting) {
    }

    protected <T, R> List<R> transform(Collection<T> collection, UnsafeFunction<T, R, Exception> unsafeFunction) {
        return TransformUtil.transform(collection, unsafeFunction);
    }

    protected <T, R> R[] transform(T[] array, UnsafeFunction<T, R, Exception> unsafeFunction, Class<?> clazz) {
        return TransformUtil.transform((Object[])array, unsafeFunction, clazz);
    }

    protected <T, R> R[] transformToArray(Collection<T> collection, UnsafeFunction<T, R, Exception> unsafeFunction, Class<?> clazz) {
        return TransformUtil.transformToArray(collection, unsafeFunction, clazz);
    }

    protected <T, R> List<R> transformToList(T[] array, UnsafeFunction<T, R, Exception> unsafeFunction) {
        return TransformUtil.transformToList((Object[])array, unsafeFunction);
    }
}

