/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.dto.v1_0.util;

import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.model.UnlocalizedValue;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.headless.delivery.dto.v1_0.ContentDocument;
import com.liferay.headless.delivery.dto.v1_0.ContentField;
import com.liferay.headless.delivery.dto.v1_0.Geo;
import com.liferay.headless.delivery.dto.v1_0.StructuredContentLink;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.service.JournalArticleService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.permission.LayoutPermissionUtil;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import javax.ws.rs.BadRequestException;

public class DDMValueUtil {
    public static Value toDDMValue(ContentField contentFieldValue, DDMFormField ddmFormField, DLAppService dlAppService, long groupId, JournalArticleService journalArticleService, LayoutLocalService layoutLocalService, Locale locale) {
        com.liferay.headless.delivery.dto.v1_0.Value value = contentFieldValue.getValue();
        if (value == null) {
            throw new BadRequestException("No value is specified for field " + ddmFormField.getName());
        }
        if (ddmFormField.isLocalizable()) {
            LocalizedValue localizedValue = new LocalizedValue(locale);
            if (Objects.equals("ddm-date", ddmFormField.getType())) {
                localizedValue.addString(locale, DDMValueUtil._toDateString(value.getData(), locale));
            } else if (Objects.equals("ddm-documentlibrary", ddmFormField.getType())) {
                String valueString = "";
                ContentDocument contentDocument = value.getDocument();
                if (contentDocument != null && contentDocument.getId() != null) {
                    valueString = DDMValueUtil._toJSON(dlAppService, "", contentDocument.getId());
                }
                localizedValue.addString(locale, valueString);
            } else if (Objects.equals("ddm-image", ddmFormField.getType())) {
                String valueString = "";
                ContentDocument contentDocument = value.getImage();
                if (contentDocument != null && contentDocument.getId() != null) {
                    valueString = DDMValueUtil._toJSON(dlAppService, contentDocument.getDescription(), contentDocument.getId());
                }
                localizedValue.addString(locale, valueString);
            } else if (Objects.equals("ddm-journal-article", ddmFormField.getType())) {
                String valueString = "";
                StructuredContentLink structuredContentLink = value.getStructuredContentLink();
                if (structuredContentLink != null && structuredContentLink.getId() != null) {
                    JournalArticle journalArticle = null;
                    try {
                        journalArticle = journalArticleService.getLatestArticle(structuredContentLink.getId().longValue());
                    }
                    catch (Exception e) {
                        throw new BadRequestException("No structured content exists with ID " + structuredContentLink.getId(), (Throwable)e);
                    }
                    valueString = JSONUtil.put((String)"className", (Object)JournalArticle.class.getName()).put("classPK", journalArticle.getResourcePrimKey()).put("title", journalArticle.getTitle()).toString();
                }
                localizedValue.addString(locale, valueString);
            } else if (Objects.equals("ddm-link-to-page", ddmFormField.getType())) {
                String valueString = "";
                if (value.getLink() != null) {
                    Layout layout = DDMValueUtil._getLayout(groupId, layoutLocalService, value.getLink());
                    valueString = JSONUtil.put((String)"groupId", (Object)layout.getGroupId()).put("label", layout.getFriendlyURL()).put("privateLayout", layout.isPrivateLayout()).put("layoutId", layout.getLayoutId()).toString();
                }
                localizedValue.addString(locale, valueString);
            } else {
                localizedValue.addString(locale, GetterUtil.getString((String)value.getData()));
            }
            return localizedValue;
        }
        if (Objects.equals("ddm-geolocation", ddmFormField.getType())) {
            Geo geo = value.getGeo();
            if (Objects.isNull(geo) || Objects.isNull(geo.getLatitude()) || Objects.isNull(geo.getLongitude())) {
                throw new BadRequestException("Invalid geo " + geo);
            }
            return new UnlocalizedValue(JSONUtil.put((String)"latitude", (Object)geo.getLatitude()).put("longitude", (Object)geo.getLongitude()).toString());
        }
        return new UnlocalizedValue(GetterUtil.getString((String)value.getData()));
    }

    private static Layout _getLayout(long groupId, LayoutLocalService layoutLocalService, String link) {
        Layout layout = layoutLocalService.fetchLayoutByFriendlyURL(groupId, false, link);
        if (layout == null) {
            layout = layoutLocalService.fetchLayoutByFriendlyURL(groupId, true, link);
        }
        if (layout == null) {
            throw new BadRequestException("No page found with friendly URL " + link);
        }
        try {
            LayoutPermissionUtil.check((PermissionChecker)PermissionThreadLocal.getPermissionChecker(), (Layout)layout, (String)"VIEW");
        }
        catch (PortalException pe) {
            throw new BadRequestException("No page found with friendly URL " + link, (Throwable)pe);
        }
        return layout;
    }

    private static String _toDateString(String valueString, Locale locale) {
        if (Validator.isNull((String)valueString)) {
            return "";
        }
        try {
            return DateUtil.getDate((Date)DateUtil.parseDate((String)"yyyy-MM-dd'T'HH:mm:ss'Z'", (String)valueString, (Locale)locale), (String)"yyyy-MM-dd", (Locale)locale);
        }
        catch (ParseException pe) {
            throw new BadRequestException("Unable to parse date that does not conform to ISO-8601", (Throwable)pe);
        }
    }

    private static String _toJSON(DLAppService dlAppService, String description, long fileEntryId) {
        FileEntry fileEntry = null;
        try {
            fileEntry = dlAppService.getFileEntry(fileEntryId);
        }
        catch (Exception e) {
            throw new BadRequestException("No document exists with ID " + fileEntryId, (Throwable)e);
        }
        return JSONUtil.put((String)"alt", (Object)description).put("classPK", fileEntry.getFileEntryId()).put("fileEntryId", fileEntry.getFileEntryId()).put("groupId", fileEntry.getGroupId()).put("name", fileEntry.getFileName()).put("resourcePrimKey", fileEntry.getPrimaryKey()).put("title", fileEntry.getFileName()).put("type", "document").put("uuid", fileEntry.getUuid()).toString();
    }
}

