/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.dto.v1_0.util;

import com.liferay.headless.delivery.dto.v1_0.Creator;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.Portal;

public class CreatorUtil {
    public static Creator toCreator(final Portal portal, final User user) {
        if (user == null || user.isDefaultUser()) {
            return null;
        }
        return new Creator(){
            {
                this.additionalName = user.getMiddleName();
                this.familyName = user.getLastName();
                this.givenName = user.getFirstName();
                this.id = user.getUserId();
                this.name = user.getFullName();
                this.setImage(() -> {
                    if (user.getPortraitId() == 0L) {
                        return null;
                    }
                    ThemeDisplay themeDisplay = new ThemeDisplay(){
                        {
                            this.setPathImage(portal.getPathImage());
                        }
                    };
                    return user.getPortraitURL(themeDisplay);
                });
                this.setProfileURL(() -> {
                    final Group group = user.getGroup();
                    ThemeDisplay themeDisplay = new ThemeDisplay(){
                        {
                            this.setPortalURL("");
                            this.setSiteGroupId(group.getGroupId());
                        }
                    };
                    return group.getDisplayURL(themeDisplay);
                });
            }
        };
    }
}

