/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.dto.v1_0.util;

import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldOptions;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.headless.delivery.dto.v1_0.ContentStructure;
import com.liferay.headless.delivery.dto.v1_0.ContentStructureField;
import com.liferay.headless.delivery.dto.v1_0.Option;
import com.liferay.headless.delivery.internal.dto.v1_0.util.CreatorUtil;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.vulcan.util.TransformUtil;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

public class ContentStructureUtil {
    public static ContentStructure toContentStructure(final DDMStructure ddmStructure, final Locale locale, final Portal portal, final UserLocalService userLocalService) throws Exception {
        if (ddmStructure == null) {
            return null;
        }
        return new ContentStructure(){
            {
                this.availableLanguages = LocaleUtil.toW3cLanguageIds((String[])ddmStructure.getAvailableLanguageIds());
                this.contentStructureFields = (ContentStructureField[])TransformUtil.transformToArray((Collection)ddmStructure.getRootFieldNames(), fieldName -> ContentStructureUtil._toContentStructureField(ddmStructure.getDDMFormField(fieldName), locale), ContentStructureField.class);
                this.creator = CreatorUtil.toCreator(portal, userLocalService.getUserById(ddmStructure.getUserId()));
                this.dateCreated = ddmStructure.getCreateDate();
                this.dateModified = ddmStructure.getModifiedDate();
                this.description = ddmStructure.getDescription(locale);
                this.id = ddmStructure.getStructureId();
                this.name = ddmStructure.getName(locale);
                this.siteId = ddmStructure.getGroupId();
            }
        };
    }

    public static String toDataType(DDMFormField ddmFormField) {
        String type = ddmFormField.getType();
        if ("ddm-documentlibrary".equals(type)) {
            return "document";
        }
        if ("ddm-journal-article".equals(type)) {
            return "structuredContent";
        }
        if ("ddm-link-to-page".equals(type)) {
            return "url";
        }
        if ("radio".equals(type)) {
            return "string";
        }
        return ddmFormField.getDataType();
    }

    public static String toInputControl(DDMFormField ddmFormField) {
        String type = ddmFormField.getType();
        if ("checkbox".equals(type) || "radio".equals(type) || "select".equals(type) || "text".equals(type) || "textarea".equals(type)) {
            return type;
        }
        return null;
    }

    private static ContentStructureField _toContentStructureField(final DDMFormField ddmFormField, final Locale locale) {
        return new ContentStructureField(){
            {
                this.label = ContentStructureUtil._toString(ddmFormField.getLabel(), locale);
                this.localizable = ddmFormField.isLocalizable();
                this.multiple = ddmFormField.isMultiple();
                this.name = ddmFormField.getName();
                this.nestedContentStructureFields = (ContentStructureField[])TransformUtil.transformToArray((Collection)ddmFormField.getNestedDDMFormFields(), ddmFormField -> ContentStructureUtil._toContentStructureField(ddmFormField, locale), ContentStructureField.class);
                this.predefinedValue = ContentStructureUtil._toString(ddmFormField.getPredefinedValue(), locale);
                this.repeatable = ddmFormField.isRepeatable();
                this.required = ddmFormField.isRequired();
                this.showLabel = ddmFormField.isShowLabel();
                this.setDataType(ContentStructureUtil.toDataType(ddmFormField));
                this.setInputControl(ContentStructureUtil.toInputControl(ddmFormField));
                this.setLabel(ContentStructureUtil._toString(ddmFormField.getLabel(), locale));
                this.setLocalizable(ddmFormField.isLocalizable());
                this.setMultiple(ddmFormField.isMultiple());
                this.setName(ddmFormField.getName());
                this.setOptions(() -> (Option[])Optional.ofNullable(ddmFormField.getDDMFormFieldOptions()).map(DDMFormFieldOptions::getOptions).map(Map::entrySet).map(Collection::stream).orElseGet(Stream::empty).map(entry -> new Option((Map.Entry)entry, locale){
                    final /* synthetic */ Map.Entry val$entry;
                    final /* synthetic */ Locale val$locale;
                    {
                        this.val$entry = entry;
                        this.val$locale = locale;
                        this.setLabel(ContentStructureUtil._toString((LocalizedValue)this.val$entry.getValue(), this.val$locale));
                        this.setValue((String)this.val$entry.getKey());
                    }
                }).toArray(Option[]::new));
            }
        };
    }

    private static String _toString(LocalizedValue localizedValue, Locale locale) {
        if (localizedValue == null) {
            return null;
        }
        return localizedValue.getString(locale);
    }
}

