/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.dto.v1_0.converter;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.model.AssetTag;
import com.liferay.asset.kernel.service.AssetCategoryLocalService;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.asset.kernel.service.AssetLinkLocalService;
import com.liferay.asset.kernel.service.AssetTagLocalService;
import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.document.library.util.DLURLHelper;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.storage.Fields;
import com.liferay.dynamic.data.mapping.util.FieldsToDDMFormValuesConverter;
import com.liferay.headless.delivery.dto.v1_0.ContentField;
import com.liferay.headless.delivery.dto.v1_0.Geo;
import com.liferay.headless.delivery.dto.v1_0.RenderedContent;
import com.liferay.headless.delivery.dto.v1_0.StructuredContent;
import com.liferay.headless.delivery.dto.v1_0.StructuredContentLink;
import com.liferay.headless.delivery.dto.v1_0.TaxonomyCategory;
import com.liferay.headless.delivery.dto.v1_0.converter.DTOConverter;
import com.liferay.headless.delivery.dto.v1_0.converter.DTOConverterContext;
import com.liferay.headless.delivery.internal.dto.v1_0.util.AggregateRatingUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.ContentDocumentUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.ContentStructureUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.CreatorUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.CustomFieldsUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.RelatedContentUtil;
import com.liferay.headless.delivery.internal.resource.v1_0.BaseStructuredContentResourceImpl;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.service.JournalArticleService;
import com.liferay.journal.util.JournalConverter;
import com.liferay.portal.kernel.comment.CommentManager;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.util.JaxRsLinkUtil;
import com.liferay.portal.vulcan.util.TransformUtil;
import com.liferay.ratings.kernel.service.RatingsStatsLocalService;
import java.text.ParseException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.TimeZone;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.core.UriInfo;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"asset.entry.class.name=com.liferay.journal.model.JournalArticle"}, service={DTOConverter.class, StructuredContentDTOConverter.class})
public class StructuredContentDTOConverter
implements DTOConverter {
    @Reference
    private AssetCategoryLocalService _assetCategoryLocalService;
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;
    @Reference
    private AssetLinkLocalService _assetLinkLocalService;
    @Reference
    private AssetTagLocalService _assetTagLocalService;
    @Reference
    private CommentManager _commentManager;
    @Reference
    private DLAppService _dlAppService;
    @Reference
    private DLURLHelper _dlURLHelper;
    @Reference
    private FieldsToDDMFormValuesConverter _fieldsToDDMFormValuesConverter;
    @Reference
    private JournalArticleService _journalArticleService;
    @Reference
    private JournalConverter _journalConverter;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private RatingsStatsLocalService _ratingsStatsLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public String getContentType() {
        return StructuredContent.class.getSimpleName();
    }

    public StructuredContent toDTO(final DTOConverterContext dtoConverterContext) throws Exception {
        final JournalArticle journalArticle = this._journalArticleService.getLatestArticle(dtoConverterContext.getResourcePrimKey());
        final DDMStructure ddmStructure = journalArticle.getDDMStructure();
        return new StructuredContent(){
            {
                this.availableLanguages = LocaleUtil.toW3cLanguageIds((String[])journalArticle.getAvailableLanguageIds());
                this.aggregateRating = AggregateRatingUtil.toAggregateRating(StructuredContentDTOConverter.this._ratingsStatsLocalService.fetchStats(JournalArticle.class.getName(), journalArticle.getResourcePrimKey()));
                this.contentFields = StructuredContentDTOConverter.this._toContentFields(journalArticle, dtoConverterContext.getLocale(), StructuredContentDTOConverter.this._dlAppService, StructuredContentDTOConverter.this._dlURLHelper, StructuredContentDTOConverter.this._fieldsToDDMFormValuesConverter, StructuredContentDTOConverter.this._journalArticleService, StructuredContentDTOConverter.this._journalConverter, StructuredContentDTOConverter.this._layoutLocalService);
                this.contentStructureId = ddmStructure.getStructureId();
                this.creator = CreatorUtil.toCreator(StructuredContentDTOConverter.this._portal, StructuredContentDTOConverter.this._userLocalService.getUserById(journalArticle.getUserId()));
                this.customFields = CustomFieldsUtil.toCustomFields(JournalArticle.class.getName(), journalArticle.getId(), journalArticle.getCompanyId(), dtoConverterContext.getLocale());
                this.dateCreated = journalArticle.getCreateDate();
                this.dateModified = journalArticle.getModifiedDate();
                this.datePublished = journalArticle.getDisplayDate();
                this.description = journalArticle.getDescription(dtoConverterContext.getLocale());
                this.friendlyUrlPath = journalArticle.getUrlTitle(dtoConverterContext.getLocale());
                this.id = journalArticle.getResourcePrimKey();
                this.key = journalArticle.getArticleId();
                this.keywords = (String[])ListUtil.toArray((List)StructuredContentDTOConverter.this._assetTagLocalService.getTags(JournalArticle.class.getName(), journalArticle.getResourcePrimKey()), (Accessor)AssetTag.NAME_ACCESSOR);
                this.numberOfComments = StructuredContentDTOConverter.this._commentManager.getCommentsCount(JournalArticle.class.getName(), journalArticle.getResourcePrimKey());
                this.relatedContents = RelatedContentUtil.toRelatedContents(StructuredContentDTOConverter.this._assetEntryLocalService, StructuredContentDTOConverter.this._assetLinkLocalService, JournalArticle.class.getName(), journalArticle.getResourcePrimKey(), dtoConverterContext.getLocale());
                this.renderedContents = StructuredContentDTOConverter.this._toRenderedContents(ddmStructure, journalArticle, dtoConverterContext.getLocale(), dtoConverterContext.getUriInfoOptional());
                this.siteId = journalArticle.getGroupId();
                this.taxonomyCategories = (TaxonomyCategory[])TransformUtil.transformToArray((Collection)StructuredContentDTOConverter.this._assetCategoryLocalService.getCategories(JournalArticle.class.getName(), journalArticle.getResourcePrimKey()), assetCategory -> new TaxonomyCategory((AssetCategory)assetCategory){
                    final /* synthetic */ AssetCategory val$assetCategory;
                    {
                        this.val$assetCategory = assetCategory;
                        this.taxonomyCategoryId = this.val$assetCategory.getCategoryId();
                        this.taxonomyCategoryName = this.val$assetCategory.getName();
                    }
                }, TaxonomyCategory.class);
                this.title = journalArticle.getTitle(dtoConverterContext.getLocale());
                this.uuid = journalArticle.getUuid();
            }
        };
    }

    private ContentField _toContentField(final DDMFormFieldValue ddmFormFieldValue, final Locale locale, final DLAppService dlAppService, final DLURLHelper dlURLHelper, final JournalArticleService journalArticleService, final LayoutLocalService layoutLocalService) throws Exception {
        final DDMFormField ddmFormField = ddmFormFieldValue.getDDMFormField();
        return new ContentField(){
            {
                this.dataType = ContentStructureUtil.toDataType(ddmFormField);
                this.inputControl = ContentStructureUtil.toInputControl(ddmFormField);
                this.name = ddmFormField.getName();
                this.nestedFields = (ContentField[])TransformUtil.transformToArray((Collection)ddmFormFieldValue.getNestedDDMFormFieldValues(), value -> StructuredContentDTOConverter.this._toContentField(value, locale, dlAppService, dlURLHelper, journalArticleService, layoutLocalService), ContentField.class);
                this.repeatable = ddmFormField.isRepeatable();
                this.value = StructuredContentDTOConverter.this._toValue(ddmFormFieldValue, dlAppService, dlURLHelper, journalArticleService, layoutLocalService, locale);
            }
        };
    }

    private ContentField[] _toContentFields(JournalArticle journalArticle, Locale locale, DLAppService dlAppService, DLURLHelper dlURLHelper, FieldsToDDMFormValuesConverter fieldsToDDMFormValuesConverter, JournalArticleService journalArticleService, JournalConverter journalConverter, LayoutLocalService layoutLocalService) throws Exception {
        DDMStructure ddmStructure = journalArticle.getDDMStructure();
        Fields fields = journalConverter.getDDMFields(ddmStructure, journalArticle.getContent());
        DDMFormValues ddmFormValues = fieldsToDDMFormValuesConverter.convert(ddmStructure, fields);
        return (ContentField[])TransformUtil.transformToArray((Collection)ddmFormValues.getDDMFormFieldValues(), aDDMFormFieldValue -> this._toContentField((DDMFormFieldValue)aDDMFormFieldValue, locale, dlAppService, dlURLHelper, journalArticleService, layoutLocalService), ContentField.class);
    }

    private String _toDateString(Locale locale, String valueString) {
        if (Validator.isNull((String)valueString)) {
            return "";
        }
        try {
            return DateUtil.getDate((Date)DateUtil.parseDate((String)"yyyy-MM-dd", (String)valueString, (Locale)locale), (String)"yyyy-MM-dd'T'HH:mm:ss'Z'", (Locale)locale, (TimeZone)TimeZone.getTimeZone("UTC"));
        }
        catch (ParseException pe) {
            throw new BadRequestException("Unable to parse date that does not conform to ISO-8601", (Throwable)pe);
        }
    }

    private RenderedContent[] _toRenderedContents(DDMStructure ddmStructure, final JournalArticle journalArticle, Locale locale, final Optional<UriInfo> uriInfoOptional) {
        if (!uriInfoOptional.isPresent()) {
            return null;
        }
        return (RenderedContent[])TransformUtil.transformToArray((Collection)ddmStructure.getTemplates(), ddmTemplate -> new RenderedContent((DDMTemplate)ddmTemplate, locale){
            final /* synthetic */ DDMTemplate val$ddmTemplate;
            final /* synthetic */ Locale val$locale;
            {
                this.val$ddmTemplate = dDMTemplate;
                this.val$locale = locale;
                this.renderedContentURL = JaxRsLinkUtil.getJaxRsLink(BaseStructuredContentResourceImpl.class, (String)"getStructuredContentRenderedContentTemplate", (UriInfo)((UriInfo)uriInfoOptional.get()), (Object[])new Object[]{journalArticle.getResourcePrimKey(), this.val$ddmTemplate.getTemplateId()});
                this.templateName = this.val$ddmTemplate.getName(this.val$locale);
            }
        }, RenderedContent.class);
    }

    private com.liferay.headless.delivery.dto.v1_0.Value _toValue(DDMFormFieldValue ddmFormFieldValue, DLAppService dlAppService, final DLURLHelper dlURLHelper, JournalArticleService journalArticleService, LayoutLocalService layoutLocalService, final Locale locale) throws Exception {
        Value value = ddmFormFieldValue.getValue();
        if (value == null) {
            return new com.liferay.headless.delivery.dto.v1_0.Value();
        }
        DDMFormField ddmFormField = ddmFormFieldValue.getDDMFormField();
        final String valueString = String.valueOf(value.getString(locale));
        if (Objects.equals("ddm-date", ddmFormField.getType())) {
            return new com.liferay.headless.delivery.dto.v1_0.Value(){
                {
                    this.data = StructuredContentDTOConverter.this._toDateString(locale, valueString);
                }
            };
        }
        if (Objects.equals("ddm-documentlibrary", ddmFormField.getType())) {
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)valueString);
            long classPK = jsonObject.getLong("classPK");
            if (classPK == 0L) {
                return new com.liferay.headless.delivery.dto.v1_0.Value();
            }
            final FileEntry fileEntry = dlAppService.getFileEntry(classPK);
            return new com.liferay.headless.delivery.dto.v1_0.Value(){
                {
                    this.document = ContentDocumentUtil.toContentDocument(dlURLHelper, fileEntry);
                }
            };
        }
        if (Objects.equals("ddm-geolocation", ddmFormField.getType())) {
            final JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)valueString);
            return new com.liferay.headless.delivery.dto.v1_0.Value(){
                {
                    this.geo = new Geo(){
                        {
                            this.latitude = jsonObject.getDouble("latitude");
                            this.longitude = jsonObject.getDouble("longitude");
                        }
                    };
                }
            };
        }
        if (Objects.equals("ddm-image", ddmFormField.getType())) {
            final JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)valueString);
            long fileEntryId = jsonObject.getLong("fileEntryId");
            if (fileEntryId == 0L) {
                return new com.liferay.headless.delivery.dto.v1_0.Value();
            }
            final FileEntry fileEntry = dlAppService.getFileEntry(fileEntryId);
            return new com.liferay.headless.delivery.dto.v1_0.Value(){
                {
                    this.image = ContentDocumentUtil.toContentDocument(dlURLHelper, fileEntry);
                    this.image.setDescription(jsonObject.getString("alt"));
                }
            };
        }
        if (Objects.equals("ddm-journal-article", ddmFormField.getType())) {
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)valueString);
            long classPK = jsonObject.getLong("classPK");
            if (classPK == 0L) {
                return new com.liferay.headless.delivery.dto.v1_0.Value();
            }
            final JournalArticle journalArticle = journalArticleService.getLatestArticle(classPK);
            return new com.liferay.headless.delivery.dto.v1_0.Value(){
                {
                    this.structuredContentLink = new StructuredContentLink(){
                        {
                            this.id = journalArticle.getResourcePrimKey();
                            this.title = journalArticle.getTitle();
                        }
                    };
                }
            };
        }
        if (Objects.equals("ddm-link-to-page", ddmFormField.getType())) {
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)valueString);
            long layoutId = jsonObject.getLong("layoutId");
            if (layoutId == 0L) {
                return new com.liferay.headless.delivery.dto.v1_0.Value();
            }
            long groupId = jsonObject.getLong("groupId");
            boolean privateLayout = jsonObject.getBoolean("privateLayout");
            final Layout layoutByUuidAndGroupId = layoutLocalService.getLayout(groupId, privateLayout, layoutId);
            return new com.liferay.headless.delivery.dto.v1_0.Value(){
                {
                    this.link = layoutByUuidAndGroupId.getFriendlyURL();
                }
            };
        }
        return new com.liferay.headless.delivery.dto.v1_0.Value(){
            {
                this.data = valueString;
            }
        };
    }
}

