/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.dto.v1_0.converter;

import com.liferay.asset.kernel.model.AssetTag;
import com.liferay.asset.kernel.service.AssetCategoryLocalService;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.asset.kernel.service.AssetLinkLocalService;
import com.liferay.asset.kernel.service.AssetTagLocalService;
import com.liferay.headless.delivery.dto.v1_0.KnowledgeBaseArticle;
import com.liferay.headless.delivery.dto.v1_0.TaxonomyCategory;
import com.liferay.headless.delivery.dto.v1_0.converter.DTOConverter;
import com.liferay.headless.delivery.dto.v1_0.converter.DTOConverterContext;
import com.liferay.headless.delivery.internal.dto.v1_0.util.AggregateRatingUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.CreatorUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.CustomFieldsUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.ParentKnowledgeBaseFolderUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.RelatedContentUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.TaxonomyCategoryUtil;
import com.liferay.knowledge.base.model.KBArticle;
import com.liferay.knowledge.base.service.KBArticleService;
import com.liferay.knowledge.base.service.KBFolderService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.vulcan.util.TransformUtil;
import com.liferay.ratings.kernel.service.RatingsStatsLocalService;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"asset.entry.class.name=com.liferay.knowledge.base.model.KBArticle"}, service={DTOConverter.class, KnowledgeBaseArticleDTOConverter.class})
public class KnowledgeBaseArticleDTOConverter
implements DTOConverter {
    @Reference
    private AssetCategoryLocalService _assetCategoryLocalService;
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;
    @Reference
    private AssetLinkLocalService _assetLinkLocalService;
    @Reference
    private AssetTagLocalService _assetTagLocalService;
    @Reference
    private KBArticleService _kbArticleService;
    @Reference
    private KBFolderService _kbFolderService;
    @Reference
    private Portal _portal;
    @Reference
    private RatingsStatsLocalService _ratingsStatsLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public String getContentType() {
        return KnowledgeBaseArticle.class.getSimpleName();
    }

    public KnowledgeBaseArticle toDTO(final DTOConverterContext dtoConverterContext) throws Exception {
        final KBArticle kbArticle = this._kbArticleService.getLatestKBArticle(dtoConverterContext.getResourcePrimKey(), 0);
        if (kbArticle == null) {
            return null;
        }
        return new KnowledgeBaseArticle(){
            {
                this.aggregateRating = AggregateRatingUtil.toAggregateRating(KnowledgeBaseArticleDTOConverter.this._ratingsStatsLocalService.fetchStats(KBArticle.class.getName(), kbArticle.getResourcePrimKey()));
                this.articleBody = kbArticle.getContent();
                this.creator = CreatorUtil.toCreator(KnowledgeBaseArticleDTOConverter.this._portal, KnowledgeBaseArticleDTOConverter.this._userLocalService.getUser(kbArticle.getUserId()));
                this.customFields = CustomFieldsUtil.toCustomFields(KBArticle.class.getName(), kbArticle.getKbArticleId(), kbArticle.getCompanyId(), dtoConverterContext.getLocale());
                this.dateCreated = kbArticle.getCreateDate();
                this.dateModified = kbArticle.getModifiedDate();
                this.description = kbArticle.getDescription();
                this.encodingFormat = "text/html";
                this.friendlyUrlPath = kbArticle.getUrlTitle();
                this.id = kbArticle.getResourcePrimKey();
                this.keywords = (String[])ListUtil.toArray((List)KnowledgeBaseArticleDTOConverter.this._assetTagLocalService.getTags(KBArticle.class.getName(), kbArticle.getClassPK()), (Accessor)AssetTag.NAME_ACCESSOR);
                this.numberOfAttachments = Optional.ofNullable(kbArticle.getAttachmentsFileEntries()).map(List::size).orElse(0);
                this.numberOfKnowledgeBaseArticles = KnowledgeBaseArticleDTOConverter.this._kbArticleService.getKBArticlesCount(kbArticle.getGroupId(), kbArticle.getResourcePrimKey(), 0);
                this.parentKnowledgeBaseFolderId = kbArticle.getKbFolderId();
                this.relatedContents = RelatedContentUtil.toRelatedContents(KnowledgeBaseArticleDTOConverter.this._assetEntryLocalService, KnowledgeBaseArticleDTOConverter.this._assetLinkLocalService, kbArticle.getModelClassName(), kbArticle.getResourcePrimKey(), dtoConverterContext.getLocale());
                this.siteId = kbArticle.getGroupId();
                this.taxonomyCategories = (TaxonomyCategory[])TransformUtil.transformToArray((Collection)KnowledgeBaseArticleDTOConverter.this._assetCategoryLocalService.getCategories(KBArticle.class.getName(), kbArticle.getClassPK()), TaxonomyCategoryUtil::toTaxonomyCategory, TaxonomyCategory.class);
                this.title = kbArticle.getTitle();
                this.setParentKnowledgeBaseFolder(() -> {
                    if (kbArticle.getKbFolderId() <= 0L) {
                        return null;
                    }
                    return ParentKnowledgeBaseFolderUtil.toParentKnowledgeBaseFolder(KnowledgeBaseArticleDTOConverter.this._kbFolderService.getKBFolder(kbArticle.getKbFolderId()));
                });
            }
        };
    }
}

