/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.dto.v1_0.converter;

import com.liferay.adaptive.media.AMAttribute;
import com.liferay.adaptive.media.AdaptiveMedia;
import com.liferay.adaptive.media.image.finder.AMImageFinder;
import com.liferay.adaptive.media.image.finder.AMImageQueryBuilder;
import com.liferay.adaptive.media.image.mime.type.AMImageMimeTypeProvider;
import com.liferay.adaptive.media.image.processor.AMImageAttribute;
import com.liferay.adaptive.media.image.processor.AMImageProcessor;
import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.model.AssetTag;
import com.liferay.asset.kernel.service.AssetCategoryLocalService;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.asset.kernel.service.AssetLinkLocalService;
import com.liferay.asset.kernel.service.AssetTagLocalService;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.document.library.util.DLURLHelper;
import com.liferay.headless.delivery.dto.v1_0.AdaptedImage;
import com.liferay.headless.delivery.dto.v1_0.Document;
import com.liferay.headless.delivery.dto.v1_0.TaxonomyCategory;
import com.liferay.headless.delivery.dto.v1_0.converter.DTOConverter;
import com.liferay.headless.delivery.dto.v1_0.converter.DTOConverterContext;
import com.liferay.headless.delivery.internal.dto.v1_0.util.AggregateRatingUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.CreatorUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.CustomFieldsUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.RelatedContentUtil;
import com.liferay.portal.kernel.comment.CommentManager;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.vulcan.util.TransformUtil;
import com.liferay.ratings.kernel.service.RatingsStatsLocalService;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"asset.entry.class.name=com.liferay.document.library.kernel.model.DLFileEntry"}, service={DocumentDTOConverter.class, DTOConverter.class})
public class DocumentDTOConverter
implements DTOConverter {
    @Reference
    private AMImageFinder _amImageFinder;
    @Reference
    private AMImageMimeTypeProvider _amImageMimeTypeProvider;
    @Reference
    private AssetCategoryLocalService _assetCategoryLocalService;
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;
    @Reference
    private AssetLinkLocalService _assetLinkLocalService;
    @Reference
    private AssetTagLocalService _assetTagLocalService;
    @Reference
    private CommentManager _commentManager;
    @Reference
    private DLAppService _dlAppService;
    @Reference
    private DLURLHelper _dlURLHelper;
    @Reference
    private Portal _portal;
    @Reference
    private RatingsStatsLocalService _ratingsStatsLocalService;
    @Reference
    private UserLocalService _userService;

    public String getContentType() {
        return Document.class.getSimpleName();
    }

    public Document toDTO(final DTOConverterContext dtoConverterContext) throws Exception {
        final FileEntry fileEntry = this._dlAppService.getFileEntry(dtoConverterContext.getResourcePrimKey());
        final FileVersion fileVersion = fileEntry.getFileVersion();
        final User user = this._userService.getUserById(fileEntry.getUserId());
        return new Document(){
            {
                this.adaptedImages = DocumentDTOConverter.this._getAdaptiveMedias(fileEntry);
                this.aggregateRating = AggregateRatingUtil.toAggregateRating(DocumentDTOConverter.this._ratingsStatsLocalService.fetchStats(DLFileEntry.class.getName(), fileEntry.getFileEntryId()));
                this.contentUrl = DocumentDTOConverter.this._dlURLHelper.getPreviewURL(fileEntry, fileVersion, null, "");
                this.creator = CreatorUtil.toCreator(DocumentDTOConverter.this._portal, user);
                this.customFields = CustomFieldsUtil.toCustomFields(DLFileEntry.class.getName(), fileVersion.getFileVersionId(), fileEntry.getCompanyId(), dtoConverterContext.getLocale());
                this.dateCreated = fileEntry.getCreateDate();
                this.dateModified = fileEntry.getModifiedDate();
                this.description = fileEntry.getDescription();
                this.documentFolderId = fileEntry.getFolderId();
                this.encodingFormat = fileEntry.getMimeType();
                this.fileExtension = fileEntry.getExtension();
                this.id = fileEntry.getFileEntryId();
                this.keywords = (String[])ListUtil.toArray((List)DocumentDTOConverter.this._assetTagLocalService.getTags(DLFileEntry.class.getName(), fileEntry.getFileEntryId()), (Accessor)AssetTag.NAME_ACCESSOR);
                this.numberOfComments = DocumentDTOConverter.this._commentManager.getCommentsCount(DLFileEntry.class.getName(), fileEntry.getFileEntryId());
                this.relatedContents = RelatedContentUtil.toRelatedContents(DocumentDTOConverter.this._assetEntryLocalService, DocumentDTOConverter.this._assetLinkLocalService, DLFileEntry.class.getName(), fileEntry.getFileEntryId(), dtoConverterContext.getLocale());
                this.sizeInBytes = fileEntry.getSize();
                this.taxonomyCategories = (TaxonomyCategory[])TransformUtil.transformToArray((Collection)DocumentDTOConverter.this._assetCategoryLocalService.getCategories(DLFileEntry.class.getName(), fileEntry.getFileEntryId()), assetCategory -> new TaxonomyCategory((AssetCategory)assetCategory){
                    final /* synthetic */ AssetCategory val$assetCategory;
                    {
                        this.val$assetCategory = assetCategory;
                        this.taxonomyCategoryId = this.val$assetCategory.getCategoryId();
                        this.taxonomyCategoryName = this.val$assetCategory.getName();
                    }
                }, TaxonomyCategory.class);
                this.title = fileEntry.getTitle();
            }
        };
    }

    private AdaptedImage[] _getAdaptiveMedias(FileEntry fileEntry) throws Exception {
        if (!this._amImageMimeTypeProvider.isMimeTypeSupported(fileEntry.getMimeType())) {
            return new AdaptedImage[0];
        }
        Stream stream = this._amImageFinder.getAdaptiveMediaStream(amImageQueryBuilder -> amImageQueryBuilder.forFileEntry(fileEntry).withConfigurationStatus(AMImageQueryBuilder.ConfigurationStatus.ANY).done());
        return (AdaptedImage[])stream.map(this::_toAdaptedImage).toArray(AdaptedImage[]::new);
    }

    private <T, S> T _getValue(AdaptiveMedia<S> adaptiveMedia, AMAttribute<S, T> amAttribute) {
        Optional valueOptional = adaptiveMedia.getValueOptional(amAttribute);
        return valueOptional.orElse(null);
    }

    private AdaptedImage _toAdaptedImage(final AdaptiveMedia<AMImageProcessor> adaptiveMedia) {
        return new AdaptedImage(){
            {
                this.contentUrl = String.valueOf(adaptiveMedia.getURI());
                this.height = (int)((Integer)DocumentDTOConverter.this._getValue(adaptiveMedia, AMImageAttribute.AM_IMAGE_ATTRIBUTE_HEIGHT));
                this.resolutionName = (String)DocumentDTOConverter.this._getValue(adaptiveMedia, AMAttribute.getConfigurationUuidAMAttribute());
                this.sizeInBytes = (long)((Long)DocumentDTOConverter.this._getValue(adaptiveMedia, AMAttribute.getContentLengthAMAttribute()));
                this.width = (Integer)DocumentDTOConverter.this._getValue(adaptiveMedia, AMImageAttribute.AM_IMAGE_ATTRIBUTE_WIDTH);
            }
        };
    }
}

