/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.dto.v1_0.converter;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.model.AssetTag;
import com.liferay.asset.kernel.service.AssetCategoryLocalService;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.asset.kernel.service.AssetLinkLocalService;
import com.liferay.asset.kernel.service.AssetTagLocalService;
import com.liferay.blogs.model.BlogsEntry;
import com.liferay.blogs.service.BlogsEntryService;
import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.document.library.util.DLURLHelper;
import com.liferay.headless.delivery.dto.v1_0.BlogPosting;
import com.liferay.headless.delivery.dto.v1_0.Image;
import com.liferay.headless.delivery.dto.v1_0.TaxonomyCategory;
import com.liferay.headless.delivery.dto.v1_0.converter.DTOConverter;
import com.liferay.headless.delivery.dto.v1_0.converter.DTOConverterContext;
import com.liferay.headless.delivery.internal.dto.v1_0.util.AggregateRatingUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.CreatorUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.CustomFieldsUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.RelatedContentUtil;
import com.liferay.portal.kernel.comment.CommentManager;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.vulcan.util.TransformUtil;
import com.liferay.ratings.kernel.service.RatingsStatsLocalService;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.core.Context;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"asset.entry.class.name=com.liferay.blogs.model.BlogsEntry"}, service={BlogPostingDTOConverter.class, DTOConverter.class})
public class BlogPostingDTOConverter
implements DTOConverter {
    @Reference
    private AssetCategoryLocalService _assetCategoryLocalService;
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;
    @Reference
    private AssetLinkLocalService _assetLinkLocalService;
    @Reference
    private AssetTagLocalService _assetTagLocalService;
    @Reference
    private BlogsEntryService _blogsEntryService;
    @Reference
    private CommentManager _commentManager;
    @Reference
    private DLAppService _dlAppService;
    @Reference
    private DLURLHelper _dlURLHelper;
    @Reference
    private Portal _portal;
    @Reference
    private RatingsStatsLocalService _ratingsStatsLocalService;
    @Context
    private User _user;
    @Reference
    private UserLocalService _userLocalService;

    public String getContentType() {
        return BlogPosting.class.getSimpleName();
    }

    public BlogPosting toDTO(final DTOConverterContext dtoConverterContext) throws Exception {
        final BlogsEntry blogsEntry = this._blogsEntryService.getEntry(dtoConverterContext.getResourcePrimKey());
        return new BlogPosting(){
            {
                this.alternativeHeadline = blogsEntry.getSubtitle();
                this.aggregateRating = AggregateRatingUtil.toAggregateRating(BlogPostingDTOConverter.this._ratingsStatsLocalService.fetchStats(BlogsEntry.class.getName(), blogsEntry.getEntryId()));
                this.articleBody = blogsEntry.getContent();
                this.creator = CreatorUtil.toCreator(BlogPostingDTOConverter.this._portal, BlogPostingDTOConverter.this._userLocalService.getUser(blogsEntry.getUserId()));
                this.customFields = CustomFieldsUtil.toCustomFields(BlogsEntry.class.getName(), blogsEntry.getEntryId(), blogsEntry.getCompanyId(), dtoConverterContext.getLocale());
                this.dateCreated = blogsEntry.getCreateDate();
                this.dateModified = blogsEntry.getModifiedDate();
                this.datePublished = blogsEntry.getDisplayDate();
                this.description = blogsEntry.getDescription();
                this.encodingFormat = "text/html";
                this.friendlyUrlPath = blogsEntry.getUrlTitle();
                this.headline = blogsEntry.getTitle();
                this.id = blogsEntry.getEntryId();
                this.image = BlogPostingDTOConverter.this._getImage(blogsEntry);
                this.keywords = (String[])ListUtil.toArray((List)BlogPostingDTOConverter.this._assetTagLocalService.getTags(BlogsEntry.class.getName(), blogsEntry.getEntryId()), (Accessor)AssetTag.NAME_ACCESSOR);
                this.numberOfComments = BlogPostingDTOConverter.this._commentManager.getCommentsCount(BlogsEntry.class.getName(), blogsEntry.getEntryId());
                this.relatedContents = RelatedContentUtil.toRelatedContents(BlogPostingDTOConverter.this._assetEntryLocalService, BlogPostingDTOConverter.this._assetLinkLocalService, blogsEntry.getModelClassName(), blogsEntry.getEntryId(), dtoConverterContext.getLocale());
                this.siteId = blogsEntry.getGroupId();
                this.taxonomyCategories = (TaxonomyCategory[])TransformUtil.transformToArray((Collection)BlogPostingDTOConverter.this._assetCategoryLocalService.getCategories(BlogsEntry.class.getName(), blogsEntry.getEntryId()), assetCategory -> new TaxonomyCategory((AssetCategory)assetCategory){
                    final /* synthetic */ AssetCategory val$assetCategory;
                    {
                        this.val$assetCategory = assetCategory;
                        this.taxonomyCategoryId = this.val$assetCategory.getCategoryId();
                        this.taxonomyCategoryName = this.val$assetCategory.getName();
                    }
                }, TaxonomyCategory.class);
            }
        };
    }

    private Image _getImage(final BlogsEntry blogsEntry) throws Exception {
        final long coverImageFileEntryId = blogsEntry.getCoverImageFileEntryId();
        if (coverImageFileEntryId == 0L) {
            return null;
        }
        final FileEntry fileEntry = this._dlAppService.getFileEntry(coverImageFileEntryId);
        return new Image(){
            {
                this.caption = blogsEntry.getCoverImageCaption();
                this.contentUrl = BlogPostingDTOConverter.this._dlURLHelper.getPreviewURL(fileEntry, fileEntry.getFileVersion(), null, "", false, false);
                this.imageId = coverImageFileEntryId;
            }
        };
    }
}

