/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.resource.v1_0;

import com.liferay.blogs.model.BlogsEntry;
import com.liferay.blogs.service.BlogsEntryService;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.service.DLFileEntryService;
import com.liferay.headless.common.spi.resource.SPICommentResource;
import com.liferay.headless.delivery.dto.v1_0.Comment;
import com.liferay.headless.delivery.internal.dto.v1_0.util.CommentUtil;
import com.liferay.headless.delivery.internal.resource.v1_0.BaseCommentResourceImpl;
import com.liferay.headless.delivery.resource.v1_0.CommentResource;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.service.JournalArticleService;
import com.liferay.message.boards.exception.MessageSubjectException;
import com.liferay.message.boards.model.MBMessage;
import com.liferay.portal.kernel.comment.CommentManager;
import com.liferay.portal.kernel.comment.Discussion;
import com.liferay.portal.kernel.comment.DiscussionComment;
import com.liferay.portal.kernel.comment.DiscussionPermission;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermFilter;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.aggregation.Aggregation;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.resource.EntityModelResource;
import com.liferay.portal.vulcan.util.SearchUtil;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import javax.ws.rs.ClientErrorException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.MultivaluedMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/comment.properties"}, scope=ServiceScope.PROTOTYPE, service={CommentResource.class})
public class CommentResourceImpl
extends BaseCommentResourceImpl
implements EntityModelResource {
    @Reference
    private BlogsEntryService _blogsEntryService;
    @Reference
    private CommentManager _commentManager;
    @Reference
    private DLFileEntryService _dlFileEntryService;
    @Reference
    private JournalArticleService _journalArticleService;
    @Reference
    private Portal _portal;

    @Override
    public void deleteComment(Long commentId) throws Exception {
        SPICommentResource<Comment> spiCommentResource = this._getSPICommentResource();
        spiCommentResource.deleteComment(commentId);
    }

    @Override
    public Page<Comment> getBlogPostingCommentsPage(Long blogPostingId, String search, Aggregation aggregation, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        BlogsEntry blogsEntry = this._blogsEntryService.getEntry(blogPostingId.longValue());
        Discussion discussion = this._commentManager.getDiscussion(blogsEntry.getUserId(), blogsEntry.getGroupId(), BlogsEntry.class.getName(), blogPostingId.longValue(), this._createServiceContextFunction());
        DiscussionComment rootDiscussionComment = discussion.getRootDiscussionComment();
        return this._getComments(HashMapBuilder.put((Object)"add-discussion", this.addAction("ADD_DISCUSSION", blogPostingId, "postBlogPostingComment", blogsEntry.getUserId(), BlogsEntry.class.getName(), blogsEntry.getGroupId())).put((Object)"get", this.addAction("VIEW", blogPostingId, "getBlogPostingCommentsPage", blogsEntry.getUserId(), BlogsEntry.class.getName(), blogsEntry.getGroupId())).build(), rootDiscussionComment.getCommentId(), search, aggregation, filter, pagination, sorts);
    }

    @Override
    public Comment getComment(Long commentId) throws Exception {
        SPICommentResource<Comment> spiCommentResource = this._getSPICommentResource();
        return (Comment)spiCommentResource.getComment(commentId);
    }

    @Override
    public Page<Comment> getCommentCommentsPage(Long parentCommentId, String search, Aggregation aggregation, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return this._getComments(Collections.emptyMap(), parentCommentId, search, aggregation, filter, pagination, sorts);
    }

    @Override
    public Page<Comment> getDocumentCommentsPage(Long documentId, String search, Aggregation aggregation, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        DLFileEntry dlFileEntry = this._dlFileEntryService.getFileEntry(documentId.longValue());
        Discussion discussion = this._commentManager.getDiscussion(dlFileEntry.getUserId(), dlFileEntry.getGroupId(), DLFileEntry.class.getName(), documentId.longValue(), this._createServiceContextFunction());
        DiscussionComment rootDiscussionComment = discussion.getRootDiscussionComment();
        return this._getComments(HashMapBuilder.put((Object)"add-discussion", this.addAction("ADD_DISCUSSION", documentId, "postDocumentComment", dlFileEntry.getUserId(), DLFileEntry.class.getName(), dlFileEntry.getGroupId())).put((Object)"get", this.addAction("VIEW", documentId, "getDocumentCommentsPage", dlFileEntry.getUserId(), DLFileEntry.class.getName(), dlFileEntry.getGroupId())).build(), rootDiscussionComment.getCommentId(), search, aggregation, filter, pagination, sorts);
    }

    @Override
    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) {
        SPICommentResource<Comment> spiCommentResource = this._getSPICommentResource();
        return spiCommentResource.getEntityModel(multivaluedMap);
    }

    @Override
    public Page<Comment> getStructuredContentCommentsPage(Long structuredContentId, String search, Aggregation aggregation, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        JournalArticle journalArticle = this._journalArticleService.getLatestArticle(structuredContentId.longValue());
        Discussion discussion = this._commentManager.getDiscussion(journalArticle.getUserId(), journalArticle.getGroupId(), JournalArticle.class.getName(), structuredContentId.longValue(), this._createServiceContextFunction());
        DiscussionComment rootDiscussionComment = discussion.getRootDiscussionComment();
        return this._getComments(HashMapBuilder.put((Object)"add-discussion", this.addAction("ADD_DISCUSSION", structuredContentId, "postStructuredContentComment", journalArticle.getUserId(), JournalArticle.class.getName(), journalArticle.getGroupId())).put((Object)"get", this.addAction("VIEW", structuredContentId, "getStructuredContentCommentsPage", journalArticle.getUserId(), JournalArticle.class.getName(), journalArticle.getGroupId())).build(), rootDiscussionComment.getCommentId(), search, aggregation, filter, pagination, sorts);
    }

    @Override
    public Comment postBlogPostingComment(Long blogPostingId, Comment comment) throws Exception {
        SPICommentResource<Comment> spiCommentResource = this._getSPICommentResource();
        BlogsEntry blogsEntry = this._blogsEntryService.getEntry(blogPostingId.longValue());
        return (Comment)spiCommentResource.postEntityComment(blogsEntry.getGroupId(), BlogsEntry.class.getName(), blogPostingId.longValue(), comment.getText());
    }

    @Override
    public Comment postCommentComment(Long parentCommentId, Comment comment) throws Exception {
        com.liferay.portal.kernel.comment.Comment parentComment = this._commentManager.fetchComment(parentCommentId.longValue());
        if (parentComment == null) {
            throw new NotFoundException();
        }
        SPICommentResource<Comment> spiCommentResource = this._getSPICommentResource();
        return (Comment)spiCommentResource.postCommentComment(parentComment, comment.getText());
    }

    @Override
    public Comment postDocumentComment(Long documentId, Comment comment) throws Exception {
        SPICommentResource<Comment> spiCommentResource = this._getSPICommentResource();
        DLFileEntry fileEntry = this._dlFileEntryService.getFileEntry(documentId.longValue());
        return (Comment)spiCommentResource.postEntityComment(fileEntry.getGroupId(), DLFileEntry.class.getName(), documentId.longValue(), comment.getText());
    }

    @Override
    public Comment postStructuredContentComment(Long structuredContentId, Comment comment) throws Exception {
        SPICommentResource<Comment> spiCommentResource = this._getSPICommentResource();
        JournalArticle journalArticle = this._journalArticleService.getLatestArticle(structuredContentId.longValue());
        return (Comment)spiCommentResource.postEntityComment(journalArticle.getGroupId(), JournalArticle.class.getName(), structuredContentId.longValue(), comment.getText());
    }

    @Override
    public Comment putComment(Long commentId, Comment comment) throws Exception {
        DiscussionPermission discussionPermission = this._getDiscussionPermission();
        discussionPermission.checkUpdatePermission(commentId.longValue());
        com.liferay.portal.kernel.comment.Comment existingComment = this._commentManager.fetchComment(commentId.longValue());
        try {
            this._commentManager.updateComment(existingComment.getUserId(), existingComment.getClassName(), existingComment.getClassPK(), commentId.longValue(), "", StringBundler.concat((String[])new String[]{"<p>", comment.getText(), "</p>"}), this._createServiceContextFunction());
            return CommentUtil.toComment(this._commentManager.fetchComment(commentId.longValue()), this._commentManager, this._portal);
        }
        catch (MessageSubjectException messageSubjectException) {
            throw new ClientErrorException("Comment text is null", 422, (Throwable)messageSubjectException);
        }
    }

    private Function<String, ServiceContext> _createServiceContextFunction() {
        return className -> {
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setWorkflowAction(1);
            return serviceContext;
        };
    }

    private Page<Comment> _getComments(Map<String, Map<String, String>> actions, Long commentId, String search, Aggregation aggregation, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return SearchUtil.search(actions, booleanQuery -> {
            BooleanFilter booleanFilter = booleanQuery.getPreBooleanFilter();
            booleanFilter.add((Filter)new TermFilter("parentMessageId", String.valueOf(commentId)), BooleanClauseOccur.MUST);
        }, (Filter)filter, MBMessage.class, (String)search, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), searchContext -> {
            searchContext.addVulcanAggregation(aggregation);
            searchContext.setAttribute("discussion", (Serializable)Boolean.TRUE);
            searchContext.setAttribute("searchPermissionContext", (Serializable)((Object)""));
            searchContext.setCompanyId(this.contextCompany.getCompanyId());
            searchContext.setVulcanCheckPermissions(false);
        }, (Sort[])sorts, document -> CommentUtil.toComment(this._commentManager.fetchComment(GetterUtil.getLong((String)document.get("entryClassPK"))), this._commentManager, this._portal));
    }

    private DiscussionPermission _getDiscussionPermission() {
        return this._commentManager.getDiscussionPermission(PermissionThreadLocal.getPermissionChecker());
    }

    private SPICommentResource<Comment> _getSPICommentResource() {
        return new SPICommentResource(this._commentManager, this.contextCompany, comment -> CommentUtil.toComment(comment, this._commentManager, this._portal));
    }
}

