/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.resource.v1_0;

import com.liferay.headless.delivery.dto.v1_0.KnowledgeBaseFolder;
import com.liferay.headless.delivery.resource.v1_0.KnowledgeBaseFolderResource;
import com.liferay.petra.function.UnsafeBiConsumer;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.odata.filter.ExpressionConvert;
import com.liferay.portal.odata.filter.Filter;
import com.liferay.portal.odata.filter.FilterParser;
import com.liferay.portal.odata.filter.FilterParserProvider;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import com.liferay.portal.vulcan.batch.engine.VulcanBatchEngineTaskItemDelegate;
import com.liferay.portal.vulcan.batch.engine.resource.VulcanBatchEngineImportTaskResource;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.resource.EntityModelResource;
import com.liferay.portal.vulcan.util.ActionUtil;
import com.liferay.portal.vulcan.util.TransformUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotSupportedException;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="/v1.0")
public abstract class BaseKnowledgeBaseFolderResourceImpl
implements EntityModelResource,
KnowledgeBaseFolderResource,
VulcanBatchEngineTaskItemDelegate<KnowledgeBaseFolder> {
    protected AcceptLanguage contextAcceptLanguage;
    protected UnsafeBiConsumer<Collection<KnowledgeBaseFolder>, UnsafeConsumer<KnowledgeBaseFolder, Exception>, Exception> contextBatchUnsafeConsumer;
    protected Company contextCompany;
    protected HttpServletRequest contextHttpServletRequest;
    protected HttpServletResponse contextHttpServletResponse;
    protected Object contextScopeChecker;
    protected UriInfo contextUriInfo;
    protected User contextUser;
    protected ExpressionConvert<com.liferay.portal.kernel.search.filter.Filter> expressionConvert;
    protected FilterParserProvider filterParserProvider;
    protected GroupLocalService groupLocalService;
    protected ResourceActionLocalService resourceActionLocalService;
    protected ResourcePermissionLocalService resourcePermissionLocalService;
    protected RoleLocalService roleLocalService;
    protected VulcanBatchEngineImportTaskResource vulcanBatchEngineImportTaskResource;
    private static final Log _log = LogFactoryUtil.getLog(BaseKnowledgeBaseFolderResourceImpl.class);

    @Operation(description="Deletes the knowledge base folder and returns a 204 if the operation succeeds.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="knowledgeBaseFolderId")})
    @Tags(value={@Tag(name="KnowledgeBaseFolder")})
    @DELETE
    @Path(value="/knowledge-base-folders/{knowledgeBaseFolderId}")
    @Produces(value={"application/json", "application/xml"})
    public void deleteKnowledgeBaseFolder(@Parameter(hidden=true) @NotNull @PathParam(value="knowledgeBaseFolderId") Long knowledgeBaseFolderId) throws Exception {
    }

    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Tags(value={@Tag(name="KnowledgeBaseFolder")})
    @Consumes(value={"application/json"})
    @DELETE
    @Path(value="/knowledge-base-folders/batch")
    @Produces(value={"application/json"})
    public Response deleteKnowledgeBaseFolderBatch(@Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.deleteImportTask(KnowledgeBaseFolder.class.getName(), callbackURL, object)).build();
    }

    @Operation(description="Retrieves the knowledge base folder.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="knowledgeBaseFolderId")})
    @Tags(value={@Tag(name="KnowledgeBaseFolder")})
    @GET
    @Path(value="/knowledge-base-folders/{knowledgeBaseFolderId}")
    @Produces(value={"application/json", "application/xml"})
    public KnowledgeBaseFolder getKnowledgeBaseFolder(@Parameter(hidden=true) @NotNull @PathParam(value="knowledgeBaseFolderId") Long knowledgeBaseFolderId) throws Exception {
        return new KnowledgeBaseFolder();
    }

    @Operation(description="Updates only the fields received in the request body, leaving any other fields untouched.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="knowledgeBaseFolderId")})
    @Tags(value={@Tag(name="KnowledgeBaseFolder")})
    @Consumes(value={"application/json", "application/xml"})
    @PATCH
    @Path(value="/knowledge-base-folders/{knowledgeBaseFolderId}")
    @Produces(value={"application/json", "application/xml"})
    public KnowledgeBaseFolder patchKnowledgeBaseFolder(@Parameter(hidden=true) @NotNull @PathParam(value="knowledgeBaseFolderId") Long knowledgeBaseFolderId, KnowledgeBaseFolder knowledgeBaseFolder) throws Exception {
        KnowledgeBaseFolder existingKnowledgeBaseFolder = this.getKnowledgeBaseFolder(knowledgeBaseFolderId);
        if (knowledgeBaseFolder.getActions() != null) {
            existingKnowledgeBaseFolder.setActions(knowledgeBaseFolder.getActions());
        }
        if (knowledgeBaseFolder.getDateCreated() != null) {
            existingKnowledgeBaseFolder.setDateCreated(knowledgeBaseFolder.getDateCreated());
        }
        if (knowledgeBaseFolder.getDateModified() != null) {
            existingKnowledgeBaseFolder.setDateModified(knowledgeBaseFolder.getDateModified());
        }
        if (knowledgeBaseFolder.getDescription() != null) {
            existingKnowledgeBaseFolder.setDescription(knowledgeBaseFolder.getDescription());
        }
        if (knowledgeBaseFolder.getName() != null) {
            existingKnowledgeBaseFolder.setName(knowledgeBaseFolder.getName());
        }
        if (knowledgeBaseFolder.getNumberOfKnowledgeBaseArticles() != null) {
            existingKnowledgeBaseFolder.setNumberOfKnowledgeBaseArticles(knowledgeBaseFolder.getNumberOfKnowledgeBaseArticles());
        }
        if (knowledgeBaseFolder.getNumberOfKnowledgeBaseFolders() != null) {
            existingKnowledgeBaseFolder.setNumberOfKnowledgeBaseFolders(knowledgeBaseFolder.getNumberOfKnowledgeBaseFolders());
        }
        if (knowledgeBaseFolder.getParentKnowledgeBaseFolderId() != null) {
            existingKnowledgeBaseFolder.setParentKnowledgeBaseFolderId(knowledgeBaseFolder.getParentKnowledgeBaseFolderId());
        }
        if (knowledgeBaseFolder.getSiteId() != null) {
            existingKnowledgeBaseFolder.setSiteId(knowledgeBaseFolder.getSiteId());
        }
        if (knowledgeBaseFolder.getViewableBy() != null) {
            existingKnowledgeBaseFolder.setViewableBy(knowledgeBaseFolder.getViewableBy());
        }
        this.preparePatch(knowledgeBaseFolder, existingKnowledgeBaseFolder);
        return this.putKnowledgeBaseFolder(knowledgeBaseFolderId, existingKnowledgeBaseFolder);
    }

    @Operation(description="Replaces the knowledge base folder with the information sent in the request body. Any missing fields are deleted, unless they are required.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="knowledgeBaseFolderId")})
    @Tags(value={@Tag(name="KnowledgeBaseFolder")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/knowledge-base-folders/{knowledgeBaseFolderId}")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    public KnowledgeBaseFolder putKnowledgeBaseFolder(@Parameter(hidden=true) @NotNull @PathParam(value="knowledgeBaseFolderId") Long knowledgeBaseFolderId, KnowledgeBaseFolder knowledgeBaseFolder) throws Exception {
        return new KnowledgeBaseFolder();
    }

    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Tags(value={@Tag(name="KnowledgeBaseFolder")})
    @Consumes(value={"application/json"})
    @Path(value="/knowledge-base-folders/batch")
    @Produces(value={"application/json"})
    @PUT
    public Response putKnowledgeBaseFolderBatch(@Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.putImportTask(KnowledgeBaseFolder.class.getName(), callbackURL, object)).build();
    }

    @Operation(description="Retrieves the knowledge base folder's subfolders.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="parentKnowledgeBaseFolderId"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize")})
    @Tags(value={@Tag(name="KnowledgeBaseFolder")})
    @GET
    @Path(value="/knowledge-base-folders/{parentKnowledgeBaseFolderId}/knowledge-base-folders")
    @Produces(value={"application/json", "application/xml"})
    public Page<KnowledgeBaseFolder> getKnowledgeBaseFolderKnowledgeBaseFoldersPage(@Parameter(hidden=true) @NotNull @PathParam(value="parentKnowledgeBaseFolderId") Long parentKnowledgeBaseFolderId, @Context Pagination pagination) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Operation(description="Creates a knowledge base folder inside the parent folder.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="parentKnowledgeBaseFolderId")})
    @Tags(value={@Tag(name="KnowledgeBaseFolder")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/knowledge-base-folders/{parentKnowledgeBaseFolderId}/knowledge-base-folders")
    @POST
    @Produces(value={"application/json", "application/xml"})
    public KnowledgeBaseFolder postKnowledgeBaseFolderKnowledgeBaseFolder(@Parameter(hidden=true) @NotNull @PathParam(value="parentKnowledgeBaseFolderId") Long parentKnowledgeBaseFolderId, KnowledgeBaseFolder knowledgeBaseFolder) throws Exception {
        return new KnowledgeBaseFolder();
    }

    @Operation(description="Retrieves the site's knowledge base folders. Results can be paginated.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize")})
    @Tags(value={@Tag(name="KnowledgeBaseFolder")})
    @GET
    @Path(value="/sites/{siteId}/knowledge-base-folders")
    @Produces(value={"application/json", "application/xml"})
    public Page<KnowledgeBaseFolder> getSiteKnowledgeBaseFoldersPage(@Parameter(hidden=true) @NotNull @PathParam(value="siteId") Long siteId, @Context Pagination pagination) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Operation(description="Creates a new knowledge base folder.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId")})
    @Tags(value={@Tag(name="KnowledgeBaseFolder")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/sites/{siteId}/knowledge-base-folders")
    @POST
    @Produces(value={"application/json", "application/xml"})
    public KnowledgeBaseFolder postSiteKnowledgeBaseFolder(@Parameter(hidden=true) @NotNull @PathParam(value="siteId") Long siteId, KnowledgeBaseFolder knowledgeBaseFolder) throws Exception {
        return new KnowledgeBaseFolder();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId"), @Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Tags(value={@Tag(name="KnowledgeBaseFolder")})
    @Consumes(value={"application/json"})
    @Path(value="/sites/{siteId}/knowledge-base-folders/batch")
    @POST
    @Produces(value={"application/json"})
    public Response postSiteKnowledgeBaseFolderBatch(@Parameter(hidden=true) @NotNull @PathParam(value="siteId") Long siteId, @Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.postImportTask(KnowledgeBaseFolder.class.getName(), callbackURL, null, object)).build();
    }

    public void create(Collection<KnowledgeBaseFolder> knowledgeBaseFolders, Map<String, Serializable> parameters) throws Exception {
        UnsafeConsumer knowledgeBaseFolderUnsafeConsumer = null;
        String createStrategy = (String)((Object)parameters.getOrDefault("createStrategy", (Serializable)((Object)"INSERT")));
        if ("INSERT".equalsIgnoreCase(createStrategy)) {
            if (parameters.containsKey("siteId")) {
                knowledgeBaseFolderUnsafeConsumer = knowledgeBaseFolder -> this.postSiteKnowledgeBaseFolder((Long)parameters.get("siteId"), (KnowledgeBaseFolder)knowledgeBaseFolder);
            } else {
                throw new NotSupportedException("One of the following parameters must be specified: [siteId]");
            }
        }
        if (knowledgeBaseFolderUnsafeConsumer == null) {
            throw new NotSupportedException("Create strategy \"" + createStrategy + "\" is not supported for KnowledgeBaseFolder");
        }
        if (this.contextBatchUnsafeConsumer != null) {
            this.contextBatchUnsafeConsumer.accept(knowledgeBaseFolders, (Object)knowledgeBaseFolderUnsafeConsumer);
        } else {
            for (KnowledgeBaseFolder knowledgeBaseFolder2 : knowledgeBaseFolders) {
                knowledgeBaseFolderUnsafeConsumer.accept((Object)knowledgeBaseFolder2);
            }
        }
    }

    public void delete(Collection<KnowledgeBaseFolder> knowledgeBaseFolders, Map<String, Serializable> parameters) throws Exception {
        for (KnowledgeBaseFolder knowledgeBaseFolder : knowledgeBaseFolders) {
            this.deleteKnowledgeBaseFolder(knowledgeBaseFolder.getId());
        }
    }

    public Set<String> getAvailableCreateStrategies() {
        return SetUtil.fromArray((Object[])new String[]{"INSERT"});
    }

    public Set<String> getAvailableUpdateStrategies() {
        return SetUtil.fromArray((Object[])new String[]{"PARTIAL_UPDATE", "UPDATE"});
    }

    public EntityModel getEntityModel(Map<String, List<String>> multivaluedMap) throws Exception {
        return this.getEntityModel((MultivaluedMap)new MultivaluedHashMap(multivaluedMap));
    }

    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) throws Exception {
        return null;
    }

    public String getVersion() {
        return "v1.0";
    }

    public Page<KnowledgeBaseFolder> read(com.liferay.portal.kernel.search.filter.Filter filter, Pagination pagination, Sort[] sorts, Map<String, Serializable> parameters, String search) throws Exception {
        if (parameters.containsKey("siteId")) {
            return this.getSiteKnowledgeBaseFoldersPage((Long)parameters.get("siteId"), pagination);
        }
        throw new NotSupportedException("One of the following parameters must be specified: [siteId]");
    }

    public void setLanguageId(final String languageId) {
        this.contextAcceptLanguage = new AcceptLanguage(){

            public List<Locale> getLocales() {
                return null;
            }

            public String getPreferredLanguageId() {
                return languageId;
            }

            public Locale getPreferredLocale() {
                return LocaleUtil.fromLanguageId((String)languageId);
            }
        };
    }

    public void update(Collection<KnowledgeBaseFolder> knowledgeBaseFolders, Map<String, Serializable> parameters) throws Exception {
        UnsafeConsumer knowledgeBaseFolderUnsafeConsumer = null;
        String updateStrategy = (String)((Object)parameters.getOrDefault("updateStrategy", (Serializable)((Object)"UPDATE")));
        if ("PARTIAL_UPDATE".equalsIgnoreCase(updateStrategy)) {
            knowledgeBaseFolderUnsafeConsumer = knowledgeBaseFolder -> this.patchKnowledgeBaseFolder(knowledgeBaseFolder.getId() != null ? knowledgeBaseFolder.getId() : Long.parseLong((String)parameters.get("knowledgeBaseFolderId")), (KnowledgeBaseFolder)knowledgeBaseFolder);
        }
        if ("UPDATE".equalsIgnoreCase(updateStrategy)) {
            knowledgeBaseFolderUnsafeConsumer = knowledgeBaseFolder -> this.putKnowledgeBaseFolder(knowledgeBaseFolder.getId() != null ? knowledgeBaseFolder.getId() : Long.parseLong((String)parameters.get("knowledgeBaseFolderId")), (KnowledgeBaseFolder)knowledgeBaseFolder);
        }
        if (knowledgeBaseFolderUnsafeConsumer == null) {
            throw new NotSupportedException("Update strategy \"" + updateStrategy + "\" is not supported for KnowledgeBaseFolder");
        }
        if (this.contextBatchUnsafeConsumer != null) {
            this.contextBatchUnsafeConsumer.accept(knowledgeBaseFolders, (Object)knowledgeBaseFolderUnsafeConsumer);
        } else {
            for (KnowledgeBaseFolder knowledgeBaseFolder2 : knowledgeBaseFolders) {
                knowledgeBaseFolderUnsafeConsumer.accept((Object)knowledgeBaseFolder2);
            }
        }
    }

    public void setContextAcceptLanguage(AcceptLanguage contextAcceptLanguage) {
        this.contextAcceptLanguage = contextAcceptLanguage;
    }

    public void setContextBatchUnsafeConsumer(UnsafeBiConsumer<Collection<KnowledgeBaseFolder>, UnsafeConsumer<KnowledgeBaseFolder, Exception>, Exception> contextBatchUnsafeConsumer) {
        this.contextBatchUnsafeConsumer = contextBatchUnsafeConsumer;
    }

    public void setContextCompany(Company contextCompany) {
        this.contextCompany = contextCompany;
    }

    public void setContextHttpServletRequest(HttpServletRequest contextHttpServletRequest) {
        this.contextHttpServletRequest = contextHttpServletRequest;
    }

    public void setContextHttpServletResponse(HttpServletResponse contextHttpServletResponse) {
        this.contextHttpServletResponse = contextHttpServletResponse;
    }

    public void setContextUriInfo(UriInfo contextUriInfo) {
        this.contextUriInfo = contextUriInfo;
    }

    public void setContextUser(User contextUser) {
        this.contextUser = contextUser;
    }

    public void setExpressionConvert(ExpressionConvert<com.liferay.portal.kernel.search.filter.Filter> expressionConvert) {
        this.expressionConvert = expressionConvert;
    }

    public void setFilterParserProvider(FilterParserProvider filterParserProvider) {
        this.filterParserProvider = filterParserProvider;
    }

    public void setGroupLocalService(GroupLocalService groupLocalService) {
        this.groupLocalService = groupLocalService;
    }

    public void setResourceActionLocalService(ResourceActionLocalService resourceActionLocalService) {
        this.resourceActionLocalService = resourceActionLocalService;
    }

    public void setResourcePermissionLocalService(ResourcePermissionLocalService resourcePermissionLocalService) {
        this.resourcePermissionLocalService = resourcePermissionLocalService;
    }

    public void setRoleLocalService(RoleLocalService roleLocalService) {
        this.roleLocalService = roleLocalService;
    }

    public void setVulcanBatchEngineImportTaskResource(VulcanBatchEngineImportTaskResource vulcanBatchEngineImportTaskResource) {
        this.vulcanBatchEngineImportTaskResource = vulcanBatchEngineImportTaskResource;
    }

    public com.liferay.portal.kernel.search.filter.Filter toFilter(String filterString, Map<String, List<String>> multivaluedMap) {
        try {
            EntityModel entityModel = this.getEntityModel(multivaluedMap);
            FilterParser filterParser = this.filterParserProvider.provide(entityModel);
            Filter oDataFilter = new Filter(filterParser.parse(filterString));
            return (com.liferay.portal.kernel.search.filter.Filter)this.expressionConvert.convert(oDataFilter.getExpression(), this.contextAcceptLanguage.getPreferredLocale(), entityModel);
        }
        catch (Exception exception) {
            _log.error((Object)("Invalid filter " + filterString), (Throwable)exception);
            return null;
        }
    }

    protected Map<String, String> addAction(String actionName, GroupedModel groupedModel, String methodName) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (GroupedModel)groupedModel, (String)methodName, (Object)this.contextScopeChecker, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, Long id, String methodName, Long ownerId, String permissionName, Long siteId) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (Long)id, (String)methodName, (Object)this.contextScopeChecker, (Long)ownerId, (String)permissionName, (Long)siteId, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, Long id, String methodName, ModelResourcePermission modelResourcePermission) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (Long)id, (String)methodName, (Object)this.contextScopeChecker, (ModelResourcePermission)modelResourcePermission, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, String methodName, String permissionName, Long siteId) {
        return this.addAction(actionName, siteId, methodName, null, permissionName, siteId);
    }

    protected void preparePatch(KnowledgeBaseFolder knowledgeBaseFolder, KnowledgeBaseFolder existingKnowledgeBaseFolder) {
    }

    protected <T, R, E extends Throwable> List<R> transform(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) {
        return TransformUtil.transform(collection, unsafeFunction);
    }

    protected <T, R, E extends Throwable> R[] transform(T[] array, UnsafeFunction<T, R, E> unsafeFunction, Class<?> clazz) {
        return TransformUtil.transform((Object[])array, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> R[] transformToArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction, Class<?> clazz) {
        return TransformUtil.transformToArray(collection, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> List<R> transformToList(T[] array, UnsafeFunction<T, R, E> unsafeFunction) {
        return TransformUtil.transformToList((Object[])array, unsafeFunction);
    }

    protected <T, R, E extends Throwable> List<R> unsafeTransform(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransform(collection, unsafeFunction);
    }

    protected <T, R, E extends Throwable> R[] unsafeTransform(T[] array, UnsafeFunction<T, R, E> unsafeFunction, Class<?> clazz) throws E {
        return TransformUtil.unsafeTransform((Object[])array, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> R[] unsafeTransformToArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction, Class<?> clazz) throws E {
        return TransformUtil.unsafeTransformToArray(collection, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> List<R> unsafeTransformToList(T[] array, UnsafeFunction<T, R, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransformToList((Object[])array, unsafeFunction);
    }
}

