/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.dto.v1_0.converter;

import com.liferay.asset.kernel.model.AssetTag;
import com.liferay.asset.kernel.service.AssetCategoryLocalService;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.asset.kernel.service.AssetLinkLocalService;
import com.liferay.asset.kernel.service.AssetTagLocalService;
import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.document.library.util.DLURLHelper;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLocalService;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.storage.Fields;
import com.liferay.dynamic.data.mapping.util.FieldsToDDMFormValuesConverter;
import com.liferay.headless.delivery.dto.v1_0.ContentField;
import com.liferay.headless.delivery.dto.v1_0.RenderedContent;
import com.liferay.headless.delivery.dto.v1_0.StructuredContent;
import com.liferay.headless.delivery.dto.v1_0.TaxonomyCategoryBrief;
import com.liferay.headless.delivery.internal.dto.v1_0.util.AggregateRatingUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.ContentFieldUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.CreatorUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.CustomFieldsUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.RelatedContentUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.RenderedContentValueUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.TaxonomyCategoryBriefUtil;
import com.liferay.headless.delivery.internal.resource.v1_0.BaseStructuredContentResourceImpl;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.service.JournalArticleService;
import com.liferay.journal.util.JournalContent;
import com.liferay.journal.util.JournalConverter;
import com.liferay.portal.kernel.comment.CommentManager;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.util.JaxRsLinkUtil;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import com.liferay.portal.vulcan.util.TransformUtil;
import com.liferay.ratings.kernel.service.RatingsStatsLocalService;
import com.liferay.subscription.service.SubscriptionLocalService;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.UriInfo;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.journal.model.JournalArticle"}, service={DTOConverter.class, StructuredContentDTOConverter.class})
public class StructuredContentDTOConverter
implements DTOConverter<JournalArticle, StructuredContent> {
    @Reference
    private AssetCategoryLocalService _assetCategoryLocalService;
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;
    @Reference
    private AssetLinkLocalService _assetLinkLocalService;
    @Reference
    private AssetTagLocalService _assetTagLocalService;
    @Reference
    private CommentManager _commentManager;
    @Reference
    private DDMTemplateLocalService _ddmTemplateLocalService;
    @Reference
    private DLAppService _dlAppService;
    @Reference
    private DLURLHelper _dlURLHelper;
    @Reference
    private FieldsToDDMFormValuesConverter _fieldsToDDMFormValuesConverter;
    @Reference
    private JournalArticleService _journalArticleService;
    @Reference
    private JournalContent _journalContent;
    @Reference
    private JournalConverter _journalConverter;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private RatingsStatsLocalService _ratingsStatsLocalService;
    @Reference
    private SubscriptionLocalService _subscriptionLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public String getContentType() {
        return StructuredContent.class.getSimpleName();
    }

    public StructuredContent toDTO(final DTOConverterContext dtoConverterContext) throws Exception {
        final JournalArticle journalArticle = this._journalArticleService.getLatestArticle(((Long)dtoConverterContext.getId()).longValue());
        final DDMStructure ddmStructure = journalArticle.getDDMStructure();
        return new StructuredContent(){
            {
                this.actions = dtoConverterContext.getActions();
                this.aggregateRating = AggregateRatingUtil.toAggregateRating(StructuredContentDTOConverter.this._ratingsStatsLocalService.fetchStats(JournalArticle.class.getName(), journalArticle.getResourcePrimKey()));
                this.availableLanguages = LocaleUtil.toW3cLanguageIds((String[])journalArticle.getAvailableLanguageIds());
                this.contentFields = StructuredContentDTOConverter.this._toContentFields(StructuredContentDTOConverter.this._dlAppService, StructuredContentDTOConverter.this._dlURLHelper, dtoConverterContext, StructuredContentDTOConverter.this._fieldsToDDMFormValuesConverter, journalArticle, StructuredContentDTOConverter.this._journalArticleService, StructuredContentDTOConverter.this._journalConverter, StructuredContentDTOConverter.this._layoutLocalService);
                this.contentStructureId = ddmStructure.getStructureId();
                this.creator = CreatorUtil.toCreator(StructuredContentDTOConverter.this._portal, dtoConverterContext.getUriInfoOptional(), StructuredContentDTOConverter.this._userLocalService.fetchUser(journalArticle.getUserId()));
                this.customFields = CustomFieldsUtil.toCustomFields(dtoConverterContext.isAcceptAllLanguages(), JournalArticle.class.getName(), journalArticle.getId(), journalArticle.getCompanyId(), dtoConverterContext.getLocale());
                this.dateCreated = journalArticle.getCreateDate();
                this.dateModified = journalArticle.getModifiedDate();
                this.datePublished = journalArticle.getDisplayDate();
                this.description = journalArticle.getDescription(dtoConverterContext.getLocale());
                this.description_i18n = LocalizedMapUtil.getI18nMap((boolean)dtoConverterContext.isAcceptAllLanguages(), (Map)StructuredContentDTOConverter.this._filterDescriptionMap(journalArticle.getDescriptionMap()));
                this.friendlyUrlPath = journalArticle.getUrlTitle(dtoConverterContext.getLocale());
                this.friendlyUrlPath_i18n = LocalizedMapUtil.getI18nMap((boolean)dtoConverterContext.isAcceptAllLanguages(), (Map)journalArticle.getFriendlyURLMap());
                this.id = journalArticle.getResourcePrimKey();
                this.key = journalArticle.getArticleId();
                this.keywords = (String[])ListUtil.toArray((List)StructuredContentDTOConverter.this._assetTagLocalService.getTags(JournalArticle.class.getName(), journalArticle.getResourcePrimKey()), (Accessor)AssetTag.NAME_ACCESSOR);
                this.numberOfComments = StructuredContentDTOConverter.this._commentManager.getCommentsCount(JournalArticle.class.getName(), journalArticle.getResourcePrimKey());
                this.relatedContents = RelatedContentUtil.toRelatedContents(StructuredContentDTOConverter.this._assetEntryLocalService, StructuredContentDTOConverter.this._assetLinkLocalService, dtoConverterContext.getDTOConverterRegistry(), JournalArticle.class.getName(), journalArticle.getResourcePrimKey(), dtoConverterContext.getLocale());
                this.renderedContents = StructuredContentDTOConverter.this._toRenderedContents(dtoConverterContext.isAcceptAllLanguages(), ddmStructure, dtoConverterContext.getHttpServletRequest(), journalArticle, dtoConverterContext.getLocale(), dtoConverterContext.getUriInfoOptional());
                this.siteId = journalArticle.getGroupId();
                this.subscribed = StructuredContentDTOConverter.this._subscriptionLocalService.isSubscribed(journalArticle.getCompanyId(), dtoConverterContext.getUserId(), JournalArticle.class.getName(), journalArticle.getResourcePrimKey());
                this.taxonomyCategoryBriefs = (TaxonomyCategoryBrief[])TransformUtil.transformToArray((Collection)StructuredContentDTOConverter.this._assetCategoryLocalService.getCategories(JournalArticle.class.getName(), journalArticle.getResourcePrimKey()), assetCategory -> TaxonomyCategoryBriefUtil.toTaxonomyCategoryBrief(assetCategory, dtoConverterContext), TaxonomyCategoryBrief.class);
                this.title = journalArticle.getTitle(dtoConverterContext.getLocale());
                this.title_i18n = LocalizedMapUtil.getI18nMap((boolean)dtoConverterContext.isAcceptAllLanguages(), (Map)journalArticle.getTitleMap());
                this.uuid = journalArticle.getUuid();
            }
        };
    }

    private Map<Locale, String> _filterDescriptionMap(Map<Locale, String> descriptionMap) {
        Set<Map.Entry<Locale, String>> set = descriptionMap.entrySet();
        Stream stream = set.stream();
        return stream.filter(entry -> !"".equals(entry.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private ContentField[] _toContentFields(DLAppService dlAppService, DLURLHelper dlURLHelper, DTOConverterContext dtoConverterContext, FieldsToDDMFormValuesConverter fieldsToDDMFormValuesConverter, JournalArticle journalArticle, JournalArticleService journalArticleService, JournalConverter journalConverter, LayoutLocalService layoutLocalService) throws Exception {
        DDMStructure ddmStructure = journalArticle.getDDMStructure();
        Fields fields = journalConverter.getDDMFields(ddmStructure, journalArticle.getContent());
        DDMFormValues ddmFormValues = fieldsToDDMFormValuesConverter.convert(ddmStructure, fields);
        return (ContentField[])TransformUtil.transformToArray((Collection)ddmFormValues.getDDMFormFieldValues(), ddmFormFieldValue -> ContentFieldUtil.toContentField(ddmFormFieldValue, dlAppService, dlURLHelper, dtoConverterContext, journalArticleService, layoutLocalService), ContentField.class);
    }

    private RenderedContent[] _toRenderedContents(boolean acceptAllLanguages, DDMStructure ddmStructure, HttpServletRequest httpServletRequest, final JournalArticle journalArticle, Locale locale, Optional<UriInfo> uriInfoOptional) {
        if (!uriInfoOptional.isPresent()) {
            return null;
        }
        final UriInfo uriInfo = uriInfoOptional.get();
        return (RenderedContent[])TransformUtil.transformToArray((Collection)ddmStructure.getTemplates(), ddmTemplate -> new RenderedContent((DDMTemplate)ddmTemplate, locale, acceptAllLanguages, uriInfoOptional, httpServletRequest){
            final /* synthetic */ DDMTemplate val$ddmTemplate;
            final /* synthetic */ Locale val$locale;
            final /* synthetic */ boolean val$acceptAllLanguages;
            final /* synthetic */ Optional val$uriInfoOptional;
            final /* synthetic */ HttpServletRequest val$httpServletRequest;
            {
                this.val$ddmTemplate = dDMTemplate;
                this.val$locale = locale;
                this.val$acceptAllLanguages = bl;
                this.val$uriInfoOptional = optional;
                this.val$httpServletRequest = httpServletRequest;
                this.renderedContentURL = JaxRsLinkUtil.getJaxRsLink((String)"headless-delivery", BaseStructuredContentResourceImpl.class, (String)"getStructuredContentRenderedContentTemplate", (UriInfo)uriInfo, (Object[])new Object[]{journalArticle.getResourcePrimKey(), this.val$ddmTemplate.getTemplateId()});
                this.templateName = this.val$ddmTemplate.getName(this.val$locale);
                this.templateName_i18n = LocalizedMapUtil.getI18nMap((boolean)this.val$acceptAllLanguages, (Map)this.val$ddmTemplate.getNameMap());
                this.setRenderedContentValue(() -> {
                    if (!this.val$uriInfoOptional.map(UriInfo::getQueryParameters).map(parameters -> (String)parameters.getFirst((Object)"nestedFields")).map(fields -> fields.contains("renderedContentValue")).orElse(false).booleanValue()) {
                        return null;
                    }
                    return RenderedContentValueUtil.renderTemplate(StructuredContentDTOConverter.this._ddmTemplateLocalService, this.val$httpServletRequest, StructuredContentDTOConverter.this._journalArticleService, StructuredContentDTOConverter.this._journalContent, this.val$locale, journalArticle.getResourcePrimKey(), this.val$ddmTemplate.getTemplateId(), uriInfo);
                });
            }
        }, RenderedContent.class);
    }
}

