/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.search.filter;

import com.liferay.dynamic.data.mapping.util.DDMIndexer;
import com.liferay.headless.delivery.dynamic.data.mapping.DDMStructureField;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.BooleanClause;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.QueryTerm;
import com.liferay.portal.kernel.search.TermQuery;
import com.liferay.portal.kernel.search.TermRangeQuery;
import com.liferay.portal.kernel.search.WildcardQuery;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.DateRangeTermFilter;
import com.liferay.portal.kernel.search.filter.ExistsFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.FilterVisitor;
import com.liferay.portal.kernel.search.filter.GeoBoundingBoxFilter;
import com.liferay.portal.kernel.search.filter.GeoDistanceFilter;
import com.liferay.portal.kernel.search.filter.GeoDistanceRangeFilter;
import com.liferay.portal.kernel.search.filter.GeoPolygonFilter;
import com.liferay.portal.kernel.search.filter.MissingFilter;
import com.liferay.portal.kernel.search.filter.PrefixFilter;
import com.liferay.portal.kernel.search.filter.QueryFilter;
import com.liferay.portal.kernel.search.filter.RangeTermFilter;
import com.liferay.portal.kernel.search.filter.TermFilter;
import com.liferay.portal.kernel.search.filter.TermsFilter;
import com.liferay.portal.kernel.search.generic.BooleanQueryImpl;
import com.liferay.portal.kernel.search.generic.NestedQuery;
import com.liferay.portal.kernel.search.generic.TermQueryImpl;
import com.liferay.portal.kernel.search.generic.TermRangeQueryImpl;
import com.liferay.portal.kernel.search.generic.WildcardQueryImpl;
import java.util.List;
import java.util.function.Function;

public class FilterUtil {
    private static final Log _log = LogFactoryUtil.getLog(FilterUtil.class);
    private static final FilterVisitor<Filter> _ddmFilterVisitor = new DDMFilterVisitor();

    public static Filter processFilter(DDMIndexer ddmIndexer, Filter filter) {
        if (filter == null || ddmIndexer.isLegacyDDMIndexFieldsEnabled()) {
            return filter;
        }
        return (Filter)filter.accept(_ddmFilterVisitor);
    }

    private static class DDMFilterVisitor
    implements FilterVisitor<Filter> {
        private DDMFilterVisitor() {
        }

        public Filter visit(BooleanFilter booleanFilter1) {
            BooleanFilter booleanFilter2 = new BooleanFilter();
            this._addBooleanClauses(booleanFilter1.getMustBooleanClauses(), BooleanClauseOccur.MUST, booleanFilter2);
            this._addBooleanClauses(booleanFilter1.getMustNotBooleanClauses(), BooleanClauseOccur.MUST_NOT, booleanFilter2);
            this._addBooleanClauses(booleanFilter1.getShouldBooleanClauses(), BooleanClauseOccur.SHOULD, booleanFilter2);
            return booleanFilter2;
        }

        public Filter visit(DateRangeTermFilter dateRangeTermFilter) {
            return dateRangeTermFilter;
        }

        public Filter visit(ExistsFilter existsFilter) {
            return existsFilter;
        }

        public Filter visit(GeoBoundingBoxFilter geoBoundingBoxFilter) {
            return geoBoundingBoxFilter;
        }

        public Filter visit(GeoDistanceFilter geoDistanceFilter) {
            return geoDistanceFilter;
        }

        public Filter visit(GeoDistanceRangeFilter geoDistanceRangeFilter) {
            return geoDistanceRangeFilter;
        }

        public Filter visit(GeoPolygonFilter geoPolygonFilter) {
            return geoPolygonFilter;
        }

        public Filter visit(MissingFilter missingFilter) {
            return missingFilter;
        }

        public Filter visit(PrefixFilter prefixFilter) {
            return prefixFilter;
        }

        public Filter visit(QueryFilter queryFilter) {
            Query query = queryFilter.getQuery();
            if (query instanceof TermQuery) {
                TermQuery termQuery = (TermQuery)query;
                QueryTerm queryTerm = termQuery.getQueryTerm();
                return this._createNestedQueryFilter(queryTerm.getField(), (Filter)queryFilter, nestedFieldName -> new TermQueryImpl(nestedFieldName, queryTerm.getValue()));
            }
            if (query instanceof TermRangeQuery) {
                TermRangeQuery termRangeQuery = (TermRangeQuery)query;
                return this._createNestedQueryFilter(termRangeQuery.getField(), (Filter)queryFilter, nestedFieldName -> new TermRangeQueryImpl(nestedFieldName, termRangeQuery.getLowerTerm(), termRangeQuery.getUpperTerm(), termRangeQuery.includesLower(), termRangeQuery.includesUpper()));
            }
            if (query instanceof WildcardQuery) {
                WildcardQuery wildcardQuery = (WildcardQuery)query;
                QueryTerm queryTerm = wildcardQuery.getQueryTerm();
                return this._createNestedQueryFilter(queryTerm.getField(), (Filter)queryFilter, nestedFieldName -> new WildcardQueryImpl(nestedFieldName, queryTerm.getValue()));
            }
            return queryFilter;
        }

        public Filter visit(RangeTermFilter rangeTermFilter) {
            return this._createNestedQueryFilter(rangeTermFilter.getField(), (Filter)rangeTermFilter, nestedFieldName -> new TermRangeQueryImpl(nestedFieldName, rangeTermFilter.getLowerBound(), rangeTermFilter.getUpperBound(), rangeTermFilter.isIncludesLower(), rangeTermFilter.isIncludesUpper()));
        }

        public Filter visit(TermFilter termFilter) {
            return this._createNestedQueryFilter(termFilter.getField(), (Filter)termFilter, nestedFieldName -> new TermQueryImpl(nestedFieldName, termFilter.getValue()));
        }

        public Filter visit(TermsFilter termsFilter) {
            return termsFilter;
        }

        private void _addBooleanClauses(List<BooleanClause<Filter>> booleanClauses, BooleanClauseOccur booleanClauseOccur, BooleanFilter booleanFilter) {
            for (BooleanClause<Filter> booleanClause : booleanClauses) {
                Filter filter = (Filter)booleanClause.getClause();
                booleanFilter.add((Filter)filter.accept((FilterVisitor)this), booleanClauseOccur);
            }
        }

        private Filter _createNestedQueryFilter(String fieldName, Filter originalQueryFilter, Function<String, Query> queryFunction) {
            if (!fieldName.startsWith("ddm__")) {
                return originalQueryFilter;
            }
            try {
                BooleanQueryImpl booleanQuery = new BooleanQueryImpl();
                DDMStructureField ddmStructureField = DDMStructureField.from(fieldName);
                booleanQuery.add(queryFunction.apply(ddmStructureField.getDDMStructureNestedTypeSortableFieldName()), BooleanClauseOccur.MUST);
                booleanQuery.addRequiredTerm(StringBundler.concat((String[])new String[]{"ddmFieldArray", ".", "ddmFieldName"}), ddmStructureField.getDDMStructureFieldName());
                return new QueryFilter((Query)new NestedQuery("ddmFieldArray", (Query)booleanQuery));
            }
            catch (Exception exception) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Throwable)exception);
                }
                return originalQueryFilter;
            }
        }
    }
}

