/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.dto.v1_0.util;

import com.liferay.headless.delivery.dto.v1_0.Creator;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.Portal;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;

public class CreatorUtil {
    public static Creator toCreator(final Portal portal, final UriInfo uriInfo, final User user) {
        if (user == null || user.isGuestUser()) {
            return null;
        }
        return new Creator(){
            {
                this.additionalName = user.getMiddleName();
                this.contentType = "UserAccount";
                this.familyName = user.getLastName();
                this.givenName = user.getFirstName();
                this.id = user.getUserId();
                this.name = user.getFullName();
                this.setImage((UnsafeSupplier<String, Exception>)((UnsafeSupplier)() -> {
                    if (user.getPortraitId() == 0L) {
                        return null;
                    }
                    ThemeDisplay themeDisplay = new ThemeDisplay(){
                        {
                            this.setPathImage(portal.getPathImage());
                        }
                    };
                    return user.getPortraitURL(themeDisplay);
                }));
                this.setProfileURL((UnsafeSupplier<String, Exception>)((UnsafeSupplier)() -> {
                    if (uriInfo == null) {
                        return null;
                    }
                    MultivaluedMap queryParameters = uriInfo.getQueryParameters();
                    String nestedFields = (String)queryParameters.getFirst((Object)"nestedFields");
                    if (nestedFields == null || !nestedFields.contains("profileURL")) {
                        return null;
                    }
                    final Group group = user.getGroup();
                    ThemeDisplay themeDisplay = new ThemeDisplay(){
                        {
                            this.setPortalURL("");
                            this.setSiteGroupId(group.getGroupId());
                        }
                    };
                    return group.getDisplayURL(themeDisplay);
                }));
            }
        };
    }
}

