/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.liferay.headless.delivery.dto.v1_0.CollectionConfig;
import com.liferay.headless.delivery.dto.v1_0.CollectionViewport;
import com.liferay.headless.delivery.dto.v1_0.EmptyCollectionConfig;
import com.liferay.headless.delivery.dto.v1_0.FragmentStyle;
import com.liferay.headless.delivery.dto.v1_0.FragmentViewport;
import com.liferay.headless.delivery.dto.v1_0.Layout;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.validation.Valid;
import javax.xml.bind.annotation.XmlRootElement;

@GraphQLName(description="Represents a definition of a Page Collection.", value="PageCollectionDefinition")
@JsonFilter(value="Liferay.Vulcan")
@XmlRootElement(name="PageCollectionDefinition")
public class PageCollectionDefinition
implements Serializable {
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected CollectionConfig collectionConfig;
    @GraphQLField(description="A list of viewports of the page collection.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="A list of viewports of the page collection.") CollectionViewport[] collectionViewports;
    @GraphQLField(description="Whether to show all items when pagination is disabled.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="Whether to show all items when pagination is disabled.") Boolean displayAllItems;
    @GraphQLField(description="Whether to show all pages when pagination is enabled.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="Whether to show all pages when pagination is enabled.") Boolean displayAllPages;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected EmptyCollectionConfig emptyCollectionConfig;
    @GraphQLField(description="The fragment style of the page collection.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The fragment style of the page collection.") FragmentStyle fragmentStyle;
    @GraphQLField(description="The fragment viewports of the page collection.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The fragment viewports of the page collection.") FragmentViewport[] fragmentViewports;
    @GraphQLField(description="the page section's layout.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="the page section's layout.") Layout layout;
    @GraphQLField(description="The style of a list of items in the page collection.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The style of a list of items in the page collection.") String listItemStyle;
    @GraphQLField(description="The style of a list in the page collection.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The style of a list in the page collection.") String listStyle;
    @GraphQLField(description="The custom name of a Page Collection.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The custom name of a Page Collection.") String name;
    @GraphQLField(description="The number of columns in the page collection.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The number of columns in the page collection.") Integer numberOfColumns;
    @GraphQLField(description="The maximum number of items to display in the page collection when pagination is disabled.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The maximum number of items to display in the page collection when pagination is disabled.") Integer numberOfItems;
    @GraphQLField(description="The number of items per page in the page collection.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The number of items per page in the page collection.") Integer numberOfItemsPerPage;
    @GraphQLField(description="The maximum number of pages to show when pagination is enabled.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The maximum number of pages to show when pagination is enabled.") Integer numberOfPages;
    @GraphQLField(description="The type of pagination.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The type of pagination.") PaginationType paginationType;
    @Deprecated
    @GraphQLField(description="Whether to show all items when pagination is enabled. Deprecated as of Cavanaugh (7.4.x), replaced by displayAllPages")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="Whether to show all items when pagination is enabled. Deprecated as of Cavanaugh (7.4.x), replaced by displayAllPages") Boolean showAllItems;
    @GraphQLField(description="The page collection's template key.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The page collection's template key.") String templateKey;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, defaultValue="com.liferay.headless.delivery.dto.v1_0.PageCollectionDefinition", name="x-class-name")
    public String xClassName;
    private static final String[][] _JSON_ESCAPE_STRINGS = new String[][]{{"\\", "\"", "\b", "\f", "\n", "\r", "\t"}, {"\\\\", "\\\"", "\\b", "\\f", "\\n", "\\r", "\\t"}};

    public static PageCollectionDefinition toDTO(String json) {
        return (PageCollectionDefinition)ObjectMapperUtil.readValue(PageCollectionDefinition.class, (String)json);
    }

    public static PageCollectionDefinition unsafeToDTO(String json) {
        return (PageCollectionDefinition)ObjectMapperUtil.unsafeReadValue(PageCollectionDefinition.class, (String)json);
    }

    @Schema
    @Valid
    public CollectionConfig getCollectionConfig() {
        return this.collectionConfig;
    }

    public void setCollectionConfig(CollectionConfig collectionConfig) {
        this.collectionConfig = collectionConfig;
    }

    @JsonIgnore
    public void setCollectionConfig(UnsafeSupplier<CollectionConfig, Exception> collectionConfigUnsafeSupplier) {
        try {
            this.collectionConfig = (CollectionConfig)collectionConfigUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="A list of viewports of the page collection.")
    @Valid
    public CollectionViewport[] getCollectionViewports() {
        return this.collectionViewports;
    }

    public void setCollectionViewports(CollectionViewport[] collectionViewports) {
        this.collectionViewports = collectionViewports;
    }

    @JsonIgnore
    public void setCollectionViewports(UnsafeSupplier<CollectionViewport[], Exception> collectionViewportsUnsafeSupplier) {
        try {
            this.collectionViewports = (CollectionViewport[])collectionViewportsUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="Whether to show all items when pagination is disabled.")
    public Boolean getDisplayAllItems() {
        return this.displayAllItems;
    }

    public void setDisplayAllItems(Boolean displayAllItems) {
        this.displayAllItems = displayAllItems;
    }

    @JsonIgnore
    public void setDisplayAllItems(UnsafeSupplier<Boolean, Exception> displayAllItemsUnsafeSupplier) {
        try {
            this.displayAllItems = (Boolean)displayAllItemsUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="Whether to show all pages when pagination is enabled.")
    public Boolean getDisplayAllPages() {
        return this.displayAllPages;
    }

    public void setDisplayAllPages(Boolean displayAllPages) {
        this.displayAllPages = displayAllPages;
    }

    @JsonIgnore
    public void setDisplayAllPages(UnsafeSupplier<Boolean, Exception> displayAllPagesUnsafeSupplier) {
        try {
            this.displayAllPages = (Boolean)displayAllPagesUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema
    @Valid
    public EmptyCollectionConfig getEmptyCollectionConfig() {
        return this.emptyCollectionConfig;
    }

    public void setEmptyCollectionConfig(EmptyCollectionConfig emptyCollectionConfig) {
        this.emptyCollectionConfig = emptyCollectionConfig;
    }

    @JsonIgnore
    public void setEmptyCollectionConfig(UnsafeSupplier<EmptyCollectionConfig, Exception> emptyCollectionConfigUnsafeSupplier) {
        try {
            this.emptyCollectionConfig = (EmptyCollectionConfig)emptyCollectionConfigUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The fragment style of the page collection.")
    @Valid
    public FragmentStyle getFragmentStyle() {
        return this.fragmentStyle;
    }

    public void setFragmentStyle(FragmentStyle fragmentStyle) {
        this.fragmentStyle = fragmentStyle;
    }

    @JsonIgnore
    public void setFragmentStyle(UnsafeSupplier<FragmentStyle, Exception> fragmentStyleUnsafeSupplier) {
        try {
            this.fragmentStyle = (FragmentStyle)fragmentStyleUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The fragment viewports of the page collection.")
    @Valid
    public FragmentViewport[] getFragmentViewports() {
        return this.fragmentViewports;
    }

    public void setFragmentViewports(FragmentViewport[] fragmentViewports) {
        this.fragmentViewports = fragmentViewports;
    }

    @JsonIgnore
    public void setFragmentViewports(UnsafeSupplier<FragmentViewport[], Exception> fragmentViewportsUnsafeSupplier) {
        try {
            this.fragmentViewports = (FragmentViewport[])fragmentViewportsUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="the page section's layout.")
    @Valid
    public Layout getLayout() {
        return this.layout;
    }

    public void setLayout(Layout layout) {
        this.layout = layout;
    }

    @JsonIgnore
    public void setLayout(UnsafeSupplier<Layout, Exception> layoutUnsafeSupplier) {
        try {
            this.layout = (Layout)layoutUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The style of a list of items in the page collection.")
    public String getListItemStyle() {
        return this.listItemStyle;
    }

    public void setListItemStyle(String listItemStyle) {
        this.listItemStyle = listItemStyle;
    }

    @JsonIgnore
    public void setListItemStyle(UnsafeSupplier<String, Exception> listItemStyleUnsafeSupplier) {
        try {
            this.listItemStyle = (String)listItemStyleUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The style of a list in the page collection.")
    public String getListStyle() {
        return this.listStyle;
    }

    public void setListStyle(String listStyle) {
        this.listStyle = listStyle;
    }

    @JsonIgnore
    public void setListStyle(UnsafeSupplier<String, Exception> listStyleUnsafeSupplier) {
        try {
            this.listStyle = (String)listStyleUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The custom name of a Page Collection.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @JsonIgnore
    public void setName(UnsafeSupplier<String, Exception> nameUnsafeSupplier) {
        try {
            this.name = (String)nameUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The number of columns in the page collection.")
    public Integer getNumberOfColumns() {
        return this.numberOfColumns;
    }

    public void setNumberOfColumns(Integer numberOfColumns) {
        this.numberOfColumns = numberOfColumns;
    }

    @JsonIgnore
    public void setNumberOfColumns(UnsafeSupplier<Integer, Exception> numberOfColumnsUnsafeSupplier) {
        try {
            this.numberOfColumns = (Integer)numberOfColumnsUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The maximum number of items to display in the page collection when pagination is disabled.")
    public Integer getNumberOfItems() {
        return this.numberOfItems;
    }

    public void setNumberOfItems(Integer numberOfItems) {
        this.numberOfItems = numberOfItems;
    }

    @JsonIgnore
    public void setNumberOfItems(UnsafeSupplier<Integer, Exception> numberOfItemsUnsafeSupplier) {
        try {
            this.numberOfItems = (Integer)numberOfItemsUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The number of items per page in the page collection.")
    public Integer getNumberOfItemsPerPage() {
        return this.numberOfItemsPerPage;
    }

    public void setNumberOfItemsPerPage(Integer numberOfItemsPerPage) {
        this.numberOfItemsPerPage = numberOfItemsPerPage;
    }

    @JsonIgnore
    public void setNumberOfItemsPerPage(UnsafeSupplier<Integer, Exception> numberOfItemsPerPageUnsafeSupplier) {
        try {
            this.numberOfItemsPerPage = (Integer)numberOfItemsPerPageUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The maximum number of pages to show when pagination is enabled.")
    public Integer getNumberOfPages() {
        return this.numberOfPages;
    }

    public void setNumberOfPages(Integer numberOfPages) {
        this.numberOfPages = numberOfPages;
    }

    @JsonIgnore
    public void setNumberOfPages(UnsafeSupplier<Integer, Exception> numberOfPagesUnsafeSupplier) {
        try {
            this.numberOfPages = (Integer)numberOfPagesUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The type of pagination.")
    @Valid
    public PaginationType getPaginationType() {
        return this.paginationType;
    }

    @JsonIgnore
    public String getPaginationTypeAsString() {
        if (this.paginationType == null) {
            return null;
        }
        return this.paginationType.toString();
    }

    public void setPaginationType(PaginationType paginationType) {
        this.paginationType = paginationType;
    }

    @JsonIgnore
    public void setPaginationType(UnsafeSupplier<PaginationType, Exception> paginationTypeUnsafeSupplier) {
        try {
            this.paginationType = (PaginationType)((Object)paginationTypeUnsafeSupplier.get());
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(deprecated=true, description="Whether to show all items when pagination is enabled. Deprecated as of Cavanaugh (7.4.x), replaced by displayAllPages")
    public Boolean getShowAllItems() {
        return this.showAllItems;
    }

    public void setShowAllItems(Boolean showAllItems) {
        this.showAllItems = showAllItems;
    }

    @JsonIgnore
    public void setShowAllItems(UnsafeSupplier<Boolean, Exception> showAllItemsUnsafeSupplier) {
        try {
            this.showAllItems = (Boolean)showAllItemsUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The page collection's template key.")
    public String getTemplateKey() {
        return this.templateKey;
    }

    public void setTemplateKey(String templateKey) {
        this.templateKey = templateKey;
    }

    @JsonIgnore
    public void setTemplateKey(UnsafeSupplier<String, Exception> templateKeyUnsafeSupplier) {
        try {
            this.templateKey = (String)templateKeyUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PageCollectionDefinition)) {
            return false;
        }
        PageCollectionDefinition pageCollectionDefinition = (PageCollectionDefinition)object;
        return Objects.equals(this.toString(), pageCollectionDefinition.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        int i;
        StringBundler sb = new StringBundler();
        sb.append("{");
        if (this.collectionConfig != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"collectionConfig\": ");
            sb.append(String.valueOf(this.collectionConfig));
        }
        if (this.collectionViewports != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"collectionViewports\": ");
            sb.append("[");
            for (i = 0; i < this.collectionViewports.length; ++i) {
                sb.append(String.valueOf(this.collectionViewports[i]));
                if (i + 1 >= this.collectionViewports.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if (this.displayAllItems != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"displayAllItems\": ");
            sb.append((Object)this.displayAllItems);
        }
        if (this.displayAllPages != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"displayAllPages\": ");
            sb.append((Object)this.displayAllPages);
        }
        if (this.emptyCollectionConfig != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"emptyCollectionConfig\": ");
            sb.append(String.valueOf(this.emptyCollectionConfig));
        }
        if (this.fragmentStyle != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"fragmentStyle\": ");
            sb.append(String.valueOf(this.fragmentStyle));
        }
        if (this.fragmentViewports != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"fragmentViewports\": ");
            sb.append("[");
            for (i = 0; i < this.fragmentViewports.length; ++i) {
                sb.append(String.valueOf(this.fragmentViewports[i]));
                if (i + 1 >= this.fragmentViewports.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if (this.layout != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"layout\": ");
            sb.append(String.valueOf(this.layout));
        }
        if (this.listItemStyle != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"listItemStyle\": ");
            sb.append("\"");
            sb.append(PageCollectionDefinition._escape(this.listItemStyle));
            sb.append("\"");
        }
        if (this.listStyle != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"listStyle\": ");
            sb.append("\"");
            sb.append(PageCollectionDefinition._escape(this.listStyle));
            sb.append("\"");
        }
        if (this.name != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"name\": ");
            sb.append("\"");
            sb.append(PageCollectionDefinition._escape(this.name));
            sb.append("\"");
        }
        if (this.numberOfColumns != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"numberOfColumns\": ");
            sb.append((Object)this.numberOfColumns);
        }
        if (this.numberOfItems != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"numberOfItems\": ");
            sb.append((Object)this.numberOfItems);
        }
        if (this.numberOfItemsPerPage != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"numberOfItemsPerPage\": ");
            sb.append((Object)this.numberOfItemsPerPage);
        }
        if (this.numberOfPages != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"numberOfPages\": ");
            sb.append((Object)this.numberOfPages);
        }
        if (this.paginationType != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"paginationType\": ");
            sb.append("\"");
            sb.append((Object)this.paginationType);
            sb.append("\"");
        }
        if (this.showAllItems != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"showAllItems\": ");
            sb.append((Object)this.showAllItems);
        }
        if (this.templateKey != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"templateKey\": ");
            sb.append("\"");
            sb.append(PageCollectionDefinition._escape(this.templateKey));
            sb.append("\"");
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        return StringUtil.replace((String)String.valueOf(object), (String[])_JSON_ESCAPE_STRINGS[0], (String[])_JSON_ESCAPE_STRINGS[1]);
    }

    private static boolean _isArray(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> clazz = value.getClass();
        return clazz.isArray();
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(PageCollectionDefinition._escape(entry.getKey()));
            sb.append("\": ");
            Object value = entry.getValue();
            if (PageCollectionDefinition._isArray(value)) {
                sb.append("[");
                Object[] valueArray = (Object[])value;
                for (int i = 0; i < valueArray.length; ++i) {
                    if (valueArray[i] instanceof String) {
                        sb.append("\"");
                        sb.append(valueArray[i]);
                        sb.append("\"");
                    } else {
                        sb.append(valueArray[i]);
                    }
                    if (i + 1 >= valueArray.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof Map) {
                sb.append(PageCollectionDefinition._toJSON((Map)value));
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(PageCollectionDefinition._escape(value));
                sb.append("\"");
            } else {
                sb.append(value);
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }

    @GraphQLName(value="PaginationType")
    public static enum PaginationType {
        NONE("None"),
        NUMERIC("Numeric"),
        REGULAR("Regular"),
        SIMPLE("Simple");

        private final String _value;

        @JsonCreator
        public static PaginationType create(String value) {
            if (value == null || value.equals("")) {
                return null;
            }
            for (PaginationType paginationType : PaginationType.values()) {
                if (!Objects.equals(paginationType.getValue(), value)) continue;
                return paginationType;
            }
            throw new IllegalArgumentException("Invalid enum value: " + value);
        }

        @JsonValue
        public String getValue() {
            return this._value;
        }

        public String toString() {
            return this._value;
        }

        private PaginationType(String value) {
            this._value = value;
        }
    }
}

