/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.liferay.headless.delivery.dto.v1_0.AggregateRating;
import com.liferay.headless.delivery.dto.v1_0.Creator;
import com.liferay.headless.delivery.dto.v1_0.CreatorStatistics;
import com.liferay.headless.delivery.dto.v1_0.CustomField;
import com.liferay.headless.delivery.dto.v1_0.RelatedContent;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.validation.Valid;
import javax.xml.bind.annotation.XmlRootElement;

@GraphQLName(value="MessageBoardMessage")
@JsonFilter(value="Liferay.Vulcan")
@XmlRootElement(name="MessageBoardMessage")
public class MessageBoardMessage {
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected Map<String, Map<String, String>> actions;
    @GraphQLField(description="The message's average rating.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The message's average rating.") AggregateRating aggregateRating;
    @GraphQLField(description="A flag that indicates whether the message's author is anonymous.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="A flag that indicates whether the message's author is anonymous.") Boolean anonymous;
    @GraphQLField(description="The message's main content.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The message's main content.") String articleBody;
    @GraphQLField(description="The message's author.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The message's author.") Creator creator;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected CreatorStatistics creatorStatistics;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected CustomField[] customFields;
    @GraphQLField(description="The date the message was created.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The date the message was created.") Date dateCreated;
    @GraphQLField(description="The last time the content or metadata of the message was changed.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The last time the content or metadata of the message was changed.") Date dateModified;
    @GraphQLField(description="The message's media format (e.g., HTML, BBCode, etc.).")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The message's media format (e.g., HTML, BBCode, etc.).") String encodingFormat;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected String friendlyUrlPath;
    @GraphQLField(description="The message's main title.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The message's main title.") String headline;
    @GraphQLField(description="The message's ID.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The message's ID.") Long id;
    @GraphQLField(description="A list of keywords describing the message.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="A list of keywords describing the message.") String[] keywords;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Long messageBoardSectionId;
    @GraphQLField(description="The ID of the Message Board Thread to which this message is scoped.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The ID of the Message Board Thread to which this message is scoped.") Long messageBoardThreadId;
    @GraphQLField(description="The number of the message's attachments.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The number of the message's attachments.") Integer numberOfMessageBoardAttachments;
    @GraphQLField(description="The number of the message's child messages.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The number of the message's child messages.") Integer numberOfMessageBoardMessages;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Long parentMessageBoardMessageId;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected RelatedContent[] relatedContents;
    @GraphQLField(description="A flag that indicates whether the message is answering a question.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="A flag that indicates whether the message is answering a question.") Boolean showAsAnswer;
    @GraphQLField(description="The ID of the site to which this message is scoped.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The ID of the site to which this message is scoped.") Long siteId;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected Boolean subscribed;
    @GraphQLField(description="A write-only property that specifies the default permissions.")
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    protected @GraphQLField(description="A write-only property that specifies the default permissions.") ViewableBy viewableBy;
    @Schema(defaultValue="com.liferay.headless.delivery.dto.v1_0.MessageBoardMessage", name="x-class-name")
    public String xClassName;

    public static MessageBoardMessage toDTO(String json) {
        return (MessageBoardMessage)ObjectMapperUtil.readValue(MessageBoardMessage.class, (String)json);
    }

    @Schema
    @Valid
    public Map<String, Map<String, String>> getActions() {
        return this.actions;
    }

    public void setActions(Map<String, Map<String, String>> actions) {
        this.actions = actions;
    }

    @JsonIgnore
    public void setActions(UnsafeSupplier<Map<String, Map<String, String>>, Exception> actionsUnsafeSupplier) {
        try {
            this.actions = (Map)actionsUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The message's average rating.")
    @Valid
    public AggregateRating getAggregateRating() {
        return this.aggregateRating;
    }

    public void setAggregateRating(AggregateRating aggregateRating) {
        this.aggregateRating = aggregateRating;
    }

    @JsonIgnore
    public void setAggregateRating(UnsafeSupplier<AggregateRating, Exception> aggregateRatingUnsafeSupplier) {
        try {
            this.aggregateRating = (AggregateRating)aggregateRatingUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="A flag that indicates whether the message's author is anonymous.")
    public Boolean getAnonymous() {
        return this.anonymous;
    }

    public void setAnonymous(Boolean anonymous) {
        this.anonymous = anonymous;
    }

    @JsonIgnore
    public void setAnonymous(UnsafeSupplier<Boolean, Exception> anonymousUnsafeSupplier) {
        try {
            this.anonymous = (Boolean)anonymousUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The message's main content.")
    public String getArticleBody() {
        return this.articleBody;
    }

    public void setArticleBody(String articleBody) {
        this.articleBody = articleBody;
    }

    @JsonIgnore
    public void setArticleBody(UnsafeSupplier<String, Exception> articleBodyUnsafeSupplier) {
        try {
            this.articleBody = (String)articleBodyUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The message's author.")
    @Valid
    public Creator getCreator() {
        return this.creator;
    }

    public void setCreator(Creator creator) {
        this.creator = creator;
    }

    @JsonIgnore
    public void setCreator(UnsafeSupplier<Creator, Exception> creatorUnsafeSupplier) {
        try {
            this.creator = (Creator)creatorUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema
    @Valid
    public CreatorStatistics getCreatorStatistics() {
        return this.creatorStatistics;
    }

    public void setCreatorStatistics(CreatorStatistics creatorStatistics) {
        this.creatorStatistics = creatorStatistics;
    }

    @JsonIgnore
    public void setCreatorStatistics(UnsafeSupplier<CreatorStatistics, Exception> creatorStatisticsUnsafeSupplier) {
        try {
            this.creatorStatistics = (CreatorStatistics)creatorStatisticsUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema
    @Valid
    public CustomField[] getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(CustomField[] customFields) {
        this.customFields = customFields;
    }

    @JsonIgnore
    public void setCustomFields(UnsafeSupplier<CustomField[], Exception> customFieldsUnsafeSupplier) {
        try {
            this.customFields = (CustomField[])customFieldsUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The date the message was created.")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    @JsonIgnore
    public void setDateCreated(UnsafeSupplier<Date, Exception> dateCreatedUnsafeSupplier) {
        try {
            this.dateCreated = (Date)dateCreatedUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The last time the content or metadata of the message was changed.")
    public Date getDateModified() {
        return this.dateModified;
    }

    public void setDateModified(Date dateModified) {
        this.dateModified = dateModified;
    }

    @JsonIgnore
    public void setDateModified(UnsafeSupplier<Date, Exception> dateModifiedUnsafeSupplier) {
        try {
            this.dateModified = (Date)dateModifiedUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The message's media format (e.g., HTML, BBCode, etc.).")
    public String getEncodingFormat() {
        return this.encodingFormat;
    }

    public void setEncodingFormat(String encodingFormat) {
        this.encodingFormat = encodingFormat;
    }

    @JsonIgnore
    public void setEncodingFormat(UnsafeSupplier<String, Exception> encodingFormatUnsafeSupplier) {
        try {
            this.encodingFormat = (String)encodingFormatUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema
    public String getFriendlyUrlPath() {
        return this.friendlyUrlPath;
    }

    public void setFriendlyUrlPath(String friendlyUrlPath) {
        this.friendlyUrlPath = friendlyUrlPath;
    }

    @JsonIgnore
    public void setFriendlyUrlPath(UnsafeSupplier<String, Exception> friendlyUrlPathUnsafeSupplier) {
        try {
            this.friendlyUrlPath = (String)friendlyUrlPathUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The message's main title.")
    public String getHeadline() {
        return this.headline;
    }

    public void setHeadline(String headline) {
        this.headline = headline;
    }

    @JsonIgnore
    public void setHeadline(UnsafeSupplier<String, Exception> headlineUnsafeSupplier) {
        try {
            this.headline = (String)headlineUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The message's ID.")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @JsonIgnore
    public void setId(UnsafeSupplier<Long, Exception> idUnsafeSupplier) {
        try {
            this.id = (Long)idUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="A list of keywords describing the message.")
    public String[] getKeywords() {
        return this.keywords;
    }

    public void setKeywords(String[] keywords) {
        this.keywords = keywords;
    }

    @JsonIgnore
    public void setKeywords(UnsafeSupplier<String[], Exception> keywordsUnsafeSupplier) {
        try {
            this.keywords = (String[])keywordsUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema
    public Long getMessageBoardSectionId() {
        return this.messageBoardSectionId;
    }

    public void setMessageBoardSectionId(Long messageBoardSectionId) {
        this.messageBoardSectionId = messageBoardSectionId;
    }

    @JsonIgnore
    public void setMessageBoardSectionId(UnsafeSupplier<Long, Exception> messageBoardSectionIdUnsafeSupplier) {
        try {
            this.messageBoardSectionId = (Long)messageBoardSectionIdUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The ID of the Message Board Thread to which this message is scoped.")
    public Long getMessageBoardThreadId() {
        return this.messageBoardThreadId;
    }

    public void setMessageBoardThreadId(Long messageBoardThreadId) {
        this.messageBoardThreadId = messageBoardThreadId;
    }

    @JsonIgnore
    public void setMessageBoardThreadId(UnsafeSupplier<Long, Exception> messageBoardThreadIdUnsafeSupplier) {
        try {
            this.messageBoardThreadId = (Long)messageBoardThreadIdUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The number of the message's attachments.")
    public Integer getNumberOfMessageBoardAttachments() {
        return this.numberOfMessageBoardAttachments;
    }

    public void setNumberOfMessageBoardAttachments(Integer numberOfMessageBoardAttachments) {
        this.numberOfMessageBoardAttachments = numberOfMessageBoardAttachments;
    }

    @JsonIgnore
    public void setNumberOfMessageBoardAttachments(UnsafeSupplier<Integer, Exception> numberOfMessageBoardAttachmentsUnsafeSupplier) {
        try {
            this.numberOfMessageBoardAttachments = (Integer)numberOfMessageBoardAttachmentsUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The number of the message's child messages.")
    public Integer getNumberOfMessageBoardMessages() {
        return this.numberOfMessageBoardMessages;
    }

    public void setNumberOfMessageBoardMessages(Integer numberOfMessageBoardMessages) {
        this.numberOfMessageBoardMessages = numberOfMessageBoardMessages;
    }

    @JsonIgnore
    public void setNumberOfMessageBoardMessages(UnsafeSupplier<Integer, Exception> numberOfMessageBoardMessagesUnsafeSupplier) {
        try {
            this.numberOfMessageBoardMessages = (Integer)numberOfMessageBoardMessagesUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema
    public Long getParentMessageBoardMessageId() {
        return this.parentMessageBoardMessageId;
    }

    public void setParentMessageBoardMessageId(Long parentMessageBoardMessageId) {
        this.parentMessageBoardMessageId = parentMessageBoardMessageId;
    }

    @JsonIgnore
    public void setParentMessageBoardMessageId(UnsafeSupplier<Long, Exception> parentMessageBoardMessageIdUnsafeSupplier) {
        try {
            this.parentMessageBoardMessageId = (Long)parentMessageBoardMessageIdUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema
    @Valid
    public RelatedContent[] getRelatedContents() {
        return this.relatedContents;
    }

    public void setRelatedContents(RelatedContent[] relatedContents) {
        this.relatedContents = relatedContents;
    }

    @JsonIgnore
    public void setRelatedContents(UnsafeSupplier<RelatedContent[], Exception> relatedContentsUnsafeSupplier) {
        try {
            this.relatedContents = (RelatedContent[])relatedContentsUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="A flag that indicates whether the message is answering a question.")
    public Boolean getShowAsAnswer() {
        return this.showAsAnswer;
    }

    public void setShowAsAnswer(Boolean showAsAnswer) {
        this.showAsAnswer = showAsAnswer;
    }

    @JsonIgnore
    public void setShowAsAnswer(UnsafeSupplier<Boolean, Exception> showAsAnswerUnsafeSupplier) {
        try {
            this.showAsAnswer = (Boolean)showAsAnswerUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The ID of the site to which this message is scoped.")
    public Long getSiteId() {
        return this.siteId;
    }

    public void setSiteId(Long siteId) {
        this.siteId = siteId;
    }

    @JsonIgnore
    public void setSiteId(UnsafeSupplier<Long, Exception> siteIdUnsafeSupplier) {
        try {
            this.siteId = (Long)siteIdUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema
    public Boolean getSubscribed() {
        return this.subscribed;
    }

    public void setSubscribed(Boolean subscribed) {
        this.subscribed = subscribed;
    }

    @JsonIgnore
    public void setSubscribed(UnsafeSupplier<Boolean, Exception> subscribedUnsafeSupplier) {
        try {
            this.subscribed = (Boolean)subscribedUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="A write-only property that specifies the default permissions.")
    @Valid
    public ViewableBy getViewableBy() {
        return this.viewableBy;
    }

    @JsonIgnore
    public String getViewableByAsString() {
        if (this.viewableBy == null) {
            return null;
        }
        return this.viewableBy.toString();
    }

    public void setViewableBy(ViewableBy viewableBy) {
        this.viewableBy = viewableBy;
    }

    @JsonIgnore
    public void setViewableBy(UnsafeSupplier<ViewableBy, Exception> viewableByUnsafeSupplier) {
        try {
            this.viewableBy = (ViewableBy)((Object)viewableByUnsafeSupplier.get());
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MessageBoardMessage)) {
            return false;
        }
        MessageBoardMessage messageBoardMessage = (MessageBoardMessage)object;
        return Objects.equals(this.toString(), messageBoardMessage.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        int i;
        StringBundler sb = new StringBundler();
        sb.append("{");
        SimpleDateFormat liferayToJSONDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        if (this.actions != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"actions\": ");
            sb.append(MessageBoardMessage._toJSON(this.actions));
        }
        if (this.aggregateRating != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"aggregateRating\": ");
            sb.append(String.valueOf(this.aggregateRating));
        }
        if (this.anonymous != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"anonymous\": ");
            sb.append((Object)this.anonymous);
        }
        if (this.articleBody != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"articleBody\": ");
            sb.append("\"");
            sb.append(MessageBoardMessage._escape(this.articleBody));
            sb.append("\"");
        }
        if (this.creator != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"creator\": ");
            sb.append(String.valueOf(this.creator));
        }
        if (this.creatorStatistics != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"creatorStatistics\": ");
            sb.append(String.valueOf(this.creatorStatistics));
        }
        if (this.customFields != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"customFields\": ");
            sb.append("[");
            for (i = 0; i < this.customFields.length; ++i) {
                sb.append(String.valueOf(this.customFields[i]));
                if (i + 1 >= this.customFields.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if (this.dateCreated != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"dateCreated\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(this.dateCreated));
            sb.append("\"");
        }
        if (this.dateModified != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"dateModified\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(this.dateModified));
            sb.append("\"");
        }
        if (this.encodingFormat != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"encodingFormat\": ");
            sb.append("\"");
            sb.append(MessageBoardMessage._escape(this.encodingFormat));
            sb.append("\"");
        }
        if (this.friendlyUrlPath != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"friendlyUrlPath\": ");
            sb.append("\"");
            sb.append(MessageBoardMessage._escape(this.friendlyUrlPath));
            sb.append("\"");
        }
        if (this.headline != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"headline\": ");
            sb.append("\"");
            sb.append(MessageBoardMessage._escape(this.headline));
            sb.append("\"");
        }
        if (this.id != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"id\": ");
            sb.append((Object)this.id);
        }
        if (this.keywords != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"keywords\": ");
            sb.append("[");
            for (i = 0; i < this.keywords.length; ++i) {
                sb.append("\"");
                sb.append(MessageBoardMessage._escape(this.keywords[i]));
                sb.append("\"");
                if (i + 1 >= this.keywords.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if (this.messageBoardSectionId != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"messageBoardSectionId\": ");
            sb.append((Object)this.messageBoardSectionId);
        }
        if (this.messageBoardThreadId != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"messageBoardThreadId\": ");
            sb.append((Object)this.messageBoardThreadId);
        }
        if (this.numberOfMessageBoardAttachments != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"numberOfMessageBoardAttachments\": ");
            sb.append((Object)this.numberOfMessageBoardAttachments);
        }
        if (this.numberOfMessageBoardMessages != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"numberOfMessageBoardMessages\": ");
            sb.append((Object)this.numberOfMessageBoardMessages);
        }
        if (this.parentMessageBoardMessageId != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"parentMessageBoardMessageId\": ");
            sb.append((Object)this.parentMessageBoardMessageId);
        }
        if (this.relatedContents != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"relatedContents\": ");
            sb.append("[");
            for (i = 0; i < this.relatedContents.length; ++i) {
                sb.append(String.valueOf(this.relatedContents[i]));
                if (i + 1 >= this.relatedContents.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if (this.showAsAnswer != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"showAsAnswer\": ");
            sb.append((Object)this.showAsAnswer);
        }
        if (this.siteId != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"siteId\": ");
            sb.append((Object)this.siteId);
        }
        if (this.subscribed != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"subscribed\": ");
            sb.append((Object)this.subscribed);
        }
        if (this.viewableBy != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"viewableBy\": ");
            sb.append("\"");
            sb.append((Object)this.viewableBy);
            sb.append("\"");
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        String string = String.valueOf(object);
        return string.replaceAll("\"", "\\\\\"");
    }

    private static boolean _isArray(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> clazz = value.getClass();
        return clazz.isArray();
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(entry.getKey());
            sb.append("\":");
            Object value = entry.getValue();
            if (MessageBoardMessage._isArray(value)) {
                sb.append("[");
                Object[] valueArray = (Object[])value;
                for (int i = 0; i < valueArray.length; ++i) {
                    if (valueArray[i] instanceof String) {
                        sb.append("\"");
                        sb.append(valueArray[i]);
                        sb.append("\"");
                    } else {
                        sb.append(valueArray[i]);
                    }
                    if (i + 1 >= valueArray.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof Map) {
                sb.append(MessageBoardMessage._toJSON((Map)value));
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(value);
                sb.append("\"");
            } else {
                sb.append(value);
            }
            if (!iterator.hasNext()) continue;
            sb.append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @GraphQLName(value="ViewableBy")
    public static enum ViewableBy {
        ANYONE("Anyone"),
        MEMBERS("Members"),
        OWNER("Owner");

        private final String _value;

        @JsonCreator
        public static ViewableBy create(String value) {
            for (ViewableBy viewableBy : ViewableBy.values()) {
                if (!Objects.equals(viewableBy.getValue(), value)) continue;
                return viewableBy;
            }
            return null;
        }

        @JsonValue
        public String getValue() {
            return this._value;
        }

        public String toString() {
            return this._value;
        }

        private ViewableBy(String value) {
            this._value = value;
        }
    }
}

