/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.common.spi.service.context;

import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.permission.ModelPermissions;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class ServiceContextBuilder {
    private final ServiceContext _serviceContext = new ServiceContext();

    public static ServiceContextBuilder create(long groupId, HttpServletRequest httpServletRequest, String viewableBy) {
        return new ServiceContextBuilder(groupId, httpServletRequest, viewableBy);
    }

    public ServiceContextBuilder assetCategoryIds(Long[] assetCategoryIds) {
        if (assetCategoryIds != null) {
            this._serviceContext.setAssetCategoryIds(ArrayUtil.toArray((Long[])assetCategoryIds));
        }
        return this;
    }

    public ServiceContextBuilder assetTagNames(String[] assetTagNames) {
        this._serviceContext.setAssetTagNames(assetTagNames);
        return this;
    }

    public ServiceContext build() {
        return this._serviceContext;
    }

    public ServiceContextBuilder expandoBridgeAttributes(Map<String, Serializable> expandoBridgeAttributes) {
        if (expandoBridgeAttributes != null) {
            this._serviceContext.setExpandoBridgeAttributes(expandoBridgeAttributes);
        }
        return this;
    }

    public ServiceContextBuilder permissions(ModelPermissions modelPermissions) {
        if (!this._serviceContext.isAddGroupPermissions() && !this._serviceContext.isAddGuestPermissions()) {
            this._serviceContext.setModelPermissions(modelPermissions);
        }
        return this;
    }

    private ServiceContextBuilder(long groupId, HttpServletRequest httpServletRequest, String viewableBy) {
        if (httpServletRequest != null) {
            HashMap<String, String> headers = new HashMap<String, String>();
            Enumeration enumeration = httpServletRequest.getHeaderNames();
            while (enumeration.hasMoreElements()) {
                String header = (String)enumeration.nextElement();
                String value = httpServletRequest.getHeader(header);
                headers.put(header, value);
            }
            this._serviceContext.setHeaders(headers);
        }
        if (StringUtil.equalsIgnoreCase((String)viewableBy, (String)"anyone")) {
            this._serviceContext.setAddGroupPermissions(true);
            this._serviceContext.setAddGuestPermissions(true);
        } else if (StringUtil.equalsIgnoreCase((String)viewableBy, (String)"members")) {
            this._serviceContext.setAddGroupPermissions(true);
            this._serviceContext.setAddGuestPermissions(false);
        } else {
            this._serviceContext.setAddGroupPermissions(false);
            this._serviceContext.setAddGuestPermissions(false);
        }
        this._serviceContext.setScopeGroupId(groupId);
    }
}

